/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.errorparsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.internal.errorparsers.AbstractErrorParser;
import org.eclipse.cdt.internal.errorparsers.ErrorPattern;
import org.eclipse.cdt.internal.errorparsers.Messages;

public class GCCErrorParser
extends AbstractErrorParser {
    private static final Pattern[] varPatterns = new Pattern[]{Pattern.compile(Messages.GCCErrorParser_varPattern_undeclared), Pattern.compile(Messages.GCCErrorParser_varPattern_defdNotUsed), Pattern.compile(Messages.GCCErrorParser_varPattern_conflictTypes), Pattern.compile(Messages.GCCErrorParser_varPattern_parseError)};
    private static final ErrorPattern[] patterns = new ErrorPattern[]{new ErrorPattern(Messages.GCCErrorParser_skip_UndeclaredOnlyOnce), new ErrorPattern(Messages.GCCErrorParser_skip_forEachFunction), new ErrorPattern(Messages.GCCErrorParser_skip_note), new ErrorPattern(Messages.GCCErrorParser_sikp_instantiatedFromHere), new ErrorPattern(Messages.GCCErrorParser_Warnings, 1, 2, 5, 0, 0){

        public String getVarName(Matcher matcher) {
            String desc = this.getDesc(matcher);
            if (desc == null) {
                return null;
            }
            int i = 0;
            while (i < varPatterns.length) {
                Matcher varMatcher = varPatterns[i].matcher(desc);
                if (varMatcher.find()) {
                    return varMatcher.group(1);
                }
                ++i;
            }
            return null;
        }

        public int getSeverity(Matcher matcher) {
            String warningGroup = matcher.group(4);
            if (warningGroup != null && warningGroup.indexOf("arning") >= 0) {
                return 1;
            }
            return 2;
        }
    }};

    public GCCErrorParser() {
        super(patterns);
    }
}

