/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.tests;

import java.io.IOException;
import junit.framework.Test;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDIFunctionLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILineLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDILocator;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIFunctionBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocationBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.tests.AbstractDebugTest;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.core.runtime.CoreException;

public class BreakpointTests
extends AbstractDebugTest {
    public static Test suite() {
        return new AbstractDebugTest.DebugTestWrapper(BreakpointTests.class){};
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.createDebugSession();
        BreakpointTests.assertNotNull((Object)this.currentTarget);
        this.currentTarget.deleteAllBreakpoints();
        this.pause();
    }

    protected void tearDown() throws Exception {
        targets[0].terminate();
        int x = 0;
        while (!targets[0].isTerminated() && x < 30) {
            Thread.sleep(100L);
        }
        if (!targets[0].isTerminated()) {
            targets[0].terminate();
        }
        super.tearDown();
    }

    public void testFunctionBreak() throws CoreException, MIException, IOException, CDIException, InterruptedException {
        ICDITarget cdiTarget = this.currentTarget;
        boolean caught = false;
        ICDIFunctionLocation location = cdiTarget.createFunctionLocation(null, "func1");
        BreakpointTests.assertNotNull((Object)location);
        cdiTarget.setFunctionBreakpoint(0, location, null, false);
        location = cdiTarget.createFunctionLocation(null, "main");
        BreakpointTests.assertNotNull((Object)location);
        cdiTarget.setFunctionBreakpoint(0, location, null, false);
        location = cdiTarget.createFunctionLocation(null, "badname");
        BreakpointTests.assertNotNull((Object)location);
        try {
            cdiTarget.setFunctionBreakpoint(0, location, null, false);
        }
        catch (CDIException cDIException) {
            caught = true;
        }
        BreakpointTests.assertTrue((boolean)caught);
        cdiTarget.deleteAllBreakpoints();
        location = cdiTarget.createFunctionLocation(null, "func1");
        BreakpointTests.assertNotNull((Object)location);
        cdiTarget.setFunctionBreakpoint(0, location, null, false);
        targets = session.getTargets();
        BreakpointTests.assertTrue((targets.length == 1 ? 1 : 0) != 0);
        targets[0].resume();
        int x = 0;
        while (x < 100) {
            if (targets[0].isTerminated() || targets[0].isSuspended()) break;
            Thread.sleep(100L);
            ++x;
        }
        BreakpointTests.assertTrue((boolean)targets[0].isSuspended());
        ICDILocator locator = targets[0].getCurrentThread().getStackFrames()[0].getLocator();
        BreakpointTests.assertTrue((locator.getLineNumber() == 6 ? 1 : 0) != 0);
        BreakpointTests.assertTrue((boolean)locator.getFunction().equals("func1"));
        BreakpointTests.assertTrue((boolean)locator.getFile().endsWith("main.c"));
    }

    public void testLineBreak() throws CoreException, MIException, IOException, CDIException, InterruptedException {
        ICDITarget cdiTarget = this.currentTarget;
        boolean caught = false;
        ICDILineLocation location = cdiTarget.createLineLocation("main.c", 7);
        BreakpointTests.assertNotNull((Object)location);
        cdiTarget.setLineBreakpoint(0, location, null, false);
        location = cdiTarget.createLineLocation("main.c", 18);
        BreakpointTests.assertNotNull((Object)location);
        cdiTarget.setLineBreakpoint(0, location, null, false);
        location = cdiTarget.createLineLocation("main.c", 30);
        BreakpointTests.assertNotNull((Object)location);
        try {
            cdiTarget.setLineBreakpoint(0, location, null, false);
        }
        catch (CDIException cDIException) {
            caught = true;
        }
        BreakpointTests.assertTrue((boolean)caught);
        caught = false;
        location = cdiTarget.createLineLocation("main.c", 11);
        BreakpointTests.assertNotNull((Object)location);
        cdiTarget.setLineBreakpoint(0, location, null, false);
        location = cdiTarget.createLineLocation(null, 7);
        BreakpointTests.assertNotNull((Object)location);
        cdiTarget.setLineBreakpoint(0, location, null, false);
        caught = false;
        location = cdiTarget.createLineLocation(null, 30);
        BreakpointTests.assertNotNull((Object)location);
        try {
            cdiTarget.setLineBreakpoint(0, location, null, false);
        }
        catch (CDIException cDIException) {
            caught = true;
        }
        BreakpointTests.assertTrue((String)"Ignoring line numbers with no file specified?", (boolean)caught);
        cdiTarget.deleteAllBreakpoints();
        location = cdiTarget.createLineLocation(null, 7);
        BreakpointTests.assertNotNull((Object)location);
        cdiTarget.setLineBreakpoint(0, location, null, false);
        targets = session.getTargets();
        BreakpointTests.assertTrue((targets.length == 1 ? 1 : 0) != 0);
        targets[0].resume();
        int x = 0;
        while (x < 100) {
            if (targets[0].isSuspended() || targets[0].isTerminated()) break;
            Thread.sleep(100L);
            ++x;
        }
        BreakpointTests.assertTrue((String)("Suspended: " + targets[0].isSuspended() + " Termiunated: " + targets[0].isTerminated()), (boolean)targets[0].isSuspended());
        ICDILocator locator = targets[0].getCurrentThread().getStackFrames()[0].getLocator();
        BreakpointTests.assertTrue((locator.getLineNumber() == 7 ? 1 : 0) != 0);
        BreakpointTests.assertTrue((boolean)locator.getFunction().equals("func1"));
        BreakpointTests.assertTrue((boolean)locator.getFile().endsWith("main.c"));
    }

    public void testGetBreak() throws CoreException, MIException, IOException, CDIException {
        ICDITarget cdiTarget = this.currentTarget;
        ICDIBreakpoint[] breakpoints = cdiTarget.getBreakpoints();
        BreakpointTests.assertNotNull((Object)breakpoints);
        BreakpointTests.assertTrue((breakpoints.length == 0 ? 1 : 0) != 0);
        ICDIFunctionLocation location = cdiTarget.createFunctionLocation("main.c", "func1");
        BreakpointTests.assertNotNull((Object)location);
        cdiTarget.setFunctionBreakpoint(0, location, null, false);
        breakpoints = cdiTarget.getBreakpoints();
        BreakpointTests.assertNotNull((Object)breakpoints);
        BreakpointTests.assertTrue((breakpoints.length == 1 ? 1 : 0) != 0);
        Object curbreak = breakpoints[0] instanceof ICDILocationBreakpoint ? (ICDILocationBreakpoint)breakpoints[0] : null;
        BreakpointTests.assertNotNull(curbreak);
        ICDILocator locator = curbreak.getLocator();
        String file = locator.getFile();
        String function = locator.getFunction();
        BreakpointTests.assertTrue((boolean)"main.c".equals(file));
        BreakpointTests.assertTrue((boolean)"func1".equals(function));
        location = cdiTarget.createFunctionLocation("main.c", "main");
        BreakpointTests.assertNotNull((Object)location);
        cdiTarget.setFunctionBreakpoint(0, location, null, false);
        breakpoints = cdiTarget.getBreakpoints();
        BreakpointTests.assertNotNull((Object)breakpoints);
        BreakpointTests.assertTrue((breakpoints.length == 2 ? 1 : 0) != 0);
        curbreak = breakpoints[1] instanceof ICDILocationBreakpoint ? (ICDILocationBreakpoint)breakpoints[1] : null;
        BreakpointTests.assertNotNull((Object)curbreak);
        locator = curbreak.getLocator();
        file = locator.getFile();
        function = locator.getFunction();
        BreakpointTests.assertTrue((boolean)"main.c".equals(file));
        BreakpointTests.assertTrue((boolean)"main".equals(function));
        cdiTarget.deleteAllBreakpoints();
    }

    public void testDelBreak() throws CoreException, MIException, IOException, CDIException {
        ICDILineLocation lineLocation;
        ICDITarget cdiTarget = this.currentTarget;
        ICDIBreakpoint[] breakpoints = cdiTarget.getBreakpoints();
        BreakpointTests.assertNotNull((Object)breakpoints);
        BreakpointTests.assertTrue((breakpoints.length == 0 ? 1 : 0) != 0);
        ICDIFunctionLocation location = cdiTarget.createFunctionLocation("main.c", "func1");
        BreakpointTests.assertNotNull((Object)location);
        ICDIFunctionBreakpoint curbreak = cdiTarget.setFunctionBreakpoint(0, location, null, false);
        cdiTarget.deleteBreakpoints(new ICDIBreakpoint[]{curbreak});
        this.pause();
        breakpoints = cdiTarget.getBreakpoints();
        BreakpointTests.assertTrue((breakpoints.length == 0 ? 1 : 0) != 0);
        location = cdiTarget.createFunctionLocation("main.c", "func1");
        BreakpointTests.assertNotNull((Object)location);
        curbreak = cdiTarget.setFunctionBreakpoint(0, location, null, false);
        ICDILocator savedLocation = curbreak.getLocator();
        location = cdiTarget.createFunctionLocation("main.c", "main");
        BreakpointTests.assertNotNull((Object)location);
        curbreak = cdiTarget.setFunctionBreakpoint(0, location, null, false);
        cdiTarget.deleteBreakpoints(new ICDIBreakpoint[]{curbreak});
        this.pause();
        breakpoints = cdiTarget.getBreakpoints();
        BreakpointTests.assertTrue((breakpoints.length == 1 ? 1 : 0) != 0);
        curbreak = (ICDILocationBreakpoint)breakpoints[0];
        BreakpointTests.assertNotNull((Object)curbreak);
        BreakpointTests.assertTrue((boolean)curbreak.getLocator().equals((ICDILocation)savedLocation));
        cdiTarget.deleteBreakpoints(new ICDIBreakpoint[]{curbreak});
        this.pause();
        breakpoints = cdiTarget.getBreakpoints();
        BreakpointTests.assertTrue((breakpoints.length == 0 ? 1 : 0) != 0);
        ICDIBreakpoint[] savedbreakpoints = new ICDIBreakpoint[1];
        int x = 0;
        while (x < 10) {
            lineLocation = cdiTarget.createLineLocation("main.c", x + 1);
            savedbreakpoints[0] = cdiTarget.setLineBreakpoint(0, lineLocation, null, false);
            BreakpointTests.assertNotNull((Object)savedbreakpoints[0]);
            ++x;
        }
        cdiTarget.deleteBreakpoints(savedbreakpoints);
        this.pause();
        breakpoints = cdiTarget.getBreakpoints();
        BreakpointTests.assertTrue((breakpoints.length == 9 ? 1 : 0) != 0);
        x = 0;
        while (x < breakpoints.length) {
            curbreak = (ICDILocationBreakpoint)breakpoints[x];
            BreakpointTests.assertTrue((curbreak.getLocator().getLineNumber() == x + 1 ? 1 : 0) != 0);
            ++x;
        }
        cdiTarget.deleteAllBreakpoints();
        this.pause();
        BreakpointTests.assertTrue((cdiTarget.getBreakpoints().length == 0 ? 1 : 0) != 0);
        savedbreakpoints = new ICDIBreakpoint[4];
        x = 0;
        while (x < 10) {
            lineLocation = cdiTarget.createLineLocation("main.c", x + 1);
            savedbreakpoints[x % 4] = cdiTarget.setLineBreakpoint(0, lineLocation, null, false);
            BreakpointTests.assertNotNull((Object)savedbreakpoints[x % 4]);
            ++x;
        }
        cdiTarget.deleteBreakpoints(savedbreakpoints);
        this.pause();
        breakpoints = cdiTarget.getBreakpoints();
        BreakpointTests.assertTrue((breakpoints.length == 6 ? 1 : 0) != 0);
        x = 0;
        while (x < breakpoints.length) {
            curbreak = (ICDILocationBreakpoint)breakpoints[x];
            BreakpointTests.assertTrue((curbreak.getLocator().getLineNumber() == x + 1 ? 1 : 0) != 0);
            ++x;
        }
        cdiTarget.deleteAllBreakpoints();
        this.pause();
        BreakpointTests.assertTrue((cdiTarget.getBreakpoints().length == 0 ? 1 : 0) != 0);
        savedbreakpoints = new ICDIBreakpoint[10];
        x = 0;
        while (x < 10) {
            lineLocation = cdiTarget.createLineLocation("main.c", x + 1);
            savedbreakpoints[x] = cdiTarget.setLineBreakpoint(0, lineLocation, null, false);
            BreakpointTests.assertNotNull((Object)savedbreakpoints[x]);
            ++x;
        }
        cdiTarget.deleteBreakpoints(savedbreakpoints);
        this.pause();
        breakpoints = cdiTarget.getBreakpoints();
        BreakpointTests.assertTrue((breakpoints.length == 0 ? 1 : 0) != 0);
        x = 0;
        while (x < 10) {
            lineLocation = cdiTarget.createLineLocation("main.c", x + 1);
            curbreak = cdiTarget.setLineBreakpoint(0, lineLocation, null, false);
            BreakpointTests.assertNotNull((Object)curbreak);
            ++x;
        }
        cdiTarget.deleteAllBreakpoints();
        this.pause();
        breakpoints = cdiTarget.getBreakpoints();
        BreakpointTests.assertTrue((breakpoints.length == 0 ? 1 : 0) != 0);
    }

    public void testCondBreak() throws CoreException, MIException, IOException, CDIException, InterruptedException {
        boolean caught = false;
        ICDITarget cdiTarget = this.currentTarget;
        ICDICondition cond = cdiTarget.createCondition(0, "");
        ICDIFunctionLocation location = cdiTarget.createFunctionLocation(null, "func1");
        BreakpointTests.assertNotNull((Object)location);
        cdiTarget.setFunctionBreakpoint(0, location, cond, false);
        cond = cdiTarget.createCondition(0, "x<10");
        location = cdiTarget.createFunctionLocation(null, "func1");
        BreakpointTests.assertNotNull((Object)location);
        cdiTarget.setFunctionBreakpoint(0, location, cond, false);
        cond = cdiTarget.createCondition(0, "nonexist<10");
        location = cdiTarget.createFunctionLocation(null, "func1");
        BreakpointTests.assertNotNull((Object)location);
        try {
            cdiTarget.setFunctionBreakpoint(0, location, cond, false);
        }
        catch (CDIException cDIException) {
            caught = true;
        }
        BreakpointTests.assertTrue((boolean)caught);
        cdiTarget.deleteAllBreakpoints();
        ICDILineLocation lineLocation = cdiTarget.createLineLocation(null, 23);
        BreakpointTests.assertNotNull((Object)location);
        cond = cdiTarget.createCondition(0, "a>10");
        cdiTarget.setLineBreakpoint(0, lineLocation, cond, false);
        targets = session.getTargets();
        BreakpointTests.assertTrue((targets.length == 1 ? 1 : 0) != 0);
        targets[0].resume();
        int x = 0;
        while (x < 100) {
            if (targets[0].isSuspended() || targets[0].isTerminated()) break;
            Thread.sleep(100L);
            ++x;
        }
        BreakpointTests.assertTrue((String)("Suspended: " + targets[0].isSuspended() + " Termiunated: " + targets[0].isTerminated()), (boolean)targets[0].isSuspended());
        ICDIStackFrame frame = targets[0].getCurrentThread().getStackFrames()[0];
        ICDILocator locator = frame.getLocator();
        BreakpointTests.assertTrue((locator.getLineNumber() == 23 ? 1 : 0) != 0);
        BreakpointTests.assertTrue((boolean)locator.getFunction().equals("main"));
        BreakpointTests.assertTrue((boolean)locator.getFile().endsWith("main.c"));
        BreakpointTests.assertTrue((String)targets[0].evaluateExpressionToString(frame, "a"), (boolean)targets[0].evaluateExpressionToString(frame, "a").equals("11"));
    }
}

