/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.ToggleBreakpointAdapter;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.part.IContributedContentsView;

public class ToggleWatchpointActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private ToggleBreakpointAdapter fBreakpointAdapter = new ToggleBreakpointAdapter();
    private IWorkbenchPart fTargetPart;
    private ISelection fSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fTargetPart = targetPart;
    }

    public void run(IAction action) {
        try {
            this.getBreakpointAdapter().toggleWatchpoints(this.getTargetPart(), this.getSelection());
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getTargetPart().getSite().getShell(), (String)ActionMessages.getString("ToggleWatchpointActionDelegate.Error_1"), (String)ActionMessages.getString("ToggleWatchpointActionDelegate.Operation_failed_1"), (IStatus)e.getStatus());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setSelection(selection);
        action.setEnabled(this.getBreakpointAdapter().canToggleWatchpoints(this.getTargetPart(), this.getSelection()));
    }

    private IWorkbenchPart getTargetPart() {
        return this.fTargetPart;
    }

    private ISelection getSelection() {
        return this.fSelection;
    }

    private IToggleBreakpointsTarget getBreakpointAdapter() {
        ToggleBreakpointAdapter targetAdapter = null;
        if (this.fTargetPart != null) {
            IWorkbenchPart contributingPart;
            IContributedContentsView contentsView;
            IResource resource = (IResource)this.fTargetPart.getAdapter(IResource.class);
            if (resource == null && this.fTargetPart instanceof IEditorPart) {
                resource = (IResource)((IEditorPart)this.fTargetPart).getEditorInput().getAdapter(IResource.class);
            }
            if (resource == null && (contentsView = (IContributedContentsView)this.fTargetPart.getAdapter(IContributedContentsView.class)) != null && (resource = (IResource)(contributingPart = contentsView.getContributingPart()).getAdapter(IResource.class)) == null && contributingPart instanceof IEditorPart) {
                resource = (IResource)((IEditorPart)contributingPart).getEditorInput().getAdapter(IResource.class);
            }
            if (resource != null) {
                targetAdapter = this.getAdapter((IAdaptable)resource);
            }
            if (targetAdapter == null) {
                targetAdapter = this.getAdapter((IAdaptable)this.fTargetPart);
            }
        }
        if (targetAdapter == null) {
            targetAdapter = this.fBreakpointAdapter;
        }
        return targetAdapter;
    }

    private IToggleBreakpointsTarget getAdapter(IAdaptable adaptable) {
        IAdapterManager adapterManager;
        IToggleBreakpointsTarget adapter = (IToggleBreakpointsTarget)adaptable.getAdapter(IToggleBreakpointsTarget.class);
        if (adapter == null && (adapterManager = Platform.getAdapterManager()).hasAdapter((Object)adaptable, IToggleBreakpointsTarget.class.getName())) {
            adapter = (IToggleBreakpointsTarget)adapterManager.loadAdapter((Object)adaptable, IToggleBreakpointsTarget.class.getName());
        }
        return adapter;
    }

    private void setSelection(ISelection selection) {
        this.fSelection = selection;
    }
}

