/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.lrparser.action.c99;

import java.util.Collections;
import java.util.List;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTFieldDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTPointer;
import org.eclipse.cdt.core.dom.ast.c.ICASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTTypeIdInitializerExpression;
import org.eclipse.cdt.core.dom.ast.c.ICASTTypedefNameSpecifier;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.core.dom.lrparser.IParser;
import org.eclipse.cdt.core.dom.lrparser.IParserActionTokenProvider;
import org.eclipse.cdt.core.dom.lrparser.action.BuildASTParserAction;
import org.eclipse.cdt.core.dom.lrparser.action.ITokenMap;
import org.eclipse.cdt.core.dom.lrparser.action.TokenMap;
import org.eclipse.cdt.core.dom.lrparser.action.c99.IC99ASTNodeFactory;
import org.eclipse.cdt.core.parser.util.CollectionUtils;
import org.eclipse.cdt.internal.core.dom.lrparser.c99.C99ExpressionParser;
import org.eclipse.cdt.internal.core.dom.lrparser.c99.C99NoCastExpressionParser;
import org.eclipse.cdt.internal.core.dom.lrparser.c99.C99Parsersym;
import org.eclipse.cdt.internal.core.dom.lrparser.c99.C99SizeofExpressionParser;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

public class C99BuildASTParserAction
extends BuildASTParserAction {
    private final ITokenMap tokenMap;
    protected final IC99ASTNodeFactory nodeFactory;

    public C99BuildASTParserAction(IC99ASTNodeFactory nodeFactory, IParserActionTokenProvider parser, IASTTranslationUnit tu) {
        super(nodeFactory, parser, tu);
        this.nodeFactory = nodeFactory;
        this.tokenMap = new TokenMap(C99Parsersym.orderedTerminalSymbols, parser.getOrderedTerminalSymbols());
    }

    private int baseKind(IToken token) {
        return this.tokenMap.mapKind(token.getKind());
    }

    protected boolean isCompletionToken(IToken token) {
        return this.baseKind(token) == 4;
    }

    protected boolean isIdentifierToken(IToken token) {
        return this.baseKind(token) == 1;
    }

    protected IParser getExpressionParser() {
        return new C99ExpressionParser(this.parser.getOrderedTerminalSymbols());
    }

    protected IParser getNoCastExpressionParser() {
        return new C99NoCastExpressionParser(this.parser.getOrderedTerminalSymbols());
    }

    protected IParser getSizeofExpressionParser() {
        return new C99SizeofExpressionParser(this.parser.getOrderedTerminalSymbols());
    }

    public void consumeExpressionFieldReference(boolean isPointerDereference) {
        IASTName name = this.createName(this.parser.getRightIToken());
        IASTExpression owner = (IASTExpression)this.astStack.pop();
        IASTFieldReference expr = this.nodeFactory.newFieldReference(name, owner, isPointerDereference);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionTypeIdInitializer() {
        this.consumeInitializerList();
        IASTInitializerList list = (IASTInitializerList)this.astStack.pop();
        IASTTypeId typeId = (IASTTypeId)this.astStack.pop();
        ICASTTypeIdInitializerExpression expr = this.nodeFactory.newCTypeIdInitializerExpression(typeId, list);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    protected void setSpecifier(ICASTDeclSpecifier node, Object specifier) {
        if (!(specifier instanceof IToken)) {
            return;
        }
        IToken token = (IToken)specifier;
        int kind = this.baseKind(token);
        switch (kind) {
            case 28: {
                node.setStorageClass(1);
                return;
            }
            case 25: {
                node.setStorageClass(2);
                return;
            }
            case 22: {
                node.setStorageClass(3);
                return;
            }
            case 24: {
                node.setStorageClass(4);
                return;
            }
            case 27: {
                node.setStorageClass(5);
                return;
            }
            case 26: {
                node.setInline(true);
                return;
            }
            case 7: {
                node.setConst(true);
                return;
            }
            case 8: {
                node.setRestrict(true);
                return;
            }
            case 9: {
                node.setVolatile(true);
                return;
            }
        }
        if (node instanceof ICASTSimpleDeclSpecifier) {
            ICASTSimpleDeclSpecifier n = (ICASTSimpleDeclSpecifier)node;
            switch (kind) {
                case 38: {
                    n.setType(1);
                    break;
                }
                case 30: {
                    n.setType(2);
                    break;
                }
                case 39: {
                    n.setType(6);
                    break;
                }
                case 33: {
                    n.setType(3);
                    break;
                }
                case 32: {
                    n.setType(4);
                    break;
                }
                case 31: {
                    n.setType(5);
                    break;
                }
                case 36: {
                    n.setSigned(true);
                    break;
                }
                case 37: {
                    n.setUnsigned(true);
                    break;
                }
                case 35: {
                    n.setShort(true);
                    break;
                }
                case 40: {
                    n.setComplex(true);
                    break;
                }
                case 34: {
                    boolean isLong = n.isLong();
                    n.setLongLong(isLong);
                    n.setLong(!isLong);
                }
            }
        }
    }

    private void collectArrayModifierTypeQualifiers(ICASTArrayModifier arrayModifier) {
        for (Object o : this.astStack.closeScope()) {
            switch (this.baseKind((IToken)o)) {
                case 7: {
                    arrayModifier.setConst(true);
                    break;
                }
                case 8: {
                    arrayModifier.setRestrict(true);
                    break;
                }
                case 9: {
                    arrayModifier.setVolatile(true);
                }
            }
        }
    }

    public void consumeDirectDeclaratorModifiedArrayModifier(boolean isStatic, boolean isVarSized, boolean hasTypeQualifierList, boolean hasAssignmentExpr) {
        assert (isStatic || isVarSized || hasTypeQualifierList);
        ICASTArrayModifier arrayModifier = this.nodeFactory.newModifiedArrayModifier();
        arrayModifier.setStatic(isStatic);
        arrayModifier.setVariableSized(isVarSized);
        if (hasAssignmentExpr) {
            arrayModifier.setConstantExpression((IASTExpression)this.astStack.pop());
        }
        if (hasTypeQualifierList) {
            this.collectArrayModifierTypeQualifiers(arrayModifier);
        }
        this.setOffsetAndLength((IASTNode)arrayModifier);
        this.astStack.push(arrayModifier);
    }

    public void consumeDirectDeclaratorFunctionDeclaratorKnR() {
        ICASTKnRFunctionDeclarator declarator = this.nodeFactory.newCKnRFunctionDeclarator();
        IASTName[] names = this.astStack.topScope().toArray(new IASTName[0]);
        declarator.setParameterNames(names);
        this.astStack.closeScope();
        int endOffset = C99BuildASTParserAction.endOffset(this.parser.getRightIToken());
        this.addFunctionModifier((IASTFunctionDeclarator)declarator, endOffset);
    }

    public void consumeIdentifierKnR() {
        IASTName name = this.createName(this.parser.getRightIToken());
        this.astStack.push(name);
    }

    public void consumePointer() {
        ICASTPointer pointer = this.nodeFactory.newCPointer();
        IToken star = this.parser.getRightIToken();
        C99BuildASTParserAction.setOffsetAndLength((IASTNode)pointer, star);
        this.astStack.push(pointer);
    }

    public void consumePointerTypeQualifierList() {
        ICASTPointer pointer = this.nodeFactory.newCPointer();
        for (Object o : this.astStack.closeScope()) {
            IToken token = (IToken)o;
            switch (this.baseKind(token)) {
                default: {
                    assert (false);
                }
                case 7: {
                    pointer.setConst(true);
                    break;
                }
                case 9: {
                    pointer.setVolatile(true);
                    break;
                }
                case 8: {
                    pointer.setRestrict(true);
                }
            }
        }
        this.setOffsetAndLength((IASTNode)pointer);
        this.astStack.push(pointer);
    }

    public void consumeDirectDeclaratorFunctionDeclarator(boolean hasDeclarator, boolean hasParameters) {
        IASTName name = this.nodeFactory.newName();
        IASTStandardFunctionDeclarator declarator = this.nodeFactory.newFunctionDeclarator(name);
        if (hasParameters) {
            boolean isVarArgs = this.astStack.pop() == PLACE_HOLDER;
            declarator.setVarArgs(isVarArgs);
            for (Object param : this.astStack.closeScope()) {
                declarator.addParameterDeclaration((IASTParameterDeclaration)param);
            }
        }
        if (hasDeclarator) {
            this.addFunctionModifier((IASTFunctionDeclarator)declarator, C99BuildASTParserAction.endOffset(this.parser.getRightIToken()));
        } else {
            this.setOffsetAndLength((IASTNode)declarator);
            this.astStack.push(declarator);
        }
    }

    public void consumeInitializerDesignated() {
        IASTInitializer initializer = (IASTInitializer)this.astStack.pop();
        ICASTDesignatedInitializer result = this.nodeFactory.newCDesignatedInitializer(initializer);
        for (Object o : this.astStack.closeScope()) {
            result.addDesignator((ICASTDesignator)o);
        }
        this.setOffsetAndLength((IASTNode)result);
        this.astStack.push(result);
    }

    public void consumeDesignatorArray() {
        IASTExpression expr = (IASTExpression)this.astStack.pop();
        ICASTArrayDesignator designator = this.nodeFactory.newCArrayDesignator(expr);
        this.setOffsetAndLength((IASTNode)designator);
        this.astStack.push(designator);
    }

    public void consumeDesignatorField() {
        IASTName name = this.createName(this.parser.getRightIToken());
        ICASTFieldDesignator designator = this.nodeFactory.newCFieldDesignator(name);
        this.setOffsetAndLength((IASTNode)designator);
        this.astStack.push(designator);
    }

    public void consumeDeclarationSpecifiersSimple() {
        ICASTSimpleDeclSpecifier declSpec = this.nodeFactory.newCSimpleDeclSpecifier();
        for (Object specifier : this.astStack.closeScope()) {
            this.setSpecifier((ICASTDeclSpecifier)declSpec, specifier);
        }
        this.setOffsetAndLength((IASTNode)declSpec);
        this.astStack.push(declSpec);
    }

    public void consumeDeclarationSpecifiersStructUnionEnum() {
        List topScope = this.astStack.closeScope();
        ICASTDeclSpecifier declSpec = (ICASTDeclSpecifier)CollectionUtils.findFirstAndRemove(topScope, ICASTDeclSpecifier.class);
        for (Object specifier : topScope) {
            this.setSpecifier(declSpec, specifier);
        }
        this.setOffsetAndLength((IASTNode)declSpec);
        this.astStack.push(declSpec);
    }

    public void consumeDeclarationSpecifiersTypedefName() {
        ICASTTypedefNameSpecifier declSpec = this.nodeFactory.newCTypedefNameSpecifier();
        for (Object o : this.astStack.topScope()) {
            if (!(o instanceof IToken)) continue;
            IToken token = (IToken)o;
            int kind = this.baseKind(token);
            if (kind == 1 || kind == 4) {
                IASTName name = this.createName(token);
                declSpec.setName(name);
                continue;
            }
            this.setSpecifier((ICASTDeclSpecifier)declSpec, token);
        }
        this.astStack.closeScope();
        this.setOffsetAndLength((IASTNode)declSpec);
        this.astStack.push(declSpec);
    }

    public void consumeDeclarationSimple(boolean hasDeclaratorList) {
        List declarators = hasDeclaratorList ? this.astStack.closeScope() : Collections.emptyList();
        IASTDeclSpecifier declSpecifier = (IASTDeclSpecifier)this.astStack.pop();
        List<IToken> ruleTokens = this.parser.getRuleTokens();
        if (ruleTokens.size() == 1 && this.baseKind(ruleTokens.get(0)) == 3) {
            return;
        }
        IASTSimpleDeclaration declaration = this.nodeFactory.newSimpleDeclaration(declSpecifier);
        for (Object declarator : declarators) {
            declaration.addDeclarator((IASTDeclarator)declarator);
        }
        this.setOffsetAndLength((IASTNode)declaration);
        this.astStack.push(declaration);
    }

    public void consumeDeclarationEmpty() {
        if (this.baseKind(this.parser.getLeftIToken()) == 3) {
            return;
        }
        ICASTSimpleDeclSpecifier declSpecifier = this.nodeFactory.newCSimpleDeclSpecifier();
        IASTSimpleDeclaration declaration = this.nodeFactory.newSimpleDeclaration((IASTDeclSpecifier)declSpecifier);
        this.setOffsetAndLength((IASTNode)declSpecifier);
        this.setOffsetAndLength((IASTNode)declaration);
        this.astStack.push(declaration);
    }

    public void consumeStructDeclaration(boolean hasDeclaration) {
        this.consumeDeclarationSimple(hasDeclaration);
    }

    public void consumeTypeSpecifierComposite(boolean hasName, int key) {
        IASTName name = hasName ? this.createName(this.parser.getRuleTokens().get(1)) : this.nodeFactory.newName();
        ICASTCompositeTypeSpecifier typeSpec = this.nodeFactory.newCCompositeTypeSpecifier(key, name);
        for (Object o : this.astStack.closeScope()) {
            typeSpec.addMemberDeclaration((IASTDeclaration)o);
        }
        this.setOffsetAndLength((IASTNode)typeSpec);
        this.astStack.push(typeSpec);
    }

    public void consumeTypeSpecifierElaborated(int kind) {
        IASTName name = this.createName(this.parser.getRuleTokens().get(1));
        IASTElaboratedTypeSpecifier typeSpec = this.nodeFactory.newElaboratedTypeSpecifier(kind, name);
        this.setOffsetAndLength((IASTNode)typeSpec);
        this.astStack.push(typeSpec);
    }

    public void consumeStatementWhileLoop() {
        IASTStatement body = (IASTStatement)this.astStack.pop();
        IASTExpression condition = (IASTExpression)this.astStack.pop();
        IASTWhileStatement whileStatement = this.nodeFactory.newWhileStatement(condition, body);
        this.setOffsetAndLength((IASTNode)whileStatement);
        this.astStack.push(whileStatement);
    }

    public void consumeStatementForLoop() {
        IASTStatement body = (IASTStatement)this.astStack.pop();
        IASTExpression expr3 = (IASTExpression)this.astStack.pop();
        IASTExpression expr2 = (IASTExpression)this.astStack.pop();
        IASTNode node = (IASTNode)this.astStack.pop();
        Object initializer = node instanceof IASTExpression ? this.nodeFactory.newExpressionStatement((IASTExpression)node) : (node instanceof IASTDeclaration ? this.nodeFactory.newDeclarationStatement((IASTDeclaration)node) : this.nodeFactory.newNullStatement());
        int TK_EOC = 3;
        List<IToken> tokens = this.parser.getRuleTokens();
        if (C99BuildASTParserAction.matchTokens(tokens, this.tokenMap, 52, 2, 4, TK_EOC, TK_EOC, TK_EOC, TK_EOC)) {
            IASTName name = this.createName(tokens.get(2));
            IASTIdExpression idExpression = this.nodeFactory.newIdExpression(name);
            C99BuildASTParserAction.setOffsetAndLength((IASTNode)idExpression, C99BuildASTParserAction.offset((IASTNode)name), C99BuildASTParserAction.length((IASTNode)name));
            initializer = this.nodeFactory.newExpressionStatement((IASTExpression)idExpression);
            C99BuildASTParserAction.setOffsetAndLength((IASTNode)initializer, C99BuildASTParserAction.offset((IASTNode)name), C99BuildASTParserAction.length((IASTNode)name));
        }
        if (node != null) {
            C99BuildASTParserAction.setOffsetAndLength((IASTNode)initializer, C99BuildASTParserAction.offset(node), C99BuildASTParserAction.length(node));
        }
        IASTForStatement forStat = this.nodeFactory.newForStatement((IASTStatement)initializer, expr2, expr3, body);
        this.setOffsetAndLength((IASTNode)forStat);
        this.astStack.push(forStat);
    }

    public void consumeStatementSwitch() {
        IASTStatement body = (IASTStatement)this.astStack.pop();
        IASTExpression expr = (IASTExpression)this.astStack.pop();
        IASTSwitchStatement stat = this.nodeFactory.newSwitchStatment(expr, body);
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementIf(boolean hasElse) {
        IASTStatement elseClause = null;
        if (hasElse) {
            elseClause = (IASTStatement)this.astStack.pop();
        }
        IASTStatement thenClause = (IASTStatement)this.astStack.pop();
        IASTExpression condition = (IASTExpression)this.astStack.pop();
        IASTIfStatement ifStatement = this.nodeFactory.newIfStatement(condition, thenClause, elseClause);
        this.setOffsetAndLength((IASTNode)ifStatement);
        this.astStack.push(ifStatement);
    }

    public void consumeFunctionDefinition(boolean hasDeclSpecifiers) {
        IASTCompoundStatement body = (IASTCompoundStatement)this.astStack.pop();
        IASTFunctionDeclarator decl = (IASTFunctionDeclarator)this.astStack.pop();
        this.astStack.closeScope();
        Object declSpecifier = hasDeclSpecifiers ? (IASTDeclSpecifier)this.astStack.pop() : this.nodeFactory.newCSimpleDeclSpecifier();
        IASTFunctionDefinition def = this.nodeFactory.newFunctionDefinition((IASTDeclSpecifier)declSpecifier, decl, (IASTStatement)body);
        this.setOffsetAndLength((IASTNode)def);
        this.astStack.push(def);
    }

    public void consumeFunctionDefinitionKnR() {
        IASTCompoundStatement body = (IASTCompoundStatement)this.astStack.pop();
        IASTDeclaration[] declarations = this.astStack.topScope().toArray(new IASTDeclaration[0]);
        this.astStack.closeScope();
        ICASTKnRFunctionDeclarator decl = (ICASTKnRFunctionDeclarator)this.astStack.pop();
        this.astStack.closeScope();
        ICASTSimpleDeclSpecifier declSpecifier = (ICASTSimpleDeclSpecifier)this.astStack.pop();
        decl.setParameterDeclarations(declarations);
        ASTNode lastDeclaration = (ASTNode)declarations[declarations.length - 1];
        int endOffset = lastDeclaration.getOffset() + lastDeclaration.getLength();
        ((ASTNode)decl).setLength(endOffset - C99BuildASTParserAction.offset((IASTNode)decl));
        IASTFunctionDefinition def = this.nodeFactory.newFunctionDefinition((IASTDeclSpecifier)declSpecifier, (IASTFunctionDeclarator)decl, (IASTStatement)body);
        this.setOffsetAndLength((IASTNode)def);
        this.astStack.push(def);
    }
}

