/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.cdt.core.settings.model.ICExclusionPatternPathEntry;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.KindBasedStore;
import org.eclipse.core.runtime.IPath;

public class CSettingEntryFactory {
    private static final HashSet EMPTY_SET = new HashSet(0);
    private KindBasedStore fStore = new KindBasedStore(false);

    private HashMap getNameMap(int kind, boolean create) {
        HashMap map = (HashMap)this.fStore.get(kind);
        if (map == null && create) {
            map = new HashMap();
            this.fStore.put(kind, map);
        }
        return map;
    }

    private HashMap getValueMap(String name, boolean create) {
        HashMap nameMap = this.getNameMap(4, create);
        if (nameMap != null) {
            return CSettingEntryFactory.getMap(nameMap, name, create);
        }
        return null;
    }

    private HashMap getFlagMap(int kind, String name, String value, IPath[] exclusionPatters, boolean create) {
        switch (kind) {
            case 4: {
                HashMap valueMap = this.getValueMap(name, create);
                if (valueMap != null) {
                    return CSettingEntryFactory.getMap(valueMap, name, create);
                }
                return null;
            }
            case 64: 
            case 128: {
                HashMap excPatternMap = this.getExclusionPatternsMap(kind, name, create);
                if (excPatternMap != null) {
                    HashSet setKey = exclusionPatters == null || exclusionPatters.length == 0 ? EMPTY_SET : new HashSet(Arrays.asList(exclusionPatters));
                    return CSettingEntryFactory.getMap(excPatternMap, setKey, create);
                }
                return null;
            }
        }
        HashMap nameMap = this.getNameMap(kind, create);
        if (nameMap != null) {
            return CSettingEntryFactory.getMap(nameMap, name, create);
        }
        return null;
    }

    private HashMap getExclusionPatternsMap(int kind, String name, boolean create) {
        HashMap nameMap = this.getNameMap(kind, create);
        if (nameMap != null) {
            return CSettingEntryFactory.getMap(nameMap, name, create);
        }
        return null;
    }

    private static HashMap getMap(HashMap container, Object key, boolean create) {
        HashMap map = (HashMap)container.get(key);
        if (map == null && create) {
            map = new HashMap();
            container.put(key, map);
        }
        return map;
    }

    public ICSettingEntry getEntry(ICSettingEntry entry) {
        switch (entry.getKind()) {
            case 64: 
            case 128: {
                return this.getEntry(entry.getKind(), entry.getName(), null, ((ICExclusionPatternPathEntry)entry).getExclusionPatterns(), entry.getFlags(), entry, true);
            }
        }
        return this.getLanguageSettingEntry((ICLanguageSettingEntry)entry);
    }

    public ICLanguageSettingEntry getLanguageSettingEntry(ICLanguageSettingEntry lEntry) {
        return (ICLanguageSettingEntry)this.getEntry(lEntry.getKind(), lEntry.getName(), lEntry.getValue(), null, lEntry.getFlags(), lEntry, true);
    }

    public ICSettingEntry getEntry(int kind, String name, String value, IPath[] exclusionPatterns, int flags, boolean create) {
        return this.getEntry(kind, name, value, exclusionPatterns, flags, null, create);
    }

    private ICSettingEntry getEntry(int kind, String name, String value, IPath[] exclusionPatterns, int flags, ICSettingEntry baseEntry, boolean create) {
        HashMap flagMap = this.getFlagMap(kind, name, value, exclusionPatterns, create);
        if (flagMap != null) {
            Integer iFlags = new Integer(flags);
            ICSettingEntry entry = (ICSettingEntry)flagMap.get(iFlags);
            if (entry == null && create) {
                entry = baseEntry != null ? baseEntry : CDataUtil.createEntry(kind, name, value, exclusionPatterns, flags);
                flagMap.put(iFlags, entry);
            }
            return entry;
        }
        return null;
    }

    public void clear() {
        this.fStore.clear();
    }
}

