/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.LocalProjectScope;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class CCoreInternals {
    private static final String PREFS_FILE_EXTENSION = ".prefs";
    private static final String SETTINGS_DIRECTORY_NAME = ".settings";

    public static PDOMManager getPDOMManager() {
        return (PDOMManager)CCorePlugin.getIndexManager();
    }

    public static void savePreferences(final IProject project) {
        Job job = new Job(CCorePlugin.getResourceString("CCoreInternals.savePreferencesJob")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (project != null) {
                        new LocalProjectScope(project).getNode("org.eclipse.cdt.core").flush();
                        if (project.isOpen()) {
                            new ProjectScope(project).getNode("org.eclipse.cdt.core").flush();
                        }
                    }
                    new InstanceScope().getNode("org.eclipse.cdt.core").flush();
                }
                catch (BackingStoreException e) {
                    CCorePlugin.log(e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        if (project != null) {
            IResourceRuleFactory rf = ResourcesPlugin.getWorkspace().getRuleFactory();
            IFile wsFile = project.getFile(new Path(SETTINGS_DIRECTORY_NAME).append("org.eclipse.cdt.core.prefs"));
            ISchedulingRule[] rules = new ISchedulingRule[]{rf.modifyRule((IResource)wsFile), rf.createRule((IResource)wsFile.getParent()), rf.createRule((IResource)wsFile), rf.deleteRule((IResource)wsFile)};
            job.setRule(MultiRule.combine((ISchedulingRule[])rules));
        }
        job.schedule();
    }
}

