/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.c.ICFunctionScope;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTNode;
import org.eclipse.cdt.internal.core.dom.parser.c.CFunctionScope;

public class CASTFunctionDefinition
extends CASTNode
implements IASTFunctionDefinition,
IASTAmbiguityParent {
    private IASTDeclSpecifier declSpecifier;
    private IASTFunctionDeclarator declarator;
    private IASTStatement bodyStatement;
    private ICFunctionScope scope;

    public CASTFunctionDefinition() {
    }

    public CASTFunctionDefinition(IASTDeclSpecifier declSpecifier, IASTFunctionDeclarator declarator, IASTStatement bodyStatement) {
        this.setDeclSpecifier(declSpecifier);
        this.setDeclarator(declarator);
        this.setBody(bodyStatement);
    }

    public IASTDeclSpecifier getDeclSpecifier() {
        return this.declSpecifier;
    }

    public void setDeclSpecifier(IASTDeclSpecifier declSpec) {
        this.declSpecifier = declSpec;
        if (declSpec != null) {
            declSpec.setParent(this);
            declSpec.setPropertyInParent(DECL_SPECIFIER);
        }
    }

    public IASTFunctionDeclarator getDeclarator() {
        return this.declarator;
    }

    public void setDeclarator(IASTFunctionDeclarator declarator) {
        this.declarator = declarator;
        if (declarator != null) {
            declarator.setParent(this);
            declarator.setPropertyInParent(DECLARATOR);
        }
    }

    public IASTStatement getBody() {
        return this.bodyStatement;
    }

    public void setBody(IASTStatement statement) {
        this.bodyStatement = statement;
        if (statement != null) {
            statement.setParent(this);
            statement.setPropertyInParent(FUNCTION_BODY);
        }
    }

    public IScope getScope() {
        if (this.scope == null) {
            this.scope = new CFunctionScope(this);
        }
        return this.scope;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.declSpecifier != null && !this.declSpecifier.accept(action)) {
            return false;
        }
        if (this.declarator != null && !this.declarator.accept(action)) {
            return false;
        }
        if (this.bodyStatement != null && !this.bodyStatement.accept(action)) {
            return false;
        }
        if (action.shouldVisitDeclarations) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (this.bodyStatement == child) {
            other.setPropertyInParent(this.bodyStatement.getPropertyInParent());
            other.setParent(this.bodyStatement.getParent());
            this.bodyStatement = (IASTStatement)other;
        }
    }
}

