/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;

public class CPPImplicitFunction
extends CPPFunction {
    private IParameter[] parms = null;
    private IScope scope = null;
    private IFunctionType functionType = null;
    private boolean takesVarArgs = false;
    private char[] name = null;

    public CPPImplicitFunction(char[] name, IScope scope, IFunctionType type, IParameter[] parms, boolean takesVarArgs) {
        super(null);
        this.name = name;
        this.scope = scope;
        this.functionType = type;
        this.parms = parms;
        this.takesVarArgs = takesVarArgs;
    }

    public IParameter[] getParameters() {
        return this.parms;
    }

    public IFunctionType getType() {
        return this.functionType;
    }

    public String getName() {
        return String.valueOf(this.name);
    }

    public char[] getNameCharArray() {
        return this.name;
    }

    public IScope getScope() {
        return this.scope;
    }

    public IScope getFunctionScope() {
        return null;
    }

    public IBinding resolveParameter(IASTParameterDeclaration param) {
        IASTName aName = param.getDeclarator().getName();
        IParameter binding = (IParameter)aName.getBinding();
        if (binding != null) {
            return binding;
        }
        ICPPASTFunctionDeclarator fdtor = (ICPPASTFunctionDeclarator)param.getParent();
        IASTParameterDeclaration[] ps = fdtor.getParameters();
        int i = 0;
        while (i < ps.length) {
            if (param == ps[i]) break;
            ++i;
        }
        binding = this.parms[i];
        IASTParameterDeclaration temp = null;
        if (this.definition != null) {
            temp = this.definition.getParameters()[i];
            IASTName n = temp.getDeclarator().getName();
            n.setBinding(binding);
            ((CPPParameter)binding).addDeclaration(n);
        }
        if (this.declarations != null) {
            int j = 0;
            while (j < this.declarations.length && this.declarations[j] != null) {
                temp = this.declarations[j].getParameters()[i];
                IASTName n = temp.getDeclarator().getName();
                n.setBinding(binding);
                ((CPPParameter)binding).addDeclaration(n);
                ++j;
            }
        }
        return binding;
    }

    protected void updateParameterBindings(ICPPASTFunctionDeclarator fdtor) {
        if (this.parms != null) {
            IASTParameterDeclaration[] nps = fdtor.getParameters();
            if (nps.length != this.parms.length) {
                return;
            }
            int i = 0;
            while (i < nps.length) {
                IASTName aName = nps[i].getDeclarator().getName();
                aName.setBinding(this.parms[i]);
                if (this.parms[i] instanceof ICPPInternalBinding) {
                    ((ICPPInternalBinding)((Object)this.parms[i])).addDeclaration(aName);
                }
                ++i;
            }
        }
    }

    public boolean takesVarArgs() {
        return this.takesVarArgs;
    }
}

