/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.astwriter;

import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.Scribe;

public class MacroExpansionHandler {
    private int lastMacroExpOffset;
    private final Scribe scribe;

    public MacroExpansionHandler(Scribe scribe) {
        this.scribe = scribe;
    }

    protected boolean checkisMacroExpansionNode(IASTNode node) {
        return this.checkisMacroExpansionNode(node, true);
    }

    protected boolean isStatementWithMixedLocation(IASTStatement node) {
        if (node.getNodeLocations().length > 1) {
            IASTNodeLocation[] iASTNodeLocationArray = node.getNodeLocations();
            int n = iASTNodeLocationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNodeLocation loc = iASTNodeLocationArray[n2];
                if (loc instanceof IASTMacroExpansionLocation) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected boolean macroExpansionAlreadyPrinted(IASTNode node) {
        IASTMacroExpansionLocation macroNode;
        IASTNodeLocation[] locs = node.getNodeLocations();
        return locs.length == 1 && locs[0] instanceof IASTMacroExpansionLocation && (macroNode = (IASTMacroExpansionLocation)locs[0]).asFileLocation().getNodeOffset() == this.lastMacroExpOffset;
    }

    protected boolean checkisMacroExpansionNode(IASTNode node, boolean write) {
        IASTNodeLocation[] locs = node.getNodeLocations();
        if (locs != null && locs.length == 1 && locs[0] instanceof IASTMacroExpansionLocation) {
            IASTMacroExpansionLocation macroNode = (IASTMacroExpansionLocation)locs[0];
            if (macroNode.asFileLocation().getNodeOffset() == this.lastMacroExpOffset) {
                return true;
            }
            if (write) {
                this.lastMacroExpOffset = macroNode.asFileLocation().getNodeOffset();
                this.scribe.print(node.getRawSignature());
            }
            return true;
        }
        return false;
    }

    public void reset() {
        this.lastMacroExpOffset = -1;
    }
}

