/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.cdt.internal.core.pdom.indexer.DeltaAnalyzer;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;

public class CModelListener
implements IElementChangedListener,
IResourceChangeListener {
    private static final int UPDATE_LR_CHANGED_FILES_COUNT = 5;
    private PDOMManager fManager;
    private LinkedHashMap fLRUs = new LinkedHashMap(5, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 5;
        }
    };

    public CModelListener(PDOMManager manager) {
        this.fManager = manager;
    }

    public void elementChanged(ElementChangedEvent event) {
        if (event.getType() != 1) {
            return;
        }
        HashMap changeMap = new HashMap();
        this.processDelta(event.getDelta(), changeMap);
        this.addLastRecentlyUsed(changeMap);
        for (Map.Entry entry : changeMap.entrySet()) {
            ICProject cproject = (ICProject)entry.getKey();
            DeltaAnalyzer analyzer = (DeltaAnalyzer)entry.getValue();
            this.fManager.changeProject(cproject, analyzer.getAddedTUs(), analyzer.getChangedTUs(), analyzer.getRemovedTUs());
        }
    }

    private void processDelta(ICElementDelta delta, HashMap changeMap) {
        int type = delta.getElement().getElementType();
        block0 : switch (type) {
            case 10: {
                ICElementDelta[] children = delta.getAffectedChildren();
                int i = 0;
                while (i < children.length) {
                    this.processDelta(children[i], changeMap);
                    ++i;
                }
                break;
            }
            case 11: {
                ICProject project = (ICProject)delta.getElement();
                switch (delta.getKind()) {
                    case 1: {
                        this.fManager.addProject(project);
                        break block0;
                    }
                    case 4: {
                        this.processProjectDelta(project, delta, changeMap);
                        break block0;
                    }
                    case 2: {
                        this.fManager.removeProject(project, delta);
                    }
                }
            }
        }
    }

    private void processProjectDelta(ICProject project, ICElementDelta delta, HashMap changeMap) {
        IPDOMIndexer indexer = this.fManager.getIndexer(project);
        if (indexer != null && indexer.getID().equals("org.eclipse.cdt.core.nullindexer")) {
            return;
        }
        DeltaAnalyzer deltaAnalyzer = new DeltaAnalyzer();
        try {
            deltaAnalyzer.analyzeDelta(delta);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        changeMap.put(project, deltaAnalyzer);
    }

    private void addLastRecentlyUsed(HashMap changeMap) {
        boolean addLRUs = false;
        int count = 0;
        ITranslationUnit[] newLRUs = new ITranslationUnit[5];
        for (DeltaAnalyzer analyzer : changeMap.values()) {
            List<ITranslationUnit> l = analyzer.getAddedList();
            for (ITranslationUnit tu : l) {
                newLRUs[count++ % 5] = tu;
                if (addLRUs || !tu.isHeaderUnit()) continue;
                addLRUs = true;
            }
            l = analyzer.getChangedList();
            for (ITranslationUnit tu : l) {
                newLRUs[count++ % 5] = tu;
                if (addLRUs || !tu.isHeaderUnit()) continue;
                addLRUs = true;
            }
        }
        if (count > 0) {
            if (addLRUs) {
                for (ITranslationUnit tu : this.fLRUs.keySet()) {
                    if (!tu.getResource().exists()) continue;
                    ICProject cproject = tu.getCProject();
                    DeltaAnalyzer analyzer = (DeltaAnalyzer)changeMap.get(cproject);
                    if (analyzer == null) {
                        analyzer = new DeltaAnalyzer();
                        changeMap.put(cproject, analyzer);
                    }
                    analyzer.getChangedList().add(tu);
                }
            }
            count = Math.min(count, newLRUs.length);
            int i = 0;
            while (i < count) {
                ITranslationUnit tu;
                tu = newLRUs[i];
                this.fLRUs.put(tu, tu);
                ++i;
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 16) {
            this.fManager.handlePostBuildEvent();
        }
    }
}

