/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLinkage;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IIndexMacroContainer;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFileSet;
import org.eclipse.cdt.internal.core.index.IIndexFragmentInclude;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.pdom.IPDOM;
import org.eclipse.cdt.internal.core.pdom.PDOMFileSet;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.ChunkCache;
import org.eclipse.cdt.internal.core.pdom.db.DBProperties;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.dom.BindingCollector;
import org.eclipse.cdt.internal.core.pdom.dom.FindBinding;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMLinkageFactory;
import org.eclipse.cdt.internal.core.pdom.dom.MacroContainerCollector;
import org.eclipse.cdt.internal.core.pdom.dom.MacroContainerPatternCollector;
import org.eclipse.cdt.internal.core.pdom.dom.NamedNodeCollector;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMInclude;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacro;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroContainer;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroReferenceName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDOM
extends PlatformObject
implements IPDOM {
    public static final String FRAGMENT_PROPERTY_VALUE_FORMAT_ID = "org.eclipse.cdt.internal.core.pdom.PDOM";
    public static final int MAJOR_VERSION = 61;
    public static final int MINOR_VERSION = 0;
    public static final int CURRENT_VERSION = PDOM.version(61, 0);
    public static final int MIN_SUPPORTED_VERSION = PDOM.version(61, 0);
    public static final int MAX_SUPPORTED_VERSION = PDOM.version(62, 0) - 1;
    public static final int LINKAGES = 2048;
    public static final int FILE_INDEX = 2052;
    public static final int PROPERTIES = 2056;
    public static final int END = 2060;
    protected Database db;
    private BTree fileIndex;
    private Map<String, PDOMLinkage> fLinkageIDCache = new HashMap<String, PDOMLinkage>();
    private File fPath;
    private IIndexLocationConverter locationConverter;
    private Map<String, IPDOMLinkageFactory> fPDOMLinkageFactoryCache;
    private HashMap<Object, Object> fResultCache = new HashMap();
    private List<IListener> listeners;
    protected ChangeEvent fEvent = new ChangeEvent();
    private Object mutex = new Object();
    private int lockCount;
    private int waitingReaders;
    private long lastWriteAccess = 0L;
    private long lastReadAccess = 0L;

    private static int version(int major, int minor) {
        return major << 16 + minor;
    }

    public static String versionString(int version) {
        int major = version >> 16;
        int minor = version & 0xFFFF;
        return "" + major + '.' + minor;
    }

    public PDOM(File dbPath, IIndexLocationConverter locationConverter, Map<String, IPDOMLinkageFactory> linkageFactoryMappings) throws CoreException {
        this(dbPath, locationConverter, ChunkCache.getSharedInstance(), linkageFactoryMappings);
    }

    public PDOM(File dbPath, IIndexLocationConverter locationConverter, ChunkCache cache, Map<String, IPDOMLinkageFactory> linkageFactoryMappings) throws CoreException {
        this.fPDOMLinkageFactoryCache = linkageFactoryMappings;
        this.loadDatabase(dbPath, cache);
        this.locationConverter = locationConverter;
    }

    protected boolean isPermanentlyReadOnly() {
        return true;
    }

    private void loadDatabase(File dbPath, ChunkCache cache) throws CoreException {
        this.fPath = dbPath;
        boolean lockDB = this.db == null || this.lockCount != 0;
        this.clearCaches();
        this.db = new Database(this.fPath, cache, CURRENT_VERSION, this.isPermanentlyReadOnly());
        this.db.setLocked(lockDB);
        if (this.isSupportedVersion()) {
            this.readLinkages();
        }
        this.db.setLocked(this.lockCount != 0);
    }

    public IIndexLocationConverter getLocationConverter() {
        return this.locationConverter;
    }

    public boolean isSupportedVersion() throws CoreException {
        int version = this.db.getVersion();
        return version >= MIN_SUPPORTED_VERSION && version <= MAX_SUPPORTED_VERSION;
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
        for (PDOMLinkage linkage : this.fLinkageIDCache.values()) {
            linkage.accept(visitor);
        }
    }

    @Override
    public void addListener(IListener listener) {
        if (this.listeners == null) {
            this.listeners = new LinkedList<IListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    private void fireChange(ChangeEvent event) {
        if (this.listeners == null) {
            return;
        }
        Iterator<IListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().handleChange(this, event);
        }
    }

    public Database getDB() {
        return this.db;
    }

    public BTree getFileIndex() throws CoreException {
        if (this.fileIndex == null) {
            this.fileIndex = new BTree(this.getDB(), 2052, new PDOMFile.Comparator(this.getDB()));
        }
        return this.fileIndex;
    }

    @Override
    public PDOMFile getFile(int linkageID, IIndexFileLocation location) throws CoreException {
        return PDOMFile.findFile(this, this.getFileIndex(), location, linkageID, this.locationConverter);
    }

    @Override
    public IIndexFragmentFile[] getFiles(IIndexFileLocation location) throws CoreException {
        return PDOMFile.findFiles(this, this.getFileIndex(), location, this.locationConverter);
    }

    @Override
    public IIndexFragmentFile[] getAllFiles() throws CoreException {
        final ArrayList locations = new ArrayList();
        this.getFileIndex().accept(new IBTreeVisitor(){

            public int compare(int record) throws CoreException {
                return 0;
            }

            public boolean visit(int record) throws CoreException {
                PDOMFile file = new PDOMFile(PDOM.this, record);
                locations.add(file);
                return true;
            }
        });
        return locations.toArray(new IIndexFragmentFile[locations.size()]);
    }

    protected IIndexFragmentFile addFile(int linkageID, IIndexFileLocation location) throws CoreException {
        PDOMFile file = this.getFile(linkageID, location);
        if (file == null) {
            PDOMFile pdomFile = new PDOMFile(this, location, linkageID);
            this.getFileIndex().insert(pdomFile.getRecord());
            file = pdomFile;
        }
        return file;
    }

    protected void clearFileIndex() throws CoreException {
        this.db.putInt(2052, 0);
        this.fileIndex = null;
    }

    protected void clear() throws CoreException {
        assert (this.lockCount < 0);
        this.db.clear(CURRENT_VERSION);
        this.clearCaches();
        this.fEvent.setCleared();
    }

    void reloadFromFile(File file) throws CoreException {
        assert (this.lockCount < 0);
        File oldFile = this.fPath;
        this.clearCaches();
        try {
            this.db.close();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        this.loadDatabase(file, this.db.getChunkCache());
        this.db.setExclusiveLock();
        oldFile.delete();
        this.fEvent.fReloaded = true;
    }

    public boolean isEmpty() throws CoreException {
        return this.getFirstLinkageRecord() == 0;
    }

    @Override
    public IIndexFragmentBinding findBinding(IASTName name) throws CoreException {
        PDOMLinkage linkage;
        IBinding binding = name.resolveBinding();
        if (binding != null) {
            PDOMLinkage linkage2 = this.adaptLinkage(name.getLinkage());
            if (linkage2 != null) {
                return this.findBindingInLinkage(linkage2, binding);
            }
        } else if (name.getPropertyInParent() == IASTPreprocessorStatement.MACRO_NAME && (linkage = this.adaptLinkage(name.getLinkage())) != null) {
            return linkage.findMacroContainer(name.toCharArray());
        }
        return null;
    }

    public IIndexBinding[] findBindings(Pattern pattern, boolean isFullyQualified, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        return this.findBindings(new Pattern[]{pattern}, isFullyQualified, filter, monitor);
    }

    @Override
    public IIndexFragmentBinding[] findBindings(Pattern[] pattern, boolean isFullyQualified, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        BindingFinder finder = new BindingFinder(pattern, isFullyQualified, filter, monitor);
        for (PDOMLinkage linkage : this.fLinkageIDCache.values()) {
            if (!filter.acceptLinkage(linkage)) continue;
            try {
                linkage.accept(finder);
            }
            catch (CoreException e) {
                if (e.getStatus() != Status.OK_STATUS) {
                    throw e;
                }
                return IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
            }
        }
        return finder.getBindings();
    }

    @Override
    public IIndexFragmentBinding[] findMacroContainers(Pattern pattern, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        MacroContainerPatternCollector finder = new MacroContainerPatternCollector(this, pattern, monitor);
        for (PDOMLinkage linkage : this.fLinkageIDCache.values()) {
            if (!filter.acceptLinkage(linkage)) continue;
            try {
                linkage.getMacroIndex().accept(finder);
            }
            catch (CoreException e) {
                if (e.getStatus() != Status.OK_STATUS) {
                    throw e;
                }
                return IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
            }
        }
        return finder.getMacroContainers();
    }

    @Override
    public IIndexFragmentBinding[] findBindings(char[][] names, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (names.length == 0) {
            return IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
        }
        ArrayList result = new ArrayList();
        ArrayList<PDOMLinkage> nodes = new ArrayList<PDOMLinkage>();
        for (PDOMLinkage linkage : this.fLinkageIDCache.values()) {
            if (!filter.acceptLinkage(linkage)) continue;
            nodes.add(linkage);
            int i = 0;
            while (i < names.length - 1) {
                char[] name = names[i];
                NamedNodeCollector collector = new NamedNodeCollector(linkage, name, false, true);
                for (PDOMNode pDOMNode : nodes) {
                    pDOMNode.accept(collector);
                }
                nodes.clear();
                nodes.addAll((Collection)Arrays.asList(collector.getNodes()));
                ++i;
            }
            char[] name = names[names.length - 1];
            BindingCollector collector = new BindingCollector(linkage, name, filter, false, true);
            for (PDOMNode pDOMNode : nodes) {
                pDOMNode.accept(collector);
            }
            nodes.clear();
            result.addAll(Arrays.asList(collector.getBindings()));
        }
        return result.toArray(new IIndexFragmentBinding[result.size()]);
    }

    private void readLinkages() throws CoreException {
        int record = this.getFirstLinkageRecord();
        while (record != 0) {
            String linkageID = PDOMLinkage.getId(this, record).getString();
            IPDOMLinkageFactory factory = this.fPDOMLinkageFactoryCache.get(linkageID);
            if (factory != null) {
                PDOMLinkage linkage = factory.getLinkage(this, record);
                this.fLinkageIDCache.put(linkageID, linkage);
            }
            record = PDOMLinkage.getNextLinkageRecord(this, record);
        }
    }

    public PDOMLinkage getLinkage(String linkageID) {
        return this.fLinkageIDCache.get(linkageID);
    }

    public PDOMLinkage createLinkage(String linkageID) throws CoreException {
        IPDOMLinkageFactory factory;
        PDOMLinkage pdomLinkage = this.fLinkageIDCache.get(linkageID);
        if (pdomLinkage == null && (factory = this.fPDOMLinkageFactoryCache.get(linkageID)) != null) {
            return factory.createLinkage(this);
        }
        return pdomLinkage;
    }

    public PDOMLinkage getLinkage(int record) throws CoreException {
        if (record == 0) {
            return null;
        }
        for (PDOMLinkage linkage : this.fLinkageIDCache.values()) {
            if (linkage.getRecord() != record) continue;
            return linkage;
        }
        String id = PDOMLinkage.getId(this, record).getString();
        return this.createLinkage(id);
    }

    private int getFirstLinkageRecord() throws CoreException {
        return this.db.getInt(2048);
    }

    @Override
    public IIndexLinkage[] getLinkages() {
        Collection<PDOMLinkage> values = this.fLinkageIDCache.values();
        return values.toArray(new IIndexLinkage[values.size()]);
    }

    @Override
    public PDOMLinkage[] getLinkageImpls() {
        Collection<PDOMLinkage> values = this.fLinkageIDCache.values();
        return values.toArray(new PDOMLinkage[values.size()]);
    }

    public void insertLinkage(PDOMLinkage linkage) throws CoreException {
        linkage.setNext(this.db.getInt(2048));
        this.db.putInt(2048, linkage.getRecord());
        this.fLinkageIDCache.put(linkage.getLinkageName(), linkage);
    }

    public PDOMBinding getBinding(int record) throws CoreException {
        if (record == 0) {
            return null;
        }
        PDOMNode node = PDOMNode.getLinkage(this, record).getNode(record);
        return node instanceof PDOMBinding ? (PDOMBinding)node : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireReadLock() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            ++this.waitingReaders;
            try {
                while (this.lockCount < 0) {
                    this.mutex.wait();
                }
            }
            finally {
                --this.waitingReaders;
            }
            ++this.lockCount;
            this.db.setLocked(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseReadLock() {
        boolean clearCache = false;
        Object object = this.mutex;
        synchronized (object) {
            assert (this.lockCount > 0) : "No lock to release";
            this.lastReadAccess = System.currentTimeMillis();
            if (this.lockCount > 0) {
                --this.lockCount;
            }
            this.mutex.notifyAll();
            clearCache = this.lockCount == 0;
            this.db.setLocked(this.lockCount != 0);
        }
        if (clearCache) {
            this.clearResultCache();
        }
    }

    public void acquireWriteLock() throws InterruptedException {
        this.acquireWriteLock(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireWriteLock(int giveupReadLocks) throws InterruptedException {
        assert (!this.isPermanentlyReadOnly());
        Object object = this.mutex;
        synchronized (object) {
            if (giveupReadLocks > 0) {
                assert (this.lockCount >= giveupReadLocks) : "Not enough locks to release";
                if (this.lockCount < giveupReadLocks) {
                    giveupReadLocks = this.lockCount;
                }
            } else {
                giveupReadLocks = 0;
            }
            while (this.lockCount > giveupReadLocks || this.waitingReaders > 0) {
                this.mutex.wait();
            }
            this.lockCount = -1;
            this.db.setExclusiveLock();
        }
    }

    public final void releaseWriteLock() {
        this.releaseWriteLock(0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWriteLock(int establishReadLocks, boolean flush) {
        this.clearResultCache();
        try {
            this.db.giveUpExclusiveLock(flush);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        assert (this.lockCount == -1);
        this.lastWriteAccess = System.currentTimeMillis();
        ChangeEvent event = this.fEvent;
        this.fEvent = new ChangeEvent();
        Object object = this.mutex;
        synchronized (object) {
            if (this.lockCount < 0) {
                this.lockCount = establishReadLocks;
            }
            this.mutex.notifyAll();
            this.db.setLocked(this.lockCount != 0);
        }
        this.fireChange(event);
    }

    @Override
    public long getLastWriteAccess() {
        return this.lastWriteAccess;
    }

    public long getLastReadAccess() {
        return this.lastReadAccess;
    }

    protected PDOMLinkage adaptLinkage(ILinkage linkage) throws CoreException {
        return this.fLinkageIDCache.get(linkage.getLinkageName());
    }

    @Override
    public IIndexFragmentBinding adaptBinding(IBinding binding) throws CoreException {
        if (binding == null) {
            return null;
        }
        PDOMNode pdomNode = (PDOMNode)binding.getAdapter(PDOMNode.class);
        if (pdomNode instanceof IIndexFragmentBinding && pdomNode.getPDOM() == this) {
            return (IIndexFragmentBinding)((Object)pdomNode);
        }
        PDOMLinkage linkage = this.adaptLinkage(binding.getLinkage());
        if (linkage != null) {
            return this.findBindingInLinkage(linkage, binding);
        }
        return null;
    }

    private IIndexFragmentBinding findBindingInLinkage(PDOMLinkage linkage, IBinding binding) throws CoreException {
        if (binding instanceof IMacroBinding || binding instanceof IIndexMacroContainer) {
            return linkage.findMacroContainer(binding.getNameCharArray());
        }
        return linkage.adaptBinding(binding);
    }

    public IIndexFragmentBinding findBinding(IIndexFragmentName indexName) throws CoreException {
        if (indexName instanceof PDOMName) {
            PDOMName pdomName = (PDOMName)indexName;
            return pdomName.getBinding();
        }
        return null;
    }

    @Override
    public IIndexFragmentName[] findNames(IBinding binding, int options) throws CoreException {
        ArrayList<IIndexFragmentName> names;
        block5: {
            IIndexFragmentBinding myBinding;
            block4: {
                PDOMBinding[] xlangBindings;
                names = new ArrayList<IIndexFragmentName>();
                myBinding = this.adaptBinding(binding);
                if (!(myBinding instanceof PDOMBinding)) break block4;
                PDOMBinding pdomBinding = (PDOMBinding)myBinding;
                this.findNamesForMyBinding(pdomBinding, options, names);
                if ((options & 8) == 0) break block5;
                PDOMBinding[] pDOMBindingArray = xlangBindings = this.getCrossLanguageBindings(binding);
                int n = xlangBindings.length;
                int n2 = 0;
                while (n2 < n) {
                    PDOMBinding xlangBinding = pDOMBindingArray[n2];
                    this.findNamesForMyBinding(xlangBinding, options, names);
                    ++n2;
                }
                break block5;
            }
            if (myBinding instanceof PDOMMacroContainer) {
                PDOMMacroContainer macroContainer = (PDOMMacroContainer)myBinding;
                this.findNamesForMyBinding(macroContainer, options, names);
                if ((options & 8) != 0) {
                    PDOMMacroContainer[] xlangBindings;
                    PDOMMacroContainer[] pDOMMacroContainerArray = xlangBindings = this.getCrossLanguageBindings(macroContainer);
                    int n = xlangBindings.length;
                    int n3 = 0;
                    while (n3 < n) {
                        PDOMMacroContainer xlangBinding = pDOMMacroContainerArray[n3];
                        this.findNamesForMyBinding(xlangBinding, options, names);
                        ++n3;
                    }
                }
            }
        }
        return names.toArray(new IIndexFragmentName[names.size()]);
    }

    private void findNamesForMyBinding(PDOMBinding pdomBinding, int options, ArrayList<IIndexFragmentName> names) throws CoreException {
        PDOMName name;
        if ((options & 1) != 0) {
            name = pdomBinding.getFirstDeclaration();
            while (name != null) {
                names.add(name);
                name = name.getNextInBinding();
            }
        }
        if ((options & 2) != 0) {
            name = pdomBinding.getFirstDefinition();
            while (name != null) {
                names.add(name);
                name = name.getNextInBinding();
            }
        }
        if ((options & 4) != 0) {
            name = pdomBinding.getFirstReference();
            while (name != null) {
                names.add(name);
                name = name.getNextInBinding();
            }
        }
    }

    private void findNamesForMyBinding(PDOMMacroContainer container, int options, ArrayList<IIndexFragmentName> names) throws CoreException {
        if ((options & 2) != 0) {
            PDOMMacro macro = container.getFirstDefinition();
            while (macro != null) {
                IIndexFragmentName name = macro.getDefinition();
                if (name != null) {
                    names.add(name);
                }
                macro = macro.getNextInContainer();
            }
        }
        if ((options & 4) != 0) {
            PDOMMacroReferenceName name = container.getFirstReference();
            while (name != null) {
                names.add(name);
                name = name.getNextInContainer();
            }
        }
    }

    @Override
    public IIndexFragmentInclude[] findIncludedBy(IIndexFragmentFile file) throws CoreException {
        PDOMFile pdomFile = this.adaptFile(file);
        if (pdomFile != null) {
            ArrayList<PDOMInclude> result = new ArrayList<PDOMInclude>();
            PDOMInclude i = pdomFile.getFirstIncludedBy();
            while (i != null) {
                result.add(i);
                i = i.getNextInIncludedBy();
            }
            return result.toArray(new PDOMInclude[result.size()]);
        }
        return new PDOMInclude[0];
    }

    private PDOMFile adaptFile(IIndexFragmentFile file) throws CoreException {
        if (file.getIndexFragment() == this && file instanceof PDOMFile) {
            return (PDOMFile)file;
        }
        return this.getFile(file.getLinkageID(), file.getLocation());
    }

    public File getPath() {
        return this.fPath;
    }

    @Override
    public IIndexFragmentBinding[] findBindingsForPrefix(char[] prefix, boolean filescope, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        ArrayList<PDOMBinding> result = new ArrayList<PDOMBinding>();
        for (PDOMLinkage linkage : this.fLinkageIDCache.values()) {
            PDOMBinding[] bindings;
            if (!filter.acceptLinkage(linkage)) continue;
            BindingCollector visitor = new BindingCollector(linkage, prefix, filter, true, false);
            visitor.setMonitor(monitor);
            try {
                linkage.accept(visitor);
                if (!filescope) {
                    linkage.getNestedBindingsIndex().accept(visitor);
                }
            }
            catch (OperationCanceledException operationCanceledException) {}
            PDOMBinding[] pDOMBindingArray = bindings = visitor.getBindings();
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                PDOMBinding binding = pDOMBindingArray[n2];
                result.add(binding);
                ++n2;
            }
        }
        return result.toArray(new IIndexFragmentBinding[result.size()]);
    }

    @Override
    public IIndexFragmentBinding[] findBindings(char[] name, boolean filescope, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        ArrayList<PDOMBinding> result = new ArrayList<PDOMBinding>();
        for (PDOMLinkage linkage : this.fLinkageIDCache.values()) {
            PDOMBinding[] bindings;
            if (!filter.acceptLinkage(linkage)) continue;
            BindingCollector visitor = new BindingCollector(linkage, name, filter, false, true);
            visitor.setMonitor(monitor);
            try {
                linkage.accept(visitor);
                if (!filescope) {
                    linkage.getNestedBindingsIndex().accept(visitor);
                }
            }
            catch (OperationCanceledException operationCanceledException) {}
            PDOMBinding[] pDOMBindingArray = bindings = visitor.getBindings();
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                PDOMBinding binding = pDOMBindingArray[n2];
                result.add(binding);
                ++n2;
            }
        }
        return result.toArray(new IIndexFragmentBinding[result.size()]);
    }

    @Override
    public IIndexMacro[] findMacros(char[] prefix, boolean isPrefix, boolean isCaseSensitive, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        ArrayList result = new ArrayList();
        MacroContainerCollector visitor = new MacroContainerCollector(this, prefix, isPrefix, isCaseSensitive);
        visitor.setMonitor(monitor);
        try {
            for (PDOMLinkage linkage : this.fLinkageIDCache.values()) {
                if (!filter.acceptLinkage(linkage)) continue;
                linkage.getMacroIndex().accept(visitor);
            }
            for (PDOMMacroContainer mcont : visitor.getMacroList()) {
                result.addAll(Arrays.asList(mcont.getDefinitions()));
            }
        }
        catch (OperationCanceledException operationCanceledException) {}
        return result.toArray(new IIndexMacro[result.size()]);
    }

    @Override
    public String getProperty(String propertyName) throws CoreException {
        if ("org.eclipse.cdt.internal.core.index.fragment.format.id".equals(propertyName)) {
            return FRAGMENT_PROPERTY_VALUE_FORMAT_ID;
        }
        if ("org.eclipse.cdt.internal.core.index.fragment.format.version".equals(propertyName)) {
            return PDOM.versionString(this.db.getVersion());
        }
        return new DBProperties(this.db, 2056).getProperty(propertyName);
    }

    public void close() throws CoreException {
        this.db.close();
        this.clearCaches();
    }

    private void clearCaches() {
        this.fileIndex = null;
        this.fLinkageIDCache.clear();
        this.clearResultCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearResultCache() {
        HashMap<Object, Object> hashMap = this.fResultCache;
        synchronized (hashMap) {
            this.fResultCache.clear();
        }
    }

    @Override
    public long getCacheHits() {
        return this.db.getCacheHits();
    }

    @Override
    public long getCacheMisses() {
        return this.db.getCacheMisses();
    }

    @Override
    public void resetCacheCounters() {
        this.db.resetCacheCounters();
    }

    protected void flush() throws CoreException {
        this.db.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCachedResult(Object key) {
        HashMap<Object, Object> hashMap = this.fResultCache;
        synchronized (hashMap) {
            return this.fResultCache.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putCachedResult(Object key, Object result) {
        HashMap<Object, Object> hashMap = this.fResultCache;
        synchronized (hashMap) {
            this.fResultCache.put(key, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCachedResult(Object key) {
        HashMap<Object, Object> hashMap = this.fResultCache;
        synchronized (hashMap) {
            this.fResultCache.remove(key);
        }
    }

    public String createKeyForCache(int record, char[] name) {
        return new StringBuilder(name.length + 2).append((char)(record >> 16)).append((char)record).append(name).toString();
    }

    private PDOMBinding[] getCrossLanguageBindings(IBinding binding) throws CoreException {
        switch (binding.getLinkage().getLinkageID()) {
            case 2: {
                return this.getCPPBindingForC(binding);
            }
            case 1: {
                return this.getCBindingForCPP(binding);
            }
        }
        return PDOMBinding.EMPTY_PDOMBINDING_ARRAY;
    }

    private PDOMMacroContainer[] getCrossLanguageBindings(PDOMMacroContainer binding) throws CoreException {
        int inputLinkage = binding.getLinkage().getLinkageID();
        if (inputLinkage == 2 || inputLinkage == 1) {
            char[] name = binding.getNameCharArray();
            for (PDOMLinkage linkage : this.fLinkageIDCache.values()) {
                PDOMMacroContainer container;
                int linkageID = linkage.getLinkageID();
                if (linkageID == inputLinkage || linkageID != 2 && linkageID != 1 || (container = linkage.findMacroContainer(name)) == null) continue;
                return new PDOMMacroContainer[]{container};
            }
        }
        return new PDOMMacroContainer[0];
    }

    private PDOMBinding[] getCBindingForCPP(IBinding binding) throws CoreException {
        PDOMBinding[] pDOMBindingArray;
        PDOMBinding result = null;
        PDOMLinkage c = this.getLinkage("C");
        if (c == null) {
            return PDOMBinding.EMPTY_PDOMBINDING_ARRAY;
        }
        try {
            int key;
            if (binding instanceof ICPPFunction) {
                ICPPFunction func = (ICPPFunction)binding;
                if (func.isExternC()) {
                    result = FindBinding.findBinding(c.getIndex(), this, func.getNameCharArray(), new int[]{7}, 0);
                }
            } else if (binding instanceof ICPPVariable) {
                ICPPVariable var = (ICPPVariable)binding;
                if (var.isExternC()) {
                    result = FindBinding.findBinding(c.getIndex(), this, var.getNameCharArray(), new int[]{6}, 0);
                }
            } else if (binding instanceof IEnumeration) {
                result = FindBinding.findBinding(c.getIndex(), this, binding.getNameCharArray(), new int[]{10}, 0);
            } else if (binding instanceof IEnumerator) {
                result = FindBinding.findBinding(c.getIndex(), this, binding.getNameCharArray(), new int[]{11}, 0);
            } else if (binding instanceof ITypedef) {
                result = FindBinding.findBinding(c.getIndex(), this, binding.getNameCharArray(), new int[]{12}, 0);
            } else if (binding instanceof ICompositeType && ((key = ((ICompositeType)binding).getKey()) == 1 || key == 2) && (result = FindBinding.findBinding(c.getIndex(), this, binding.getNameCharArray(), new int[]{8}, 0)) instanceof ICompositeType && ((ICompositeType)((Object)result)).getKey() != key) {
                result = null;
            }
        }
        catch (DOMException dOMException) {}
        if (result == null) {
            pDOMBindingArray = PDOMBinding.EMPTY_PDOMBINDING_ARRAY;
        } else {
            PDOMBinding[] pDOMBindingArray2 = new PDOMBinding[1];
            pDOMBindingArray = pDOMBindingArray2;
            pDOMBindingArray2[0] = result;
        }
        return pDOMBindingArray;
    }

    private PDOMBinding[] getCPPBindingForC(IBinding binding) throws CoreException {
        PDOMLinkage cpp = this.getLinkage("C++");
        if (cpp == null) {
            return PDOMBinding.EMPTY_PDOMBINDING_ARRAY;
        }
        IndexFilter filter = null;
        if (binding instanceof IFunction) {
            filter = new IndexFilter(){

                public boolean acceptBinding(IBinding binding) {
                    try {
                        if (binding instanceof ICPPFunction) {
                            return ((ICPPFunction)binding).isExternC();
                        }
                    }
                    catch (DOMException dOMException) {}
                    return false;
                }
            };
        } else if (binding instanceof IVariable) {
            if (!(binding instanceof IField) && !(binding instanceof IParameter)) {
                filter = new IndexFilter(){

                    public boolean acceptBinding(IBinding binding) {
                        try {
                            if (binding instanceof ICPPVariable) {
                                return ((ICPPVariable)binding).isExternC();
                            }
                        }
                        catch (DOMException dOMException) {}
                        return false;
                    }
                };
            }
        } else if (binding instanceof IEnumeration) {
            filter = new IndexFilter(){

                public boolean acceptBinding(IBinding binding) {
                    return binding instanceof IEnumeration;
                }
            };
        } else if (binding instanceof ITypedef) {
            filter = new IndexFilter(){

                public boolean acceptBinding(IBinding binding) {
                    return binding instanceof ITypedef;
                }
            };
        } else if (binding instanceof IEnumerator) {
            filter = new IndexFilter(){

                public boolean acceptBinding(IBinding binding) {
                    return binding instanceof IEnumerator;
                }
            };
        } else if (binding instanceof ICompositeType) {
            try {
                final int key = ((ICompositeType)binding).getKey();
                filter = new IndexFilter(){

                    public boolean acceptBinding(IBinding binding) {
                        try {
                            if (binding instanceof ICompositeType) {
                                return ((ICompositeType)binding).getKey() == key;
                            }
                        }
                        catch (DOMException dOMException) {}
                        return false;
                    }
                };
            }
            catch (DOMException dOMException) {}
        }
        if (filter != null) {
            BindingCollector collector = new BindingCollector(cpp, binding.getNameCharArray(), filter, false, true);
            cpp.accept(collector);
            return collector.getBindings();
        }
        return PDOMBinding.EMPTY_PDOMBINDING_ARRAY;
    }

    @Override
    public IIndexFragmentFileSet createFileSet() {
        return new PDOMFileSet();
    }

    private static class BindingFinder
    implements IPDOMVisitor {
        private final Pattern[] pattern;
        private final IProgressMonitor monitor;
        private final ArrayList<PDOMNamedNode> currentPath = new ArrayList();
        private final ArrayList<BitSet> matchStack = new ArrayList();
        private List<PDOMNamedNode> bindings = new ArrayList<PDOMNamedNode>();
        private boolean isFullyQualified;
        private BitSet matchesUpToLevel;
        private IndexFilter filter;

        public BindingFinder(Pattern[] pattern, boolean isFullyQualified, IndexFilter filter, IProgressMonitor monitor) {
            this.pattern = pattern;
            this.monitor = monitor;
            this.isFullyQualified = isFullyQualified;
            this.filter = filter;
            this.matchesUpToLevel = new BitSet();
            this.matchesUpToLevel.set(0);
            this.matchStack.add(this.matchesUpToLevel);
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            if (this.monitor.isCanceled()) {
                throw new CoreException(Status.OK_STATUS);
            }
            if (node instanceof PDOMNamedNode) {
                PDOMNamedNode nnode = (PDOMNamedNode)node;
                String name = new String(nnode.getNameCharArray());
                int lastIdx = this.pattern.length - 1;
                if (this.matchesUpToLevel.get(lastIdx) && this.pattern[lastIdx].matcher(name).matches() && nnode instanceof IBinding && this.filter.acceptBinding((IBinding)((Object)nnode))) {
                    this.bindings.add(nnode);
                }
                if (nnode.mayHaveChildren()) {
                    boolean visitNextLevel = false;
                    BitSet updatedMatchesUpToLevel = new BitSet();
                    if (!this.isFullyQualified) {
                        updatedMatchesUpToLevel.set(0);
                        visitNextLevel = true;
                    }
                    int i = 0;
                    while (i < lastIdx) {
                        if (this.matchesUpToLevel.get(i) && this.pattern[i].matcher(name).matches()) {
                            updatedMatchesUpToLevel.set(i + 1);
                            visitNextLevel = true;
                        }
                        ++i;
                    }
                    if (visitNextLevel) {
                        this.matchStack.add(this.matchesUpToLevel);
                        this.matchesUpToLevel = updatedMatchesUpToLevel;
                        this.currentPath.add(nnode);
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
            int idx = this.currentPath.size() - 1;
            if (idx >= 0 && this.currentPath.get(idx) == node) {
                this.currentPath.remove(idx);
                this.matchesUpToLevel = this.matchStack.remove(this.matchStack.size() - 1);
            }
        }

        public IIndexFragmentBinding[] getBindings() {
            return this.bindings.toArray(new IIndexFragmentBinding[this.bindings.size()]);
        }
    }

    public static class ChangeEvent {
        public Set<IIndexFileLocation> fClearedFiles = new HashSet<IIndexFileLocation>();
        public Set<IIndexFileLocation> fFilesWritten = new HashSet<IIndexFileLocation>();
        public boolean fCleared = false;
        public boolean fReloaded = false;

        private void setCleared() {
            this.fReloaded = false;
            this.fCleared = true;
            this.fClearedFiles.clear();
            this.fFilesWritten.clear();
        }

        public void clear() {
            this.fCleared = false;
            this.fReloaded = false;
            this.fClearedFiles.clear();
            this.fFilesWritten.clear();
        }
    }

    public static interface IListener {
        public void handleChange(PDOM var1, ChangeEvent var2);
    }
}

