/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorUndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceAlias;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.parser.scanner.LocationMap;
import org.eclipse.cdt.internal.core.pdom.ITodoTaskUpdater;
import org.eclipse.cdt.internal.core.pdom.IndexerInputAdapter;
import org.eclipse.cdt.internal.core.pdom.IndexerProgress;
import org.eclipse.cdt.internal.core.pdom.IndexerStatistics;
import org.eclipse.cdt.internal.core.pdom.Messages;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMASTAdapter;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerASTVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PDOMWriter {
    public static int SKIP_ALL_REFERENCES = -1;
    public static int SKIP_TYPE_REFERENCES = 1;
    public static int SKIP_MACRO_REFERENCES = 2;
    public static int SKIP_NO_REFERENCES = 0;
    private boolean fShowProblems;
    private boolean fShowInclusionProblems;
    private boolean fShowScannerProblems;
    private boolean fShowSyntaxProblems;
    protected boolean fShowActivity;
    protected final IndexerStatistics fStatistics;
    protected final IndexerInputAdapter fResolver;
    private IndexerProgress fInfo = new IndexerProgress();
    private int fSkipReferences = SKIP_NO_REFERENCES;

    public PDOMWriter(IndexerInputAdapter resolver) {
        this.fStatistics = new IndexerStatistics();
        this.fResolver = resolver;
    }

    public void setShowActivity(boolean val) {
        this.fShowActivity = val;
    }

    public void setShowInclusionProblems(boolean val) {
        this.fShowInclusionProblems = val;
    }

    public void setShowScannerProblems(boolean val) {
        this.fShowScannerProblems = val;
    }

    public void setShowSyntaxProblems(boolean val) {
        this.fShowSyntaxProblems = val;
    }

    public void setShowProblems(boolean val) {
        this.fShowProblems = val;
    }

    public void setSkipReferences(int options) {
        this.fSkipReferences = options;
    }

    public int getSkipReferences() {
        return this.fSkipReferences;
    }

    public void addSymbols(IASTTranslationUnit ast, IIndexFileLocation[] ifls, IWritableIndex index, int readlockCount, boolean flushIndex, int configHash, ITodoTaskUpdater taskUpdater, IProgressMonitor pm) throws InterruptedException, CoreException {
        if (this.fShowProblems) {
            this.fShowInclusionProblems = true;
            this.fShowScannerProblems = true;
            this.fShowSyntaxProblems = true;
        }
        HashMap<IIndexFileLocation, Symbols> symbolMap = new HashMap<IIndexFileLocation, Symbols>();
        IIndexFileLocation[] iIndexFileLocationArray = ifls;
        int n = ifls.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFileLocation ifl = iIndexFileLocationArray[n2];
            this.prepareInMap(symbolMap, ifl);
            ++n2;
        }
        ArrayList<IStatus> stati = new ArrayList<IStatus>();
        HashSet<IASTPreprocessorIncludeStatement> contextIncludes = new HashSet<IASTPreprocessorIncludeStatement>();
        this.extractSymbols(ast, symbolMap, contextIncludes);
        this.resolveNames(symbolMap, ifls, stati, pm);
        this.storeSymbolsInIndex(symbolMap, ifls, ast.getLinkage().getLinkageID(), configHash, contextIncludes, index, readlockCount, flushIndex, stati, pm);
        if (taskUpdater != null) {
            taskUpdater.updateTasks(ast.getComments(), ifls);
        }
        if (!stati.isEmpty()) {
            String path = null;
            path = ifls.length > 0 ? ifls[ifls.length - 1].getURI().getPath() : ast.getFilePath().toString();
            String msg = NLS.bind((String)Messages.PDOMWriter_errorWhileParsing, (Object)path);
            if (stati.size() == 1) {
                IStatus status = stati.get(0);
                if (msg.equals(status.getMessage())) {
                    throw new CoreException(status);
                }
                throw new CoreException((IStatus)new Status(status.getSeverity(), status.getPlugin(), status.getCode(), String.valueOf(msg) + ':' + status.getMessage(), status.getException()));
            }
            throw new CoreException((IStatus)new MultiStatus("org.eclipse.cdt.core", 0, stati.toArray(new IStatus[stati.size()]), msg, null));
        }
    }

    private void storeSymbolsInIndex(Map<IIndexFileLocation, Symbols> symbolMap, IIndexFileLocation[] ifls, int linkageID, int configHash, HashSet<IASTPreprocessorIncludeStatement> contextIncludes, IWritableIndex index, int readlockCount, boolean flushIndex, ArrayList<IStatus> stati, IProgressMonitor pm) throws InterruptedException, CoreException {
        index.acquireWriteLock(readlockCount);
        long start = System.currentTimeMillis();
        try {
            int i = 0;
            while (i < ifls.length) {
                if (pm.isCanceled()) {
                    return;
                }
                IIndexFileLocation ifl = ifls[i];
                if (ifl != null) {
                    if (this.fShowActivity) {
                        System.out.println("Indexer: adding " + ifl.getURI());
                    }
                    Throwable th = null;
                    try {
                        this.storeFileInIndex(index, ifl, symbolMap, linkageID, configHash, contextIncludes);
                    }
                    catch (RuntimeException e) {
                        th = e;
                    }
                    catch (PDOMNotImplementedError e) {
                        th = e;
                    }
                    catch (StackOverflowError e) {
                        th = e;
                    }
                    if (th != null) {
                        stati.add(CCorePlugin.createStatus(NLS.bind((String)Messages.PDOMWriter_errorWhileParsing, (Object)ifl.getURI().getPath()), th));
                    }
                    if (i < ifls.length - 1) {
                        this.updateFileCount(0, 0, 1);
                    }
                }
                ++i;
            }
        }
        finally {
            index.releaseWriteLock(readlockCount, flushIndex);
        }
        this.fStatistics.fAddToIndexTime = (int)((long)this.fStatistics.fAddToIndexTime + (System.currentTimeMillis() - start));
    }

    private void resolveNames(Map<IIndexFileLocation, Symbols> symbolMap, IIndexFileLocation[] ifls, ArrayList<IStatus> stati, IProgressMonitor pm) {
        long start = System.currentTimeMillis();
        IIndexFileLocation[] iIndexFileLocationArray = ifls;
        int n = ifls.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFileLocation path = iIndexFileLocationArray[n2];
            if (pm.isCanceled()) {
                return;
            }
            Symbols symbols = symbolMap.get(path);
            ArrayList<IASTName[]> names = symbols.fNames;
            boolean reported = false;
            Iterator<IASTName[]> j = names.iterator();
            while (j.hasNext()) {
                IASTName[] na = j.next();
                IASTName name = na[0];
                if (name == null) continue;
                Throwable th = null;
                try {
                    IBinding binding = name.resolveBinding();
                    if (binding instanceof IProblemBinding) {
                        ++this.fStatistics.fProblemBindingCount;
                        if (this.fShowProblems) {
                            this.reportProblem((IProblemBinding)binding);
                        }
                    } else if (name.isReference()) {
                        if (this.fSkipReferences == SKIP_TYPE_REFERENCES && this.isTypeReferenceBinding(binding) && !this.isRequiredReference(name)) {
                            na[0] = null;
                            --this.fStatistics.fReferenceCount;
                        }
                        ++this.fStatistics.fReferenceCount;
                    } else {
                        ++this.fStatistics.fDeclarationCount;
                    }
                }
                catch (RuntimeException e) {
                    th = e;
                }
                catch (PDOMNotImplementedError e) {
                    th = e;
                }
                catch (StackOverflowError e) {
                    th = e;
                }
                if (th == null) continue;
                if (!reported) {
                    stati.add(CCorePlugin.createStatus(NLS.bind((String)Messages.PDOMWriter_errorResolvingName, (Object)name.toString(), (Object)path.getURI().getPath()), th));
                }
                reported = true;
                j.remove();
            }
            ++n2;
        }
        this.fStatistics.fResolutionTime = (int)((long)this.fStatistics.fResolutionTime + (System.currentTimeMillis() - start));
    }

    private void extractSymbols(IASTTranslationUnit ast, final Map<IIndexFileLocation, Symbols> symbolMap, Collection<IASTPreprocessorIncludeStatement> contextIncludes) throws CoreException {
        IASTNode[] iASTNodeArray;
        LocationMap lm;
        HashSet<IIndexFileLocation> contextIFLs = new HashSet<IIndexFileLocation>();
        IIndexFileLocation astIFL = this.fResolver.resolveASTPath(ast.getFilePath());
        int unresolvedIncludes = 0;
        IASTPreprocessorStatement[] stmts = ast.getAllPreprocessorStatements();
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = stmts;
        int n = stmts.length;
        int n2 = 0;
        while (n2 < n) {
            IASTFileLocation sourceLoc;
            IASTPreprocessorStatement stmt = iASTPreprocessorStatementArray[n2];
            if (stmt instanceof IASTPreprocessorIncludeStatement) {
                IASTPreprocessorIncludeStatement include = (IASTPreprocessorIncludeStatement)stmt;
                IASTFileLocation astLoc = include.getFileLocation();
                IIndexFileLocation sourceIFL = astLoc != null ? this.fResolver.resolveASTPath(astLoc.getFileName()) : astIFL;
                boolean updateSource = symbolMap.containsKey(sourceIFL);
                if (updateSource) {
                    this.addToMap(symbolMap, sourceIFL, include);
                }
                if (include.isActive()) {
                    IIndexFileLocation targetIFL;
                    if (!include.isResolved()) {
                        ++unresolvedIncludes;
                    } else if (updateSource && symbolMap.containsKey(targetIFL = this.fResolver.resolveASTPath(include.getPath())) && contextIFLs.add(targetIFL)) {
                        contextIncludes.add(include);
                    }
                }
            } else if ((stmt instanceof IASTPreprocessorMacroDefinition || stmt instanceof IASTPreprocessorUndefStatement) && (sourceLoc = stmt.getFileLocation()) != null) {
                IIndexFileLocation path2 = this.fResolver.resolveASTPath(sourceLoc.getFileName());
                this.addToMap(symbolMap, path2, stmt);
            }
            ++n2;
        }
        IndexerASTVisitor visitor = new IndexerASTVisitor(){

            public void visit(IASTName name, IASTName caller) {
                IASTFileLocation nameLoc;
                if (PDOMWriter.this.fSkipReferences == SKIP_ALL_REFERENCES && name.isReference() && !PDOMWriter.this.isRequiredReference(name)) {
                    return;
                }
                if ((name = PDOMASTAdapter.getAdapterIfAnonymous(name)) != null && (nameLoc = name.getFileLocation()) != null) {
                    IIndexFileLocation location = PDOMWriter.this.fResolver.resolveASTPath(nameLoc.getFileName());
                    PDOMWriter.this.addToMap((Map<IIndexFileLocation, Symbols>)symbolMap, location, new IASTName[]{name, caller});
                }
            }
        };
        ast.accept(visitor);
        if ((this.fSkipReferences & SKIP_MACRO_REFERENCES) == 0 && (lm = (LocationMap)ast.getAdapter(LocationMap.class)) != null) {
            IASTName[] refs = lm.getMacroReferences();
            iASTNodeArray = refs;
            int n3 = refs.length;
            int n4 = 0;
            while (n4 < n3) {
                IASTName name = iASTNodeArray[n4];
                IASTFileLocation nameLoc = name.getFileLocation();
                if (nameLoc != null) {
                    IIndexFileLocation location = this.fResolver.resolveASTPath(nameLoc.getFileName());
                    IASTName[] iASTNameArray = new IASTName[2];
                    iASTNameArray[0] = name;
                    this.addToMap(symbolMap, location, iASTNameArray);
                }
                ++n4;
            }
        }
        this.fStatistics.fUnresolvedIncludesCount += unresolvedIncludes;
        this.fStatistics.fPreprocessorProblemCount += ast.getPreprocessorProblemsCount() - unresolvedIncludes;
        if (this.fShowScannerProblems || this.fShowInclusionProblems) {
            boolean reportAll = this.fShowScannerProblems && this.fShowInclusionProblems;
            IASTProblem[] scannerProblems = ast.getPreprocessorProblems();
            iASTNodeArray = scannerProblems;
            int n5 = scannerProblems.length;
            int n6 = 0;
            while (n6 < n5) {
                IASTNode problem = iASTNodeArray[n6];
                if (reportAll || problem.getID() == 0x2000002 == this.fShowInclusionProblems) {
                    this.reportProblem((IASTProblem)problem);
                }
                ++n6;
            }
        }
        List<IASTProblem> problems = visitor.getProblems();
        this.fStatistics.fSyntaxProblemsCount += problems.size();
        if (this.fShowSyntaxProblems) {
            for (IASTProblem problem : problems) {
                this.reportProblem(problem);
            }
        }
    }

    protected final boolean isRequiredReference(IASTName name) {
        IASTNode parentNode = name.getParent();
        if (parentNode instanceof ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier) {
            return true;
        }
        if (parentNode instanceof IASTDeclSpecifier) {
            IASTDeclSpecifier ds = (IASTDeclSpecifier)parentNode;
            return ds.getStorageClass() == 1;
        }
        return parentNode instanceof ICPPASTUsingDirective;
    }

    private boolean isTypeReferenceBinding(IBinding binding) {
        return binding instanceof ICompositeType || binding instanceof IEnumeration || binding instanceof ITypedef || binding instanceof ICPPNamespace || binding instanceof ICPPNamespaceAlias || binding instanceof ICPPClassTemplate;
    }

    private void addToMap(Map<IIndexFileLocation, Symbols> map, IIndexFileLocation location, IASTName[] thing) {
        Symbols lists = map.get(location);
        if (lists != null) {
            lists.fNames.add(thing);
        }
    }

    private void addToMap(Map<IIndexFileLocation, Symbols> map, IIndexFileLocation location, IASTPreprocessorIncludeStatement thing) {
        Symbols lists = map.get(location);
        if (lists != null) {
            lists.fIncludes.add(thing);
        }
    }

    private void addToMap(Map<IIndexFileLocation, Symbols> map, IIndexFileLocation location, IASTPreprocessorStatement thing) {
        Symbols lists = map.get(location);
        if (lists != null) {
            lists.fMacros.add(thing);
        }
    }

    private boolean prepareInMap(Map<IIndexFileLocation, Symbols> map, IIndexFileLocation location) {
        if (map.get(location) == null) {
            map.put(location, new Symbols());
        }
        return false;
    }

    private IIndexFragmentFile storeFileInIndex(IWritableIndex index, IIndexFileLocation location, Map<IIndexFileLocation, Symbols> symbolMap, int linkageID, int configHash, Set<IASTPreprocessorIncludeStatement> contextIncludes) throws CoreException {
        Set<IIndexFileLocation> clearedContexts = Collections.emptySet();
        IIndexFragmentFile file = index.getWritableFile(linkageID, location);
        if (file != null) {
            clearedContexts = new HashSet();
            index.clearFile(file, clearedContexts);
        } else {
            file = index.addFile(linkageID, location);
        }
        file.setTimestamp(this.fResolver.getLastModified(location));
        file.setScannerConfigurationHashcode(configHash);
        Symbols lists = symbolMap.get(location);
        if (lists != null) {
            IASTName[][] names;
            IASTPreprocessorStatement[] macros = lists.fMacros.toArray(new IASTPreprocessorStatement[lists.fMacros.size()]);
            IASTName[][] iASTNameArray = names = (IASTName[][])lists.fNames.toArray((T[])new IASTName[lists.fNames.size()][]);
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                IASTName[] name2 = iASTNameArray[n2];
                IASTName name = name2[0];
                if (name != null) {
                    ASTInternal.setFullyResolved(name.getBinding(), true);
                }
                ++n2;
            }
            IWritableIndex.IncludeInformation[] includeInfos = new IWritableIndex.IncludeInformation[lists.fIncludes.size()];
            int i = 0;
            while (i < lists.fIncludes.size()) {
                IASTPreprocessorIncludeStatement include = lists.fIncludes.get(i);
                IWritableIndex.IncludeInformation info = includeInfos[i] = new IWritableIndex.IncludeInformation();
                info.fStatement = include;
                if (include.isResolved()) {
                    info.fLocation = this.fResolver.resolveASTPath(include.getPath());
                    info.fIsContext = include.isActive() && (contextIncludes.contains(include) || clearedContexts.contains(info.fLocation));
                }
                ++i;
            }
            index.setFileContent(file, linkageID, includeInfos, macros, names, this.fResolver);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexerProgress getProgressInformation() {
        IndexerProgress indexerProgress = this.fInfo;
        synchronized (indexerProgress) {
            return new IndexerProgress(this.fInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateFileCount(int sources, int primaryHeader, int header) {
        IndexerProgress indexerProgress = this.fInfo;
        synchronized (indexerProgress) {
            this.fInfo.fCompletedSources += sources;
            this.fInfo.fPrimaryHeaderCount += primaryHeader;
            this.fInfo.fCompletedHeaders += header;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateRequestedFiles(int delta) {
        IndexerProgress indexerProgress = this.fInfo;
        synchronized (indexerProgress) {
            this.fInfo.fRequestedFilesCount += delta;
        }
    }

    private String getLocationInfo(String filename, int lineNumber) {
        return " at " + filename + "(" + lineNumber + ")";
    }

    private void reportProblem(IProblemBinding problem) {
        String msg = "Indexer: unresolved name" + this.getLocationInfo(problem.getFileName(), problem.getLineNumber());
        String pmsg = problem.getMessage();
        if (pmsg != null && pmsg.length() > 0) {
            msg = String.valueOf(msg) + "; " + problem.getMessage();
        }
        System.out.println(msg);
    }

    private void reportProblem(IASTProblem problem) {
        String msg = "Indexer: " + problem.getMessageWithLocation();
        System.out.println(msg);
    }

    private static class Symbols {
        ArrayList<IASTName[]> fNames = new ArrayList();
        ArrayList<IASTPreprocessorStatement> fMacros = new ArrayList();
        ArrayList<IASTPreprocessorIncludeStatement> fIncludes = new ArrayList();

        private Symbols() {
        }
    }
}

