/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPUnknownScope;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPUnknownClassType
extends PDOMCPPBinding
implements ICPPClassScope,
ICPPUnknownClassType,
IPDOMMemberOwner,
IIndexType,
IIndexScope {
    private static final int KEY = 28;
    private static final int MEMBERLIST = 32;
    protected static final int RECORD_SIZE = 36;
    private ICPPScope unknownScope;

    public PDOMCPPUnknownClassType(PDOM pdom, PDOMNode parent, ICPPUnknownClassType classType) throws CoreException {
        super(pdom, parent, classType.getNameCharArray());
        this.setKind(classType);
    }

    public PDOMCPPUnknownClassType(PDOM pdom, int bindingRecord) {
        super(pdom, bindingRecord);
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof ICPPClassType) {
            ICPPClassType ct = (ICPPClassType)newBinding;
            this.setKind(ct);
            super.update(linkage, newBinding);
        }
    }

    private void setKind(ICPPClassType ct) throws CoreException {
        try {
            this.pdom.getDB().putByte(this.record + 28, (byte)ct.getKey());
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public void addMember(PDOMNode member) throws CoreException {
        PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 32, this.getLinkageImpl());
        list.addMember(member);
    }

    protected int getRecordSize() {
        return 36;
    }

    public int getNodeType() {
        return 47;
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
        super.accept(visitor);
        PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 32, this.getLinkageImpl());
        list.accept(visitor);
    }

    public ICPPMethod[] getImplicitMethods() {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    public IScope getCompositeScope() throws DOMException {
        return this;
    }

    public ICPPScope getUnknownScope() {
        if (this.unknownScope == null) {
            this.unknownScope = new PDOMCPPUnknownScope(this, this.getUnknownName());
        }
        return this.unknownScope;
    }

    public IIndexBinding getScopeBinding() {
        return this;
    }

    public boolean isGloballyQualified() throws DOMException {
        try {
            return this.getParentNode() instanceof PDOMLinkage;
        }
        catch (CoreException coreException) {
            return true;
        }
    }

    public ICPPClassType getClassType() {
        return this;
    }

    public void addChild(PDOMNode member) throws CoreException {
        this.addMember(member);
    }

    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) throws DOMException {
        return null;
    }

    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) throws DOMException {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    public IBinding[] find(String name) throws DOMException {
        return CPPSemantics.findBindings((IScope)this, name, false);
    }

    public Object clone() {
        this.fail();
        return null;
    }

    public IField findField(String name) throws DOMException {
        this.fail();
        return null;
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public ICPPBase[] getBases() {
        return ICPPBase.EMPTY_BASE_ARRAY;
    }

    public IField[] getFields() {
        return IField.EMPTY_FIELD_ARRAY;
    }

    public ICPPField[] getDeclaredFields() {
        return ICPPField.EMPTY_CPPFIELD_ARRAY;
    }

    public ICPPMethod[] getMethods() {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    public ICPPMethod[] getAllDeclaredMethods() {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    public ICPPMethod[] getDeclaredMethods() {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    public ICPPConstructor[] getConstructors() {
        return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
    }

    public IBinding[] getFriends() {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    public int getKey() {
        return 0;
    }

    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (type instanceof ICPPUnknownClassType && !(type instanceof ICPPUnknownClassInstance) && !(type instanceof ICPPDeferredClassInstance)) {
            ICPPUnknownClassType rhs = (ICPPUnknownClassType)type;
            if (CharArrayUtils.equals(this.getNameCharArray(), rhs.getNameCharArray())) {
                ICPPUnknownBinding lhsContainer = this.getUnknownContainerBinding();
                ICPPUnknownBinding rhsContainer = rhs.getUnknownContainerBinding();
                if (lhsContainer instanceof IType && rhsContainer instanceof IType) {
                    return ((IType)((Object)lhsContainer)).isSameType((IType)((Object)rhsContainer));
                }
            }
        }
        return false;
    }

    public ICPPClassType[] getNestedClasses() {
        return ICPPClassType.EMPTY_CLASS_ARRAY;
    }

    public IBinding resolvePartially(ICPPUnknownBinding parentBinding, ObjectMap argMap, ICPPScope instantiationScope) {
        if (parentBinding instanceof PDOMNode && this.isChildOf((PDOMNode)((Object)parentBinding))) {
            return this;
        }
        return new CPPUnknownClass(parentBinding, this.getUnknownName());
    }

    public IASTName getUnknownName() {
        return new CPPASTName(this.getNameCharArray());
    }

    public ICPPUnknownBinding getUnknownContainerBinding() {
        try {
            return (ICPPUnknownBinding)((Object)this.getParentBinding());
        }
        catch (CoreException coreException) {
            return null;
        }
    }
}

