/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.utils.CygPath;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorParserManager
extends OutputStream {
    private int nOpens;
    private static final String OLD_PREF_ERROR_PARSER = "errorOutputParser";
    public static final String PREF_ERROR_PARSER = "org.eclipse.cdt.core.errorOutputParser";
    private IProject fProject;
    private IMarkerGenerator fMarkerGenerator;
    private Map<String, Object> fFilesInProject;
    private Map<String, IErrorParser[]> fErrorParsers;
    private ArrayList<ProblemMarkerInfo> fErrors;
    private Vector<IPath> fDirectoryStack;
    private IPath fBaseDirectory;
    private String previousLine;
    private OutputStream outputStream;
    private StringBuffer currentLine = new StringBuffer();
    private StringBuffer scratchBuffer = new StringBuffer();
    private boolean hasErrors = false;

    public ErrorParserManager(ACBuilder builder) {
        this(builder.getProject(), builder);
    }

    public ErrorParserManager(IProject project, IMarkerGenerator markerGenerator) {
        this(project, markerGenerator, null);
    }

    public ErrorParserManager(IProject project, IMarkerGenerator markerGenerator, String[] parsersIDs) {
        this(project, project.getLocation(), markerGenerator, parsersIDs);
    }

    public ErrorParserManager(IProject project, IPath workingDirectory, IMarkerGenerator markerGenerator, String[] parsersIDs) {
        this.fProject = project;
        if (parsersIDs == null) {
            this.enableAllParsers();
        } else {
            this.fErrorParsers = new LinkedHashMap<String, IErrorParser[]>(parsersIDs.length);
            String[] stringArray = parsersIDs;
            int n = parsersIDs.length;
            int n2 = 0;
            while (n2 < n) {
                String parsersID = stringArray[n2];
                IErrorParser[] parsers = CCorePlugin.getDefault().getErrorParser(parsersID);
                this.fErrorParsers.put(parsersID, parsers);
                ++n2;
            }
        }
        this.fMarkerGenerator = markerGenerator;
        this.initErrorParserManager(workingDirectory);
    }

    private void initErrorParserManager(IPath workingDirectory) {
        this.fFilesInProject = new HashMap<String, Object>();
        this.fDirectoryStack = new Vector();
        this.fErrors = new ArrayList();
        ArrayList<IResource> collectedFiles = new ArrayList<IResource>();
        this.fBaseDirectory = workingDirectory == null || workingDirectory.isEmpty() ? this.fProject.getLocation() : workingDirectory;
        this.collectFiles(this.fProject, collectedFiles);
        int i = 0;
        while (i < collectedFiles.size()) {
            IFile file = (IFile)collectedFiles.get(i);
            String filename = file.getName();
            Object existing = this.fFilesInProject.put(filename, file);
            if (existing != null) {
                Collection<IFile> files;
                if (existing instanceof IFile) {
                    files = new ArrayList<IFile>();
                    files.add((IFile)existing);
                } else {
                    Collection casted = (Collection)existing;
                    files = casted;
                }
                files.add(file);
                this.fFilesInProject.put(filename, files);
            }
            ++i;
        }
    }

    public IProject getProject() {
        return this.fProject;
    }

    public IPath getWorkingDirectory() {
        if (this.fDirectoryStack.size() != 0) {
            return this.fDirectoryStack.lastElement();
        }
        return this.fBaseDirectory;
    }

    public void pushDirectory(IPath dir) {
        if (dir != null) {
            IPath pwd = null;
            if (this.fBaseDirectory.isPrefixOf(dir)) {
                int segments = this.fBaseDirectory.matchingFirstSegments(dir);
                pwd = dir.removeFirstSegments(segments);
            } else {
                pwd = dir;
            }
            this.fDirectoryStack.addElement(pwd);
        }
    }

    public IPath popDirectory() {
        int i = this.fDirectoryStack.size();
        if (i != 0) {
            IPath dir = this.fDirectoryStack.lastElement();
            this.fDirectoryStack.removeElementAt(i - 1);
            return dir;
        }
        return new Path("");
    }

    public int getDirectoryLevel() {
        return this.fDirectoryStack.size();
    }

    private void enableAllParsers() {
        String[] parserIDs;
        this.fErrorParsers = new LinkedHashMap<String, IErrorParser[]>();
        String[] stringArray = parserIDs = CCorePlugin.getDefault().getAllErrorParsersIDs();
        int n = parserIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String parserID = stringArray[n2];
            IErrorParser[] parsers = CCorePlugin.getDefault().getErrorParser(parserID);
            this.fErrorParsers.put(parserID, parsers);
            ++n2;
        }
        if (this.fErrorParsers.size() == 0) {
            this.initErrorParsersMap();
            CCorePlugin.getDefault().getPluginPreferences().setValue(OLD_PREF_ERROR_PARSER, "");
        }
    }

    private void initErrorParsersMap() {
        String[] parserIDs;
        String[] stringArray = parserIDs = CCorePlugin.getDefault().getAllErrorParsersIDs();
        int n = parserIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String parserID = stringArray[n2];
            IErrorParser[] parsers = CCorePlugin.getDefault().getErrorParser(parserID);
            this.fErrorParsers.put(parserID, parsers);
            ++n2;
        }
    }

    protected void collectFiles(IProject parent, final List<IResource> result) {
        try {
            parent.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) {
                    if (proxy.getType() == 1) {
                        result.add(proxy.requestResource());
                        return false;
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException e) {
            CCorePlugin.log(e.getStatus());
        }
    }

    private void processLine(String line) {
        if (this.fErrorParsers.size() == 0) {
            return;
        }
        if (line.length() > 1000) {
            return;
        }
        String[] parserIDs = new String[this.fErrorParsers.size()];
        Iterator<String> items = this.fErrorParsers.keySet().iterator();
        int i = 0;
        while (items.hasNext()) {
            parserIDs[i] = items.next();
            ++i;
        }
        i = 0;
        while (i < parserIDs.length) {
            IErrorParser[] parsers;
            IErrorParser[] iErrorParserArray = parsers = this.fErrorParsers.get(parserIDs[i]);
            int n = parsers.length;
            int n2 = 0;
            while (n2 < n) {
                IErrorParser curr = iErrorParserArray[n2];
                if (curr.processLine(line, this)) {
                    return;
                }
                ++n2;
            }
            ++i;
        }
    }

    public IFile findFileName(String fileName) {
        Path path = new Path(fileName);
        Object obj = this.fFilesInProject.get(path.lastSegment());
        if (obj == null) {
            return null;
        }
        if (obj instanceof IFile) {
            IFile file = (IFile)obj;
            if (this.isPossibleMatch((IPath)path, file.getLocation())) {
                return file;
            }
            return null;
        }
        IFile matchingFile = null;
        Collection files = (Collection)obj;
        for (IFile file : files) {
            if (!this.isPossibleMatch((IPath)path, file.getLocation())) continue;
            if (matchingFile != null) {
                return null;
            }
            matchingFile = file;
        }
        return matchingFile;
    }

    private boolean isPossibleMatch(IPath location, IPath absoluteLocation) {
        Assert.isLegal((boolean)absoluteLocation.isAbsolute());
        if (location.isAbsolute()) {
            return location.equals((Object)absoluteLocation);
        }
        int prefixLen = absoluteLocation.segmentCount() - location.segmentCount();
        return prefixLen >= 0 && absoluteLocation.removeFirstSegments(prefixLen).equals((Object)location);
    }

    protected IFile findFileInWorkspace(IPath path) {
        IFile file = null;
        if (path.isAbsolute()) {
            IWorkspaceRoot root = this.fProject.getWorkspace().getRoot();
            file = root.getFileForLocation(path);
            if (file == null) {
                IFile[] files;
                IFile[] iFileArray = files = root.findFilesForLocation(path);
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile file2 = iFileArray[n2];
                    if (file2.getProject().equals((Object)this.fProject)) {
                        file = file2;
                        break;
                    }
                    ++n2;
                }
            }
        } else {
            file = this.fProject.getFile(path);
        }
        return file;
    }

    public boolean isConflictingName(String fileName) {
        Path path = new Path(fileName);
        Object obj = this.fFilesInProject.get(path.lastSegment());
        return obj != null && !(obj instanceof IFile);
    }

    public IFile findFilePath(String filePath) {
        IFile file;
        IPath path;
        block20: {
            path = null;
            Path fp = new Path(filePath);
            if (fp.isAbsolute()) {
                if (this.fBaseDirectory.isPrefixOf((IPath)fp)) {
                    int segments = this.fBaseDirectory.matchingFirstSegments((IPath)fp);
                    path = fp.removeFirstSegments(segments);
                } else {
                    path = fp;
                }
            } else {
                path = this.getWorkingDirectory().append(filePath);
            }
            file = null;
            try {
                file = this.findFileInWorkspace(path);
            }
            catch (Exception exception) {}
            if (file == null) {
                CygPath cygpath = null;
                try {
                    try {
                        cygpath = new CygPath();
                        fp = new Path(cygpath.getFileName(filePath));
                        if (this.fBaseDirectory.isPrefixOf((IPath)fp)) {
                            int segments = this.fBaseDirectory.matchingFirstSegments((IPath)fp);
                            path = fp.removeFirstSegments(segments);
                        } else {
                            path = fp;
                        }
                        file = this.findFileInWorkspace(path);
                    }
                    catch (Exception exception) {
                        if (cygpath != null) {
                            cygpath.dispose();
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (cygpath != null) {
                        cygpath.dispose();
                    }
                    throw throwable;
                }
                if (cygpath != null) {
                    cygpath.dispose();
                }
            }
        }
        if (file == null || !file.exists()) {
            File f = path.toFile();
            try {
                String canon = f.getCanonicalPath();
                path = new Path(canon);
                file = this.findFileInWorkspace(path);
            }
            catch (IOException iOException) {}
        }
        return file != null && file.exists() ? file : null;
    }

    public void generateMarker(IResource file, int lineNumber, String desc, int severity, String varName) {
        this.generateExternalMarker(file, lineNumber, desc, severity, varName, null);
    }

    public void generateExternalMarker(IResource file, int lineNumber, String desc, int severity, String varName, IPath externalPath) {
        ProblemMarkerInfo problemMarkerInfo = new ProblemMarkerInfo(file, lineNumber, desc, severity, varName, externalPath);
        this.fErrors.add(problemMarkerInfo);
        if (severity == 2) {
            this.hasErrors = true;
        }
    }

    public String getPreviousLine() {
        return new String(this.previousLine == null ? "" : this.previousLine);
    }

    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    public OutputStream getOutputStream() {
        ++this.nOpens;
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.nOpens > 0 && --this.nOpens == 0) {
            this.checkLine(true);
            this.fDirectoryStack.removeAllElements();
            this.fBaseDirectory = null;
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.currentLine.append((char)b);
        this.checkLine(false);
        if (this.outputStream != null) {
            this.outputStream.write(b);
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off != 0 || len < 0 || len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.currentLine.append(new String(b, 0, len));
        this.checkLine(false);
        if (this.outputStream != null) {
            this.outputStream.write(b, off, len);
        }
    }

    private void checkLine(boolean flush) {
        String buffer = this.currentLine.toString();
        int i = 0;
        while ((i = buffer.indexOf(10)) != -1) {
            String line = buffer.substring(0, i).trim();
            this.processLine(line);
            this.previousLine = line;
            buffer = buffer.substring(i + 1);
        }
        this.currentLine.setLength(0);
        if (flush) {
            if (buffer.length() > 0) {
                this.processLine(buffer);
                this.previousLine = buffer;
            }
        } else {
            this.currentLine.append(buffer);
        }
    }

    public boolean reportProblems() {
        boolean reset = false;
        if (this.nOpens == 0) {
            for (ProblemMarkerInfo problemMarkerInfo : this.fErrors) {
                if (problemMarkerInfo.severity == 3) {
                    reset = true;
                }
                this.fMarkerGenerator.addMarker(problemMarkerInfo);
            }
            this.fErrors.clear();
        }
        return reset;
    }

    public String getScratchBuffer() {
        return this.scratchBuffer.toString();
    }

    public void appendToScratchBuffer(String line) {
        this.scratchBuffer.append(line);
    }

    public void clearScratchBuffer() {
        this.scratchBuffer.setLength(0);
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }
}

