/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.ASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblemExpression;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTCompoundStatementExpression;
import org.eclipse.cdt.core.dom.parser.IBuiltinBindingsProvider;
import org.eclipse.cdt.core.dom.parser.ISourceCodeParser;
import org.eclipse.cdt.core.parser.AbstractParserLogService;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.OffsetLimitReachedException;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.BacktrackException;
import org.eclipse.cdt.internal.core.dom.parser.DeclarationOptions;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousExpression;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousStatement;
import org.eclipse.cdt.internal.core.dom.parser.ParserLogServiceWrapper;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.parser.scanner.ILocationResolver;

public abstract class AbstractGNUSourceCodeParser
implements ISourceCodeParser {
    protected static final int DEFAULT_DESIGNATOR_LIST_SIZE = 4;
    protected static int parseCount = 0;
    protected final AbstractParserLogService log;
    protected final IScanner scanner;
    protected final ParserMode mode;
    protected final boolean supportStatementsInExpressions;
    protected final boolean supportTypeOfUnaries;
    protected final boolean supportAlignOfUnaries;
    protected final boolean supportKnRC;
    protected final boolean supportAttributeSpecifiers;
    protected final boolean supportDeclspecSpecifiers;
    protected boolean supportParameterInfoBlock;
    protected boolean supportFunctionStyleAsm;
    protected boolean supportExtendedSizeofOperator;
    protected final IBuiltinBindingsProvider builtinBindingsProvider;
    protected IToken declarationMark;
    protected IToken currToken;
    protected int eofOffset;
    protected boolean onTopInTemplateArgs = false;
    protected boolean inBinaryExpression = true;
    protected boolean isCancelled = false;
    protected boolean parsePassed = true;
    protected int backtrackCount = 0;
    protected BacktrackException backtrack = new BacktrackException();
    protected ASTCompletionNode completionNode;
    protected IASTTypeId fTypeIdForCastAmbiguity;

    protected AbstractGNUSourceCodeParser(IScanner scanner, IParserLogService logService, ParserMode parserMode, boolean supportStatementsInExpressions, boolean supportTypeOfUnaries, boolean supportAlignOfUnaries, boolean supportKnRC, boolean supportAttributeSpecifiers, boolean supportDeclspecSpecifiers, IBuiltinBindingsProvider builtinBindingsProvider) {
        this.scanner = scanner;
        this.log = this.wrapLogService(logService);
        this.mode = parserMode;
        this.supportStatementsInExpressions = supportStatementsInExpressions;
        this.supportTypeOfUnaries = supportTypeOfUnaries;
        this.supportAlignOfUnaries = supportAlignOfUnaries;
        this.supportKnRC = supportKnRC;
        this.supportAttributeSpecifiers = supportAttributeSpecifiers;
        this.supportDeclspecSpecifiers = supportDeclspecSpecifiers;
        this.builtinBindingsProvider = builtinBindingsProvider;
    }

    public void setSupportParameterInfoBlock(boolean val) {
        this.supportParameterInfoBlock = val;
    }

    public void setSupportExtendedSizeofOperator(boolean val) {
        this.supportExtendedSizeofOperator = val;
    }

    public void setSupportFunctionStyleAssembler(boolean val) {
        this.supportFunctionStyleAsm = val;
    }

    private AbstractParserLogService wrapLogService(IParserLogService logService) {
        if (logService instanceof AbstractParserLogService) {
            return (AbstractParserLogService)logService;
        }
        return new ParserLogServiceWrapper(logService);
    }

    protected final void throwBacktrack(int offset, int length) throws BacktrackException {
        ++this.backtrackCount;
        this.backtrack.initialize(offset, length < 0 ? 0 : length);
        throw this.backtrack;
    }

    public IASTCompletionNode getCompletionNode() {
        return this.completionNode;
    }

    protected ASTCompletionNode createCompletionNode(IToken token) {
        if (this.completionNode == null && token != null && token.getType() == 140) {
            this.completionNode = new ASTCompletionNode(token, this.getTranslationUnit());
        }
        return this.completionNode;
    }

    protected IToken LA(int i) throws EndOfFileException {
        if (this.isCancelled) {
            throw new ParseError(ParseError.ParseErrorKind.TIMEOUT_OR_CANCELLED);
        }
        if (i < 1) {
            return null;
        }
        if (this.currToken == null) {
            this.currToken = this.fetchToken();
        }
        IToken retToken = this.currToken;
        while (i > 1) {
            if ((retToken = retToken.getNext()) == null) {
                retToken = this.fetchToken();
            }
            --i;
        }
        return retToken;
    }

    protected IToken LAcatchEOF(int i) {
        try {
            return this.LA(i);
        }
        catch (EndOfFileException endOfFileException) {
            return null;
        }
    }

    protected int LT(int i) throws EndOfFileException {
        return this.LA(i).getType();
    }

    protected int LTcatchEOF(int i) {
        try {
            return this.LT(i);
        }
        catch (EndOfFileException endOfFileException) {
            return 0;
        }
    }

    protected boolean isOnSameLine(int offset1, int offset2) {
        ILocationResolver lr = (ILocationResolver)this.getTranslationUnit().getAdapter(ILocationResolver.class);
        IASTFileLocation floc = lr.getMappedFileLocation(offset1, offset2 - offset1 + 1);
        return floc.getFileName().equals(lr.getContainingFilePath(offset1)) && floc.getStartingLineNumber() == floc.getEndingLineNumber();
    }

    protected int calculateEndOffset(IASTNode n) {
        ASTNode node = (ASTNode)n;
        return node.getOffset() + node.getLength();
    }

    protected void setRange(IASTNode n, IASTNode from) {
        ((ASTNode)n).setOffsetAndLength((ASTNode)from);
    }

    protected void setRange(IASTNode n, int offset, int endOffset) {
        ((ASTNode)n).setOffsetAndLength(offset, endOffset - offset);
    }

    protected void adjustLength(IASTNode n, IASTNode endNode) {
        int endOffset = this.calculateEndOffset(endNode);
        ASTNode node = (ASTNode)n;
        node.setLength(endOffset - node.getOffset());
    }

    protected IToken consume() throws EndOfFileException {
        if (this.currToken == null) {
            this.currToken = this.fetchToken();
        }
        IToken lastToken = this.currToken;
        this.currToken = lastToken.getNext();
        return lastToken;
    }

    protected IToken consume(int type) throws EndOfFileException, BacktrackException {
        IToken la1 = this.LA(1);
        if (la1.getType() != type) {
            this.throwBacktrack(la1);
        }
        return this.consume();
    }

    protected IToken consumeOrEOC(int type) throws EndOfFileException, BacktrackException {
        IToken la1 = this.LA(1);
        int lt1 = la1.getType();
        if (lt1 != type) {
            if (lt1 == 141) {
                return la1;
            }
            this.throwBacktrack(la1);
        }
        return this.consume();
    }

    protected IToken fetchToken() throws EndOfFileException {
        try {
            IToken result = this.scanner.nextToken();
            this.eofOffset = result.getEndOffset();
            return result;
        }
        catch (OffsetLimitReachedException olre) {
            this.handleOffsetLimitException(olre);
            return null;
        }
    }

    protected void handleOffsetLimitException(OffsetLimitReachedException exception) throws EndOfFileException {
        if (this.mode != ParserMode.COMPLETION_PARSE) {
            throw new EndOfFileException();
        }
        this.createCompletionNode(exception.getFinalToken());
        throw exception;
    }

    protected IToken mark() throws EndOfFileException {
        return this.currToken == null ? (this.currToken = this.fetchToken()) : this.currToken;
    }

    protected void backup(IToken mark) {
        this.currToken = mark;
    }

    protected void failParse() {
        this.parsePassed = false;
    }

    public synchronized void cancel() {
        this.isCancelled = true;
    }

    protected IToken identifier() throws EndOfFileException, BacktrackException {
        switch (this.LT(1)) {
            case 1: 
            case 140: 
            case 141: {
                return this.consume();
            }
        }
        throw this.backtrack;
    }

    public final int getBacktrackCount() {
        return this.backtrackCount;
    }

    protected IASTProblem createProblem(BacktrackException bt) {
        IASTProblem result = bt.getProblem();
        if (result == null) {
            result = this.createProblem(0x4000001, bt.getOffset(), bt.getLength());
        }
        return result;
    }

    protected abstract IASTProblem createProblem(int var1, int var2, int var3);

    protected void logThrowable(String methodName, Throwable e) {
        if (e != null) {
            if (this.log.isTracing()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Parser: Unexpected throwable in ");
                buffer.append(methodName);
                buffer.append(":");
                buffer.append(e.getClass().getName());
                buffer.append("::");
                buffer.append(e.getMessage());
                buffer.append(". w/");
                buffer.append(this.scanner.toString());
                this.log.traceLog(buffer.toString());
            }
            this.log.traceException(e);
        }
    }

    public String toString() {
        return this.scanner.toString();
    }

    protected void logException(String methodName, Exception e) {
        if (!(e instanceof EndOfFileException) && e != null) {
            if (this.log.isTracing()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Parser: Unexpected exception in ");
                buffer.append(methodName);
                buffer.append(":");
                buffer.append(e.getClass().getName());
                buffer.append("::");
                buffer.append(e.getMessage());
                buffer.append(". w/");
                buffer.append(this.scanner.toString());
                this.log.traceLog(buffer.toString());
            }
            this.log.traceException(e);
        }
    }

    protected final void throwBacktrack(IASTProblem problem, IASTNode node) throws BacktrackException {
        ++this.backtrackCount;
        this.backtrack.initialize(problem, node);
        throw this.backtrack;
    }

    protected final void throwBacktrack(IASTProblem problem) throws BacktrackException {
        ++this.backtrackCount;
        this.backtrack.initialize(problem);
        throw this.backtrack;
    }

    public IASTTranslationUnit parse() {
        long startTime = System.currentTimeMillis();
        this.translationUnit();
        this.log.traceLog("Parse " + ++parseCount + ": " + (System.currentTimeMillis() - startTime) + "ms" + (this.parsePassed ? "" : " - parse failure"));
        startTime = System.currentTimeMillis();
        this.resolveAmbiguities();
        this.log.traceLog("Ambiguity resolution : " + (System.currentTimeMillis() - startTime) + "ms");
        IASTTranslationUnit result = this.getTranslationUnit();
        this.nullifyTranslationUnit();
        return result;
    }

    protected void resolveAmbiguities() {
        IASTTranslationUnit translationUnit = this.getTranslationUnit();
        translationUnit.accept(this.createAmbiguityNodeVisitor());
        if (translationUnit instanceof ASTTranslationUnit) {
            ((ASTTranslationUnit)translationUnit).cleanupAfterAmbiguityResolution();
        }
    }

    protected abstract ASTVisitor createAmbiguityNodeVisitor();

    protected abstract void nullifyTranslationUnit();

    protected IToken skipOverCompoundStatement() throws BacktrackException, EndOfFileException {
        this.consume(12);
        IToken result = null;
        int depth = 1;
        while (depth > 0) {
            result = this.consume();
            switch (result.getType()) {
                case 13: {
                    --depth;
                    break;
                }
                case 12: {
                    ++depth;
                    break;
                }
                case 141: {
                    throw new EndOfFileException();
                }
            }
        }
        return result;
    }

    protected IASTProblemDeclaration skipProblemDeclaration(int offset) {
        this.failParse();
        this.declarationMark = null;
        int endOffset = this.skipToSemiOrClosingBrace(offset, false);
        IASTProblem problem = this.createProblem(0x4000001, offset, endOffset - offset);
        return this.createProblemDeclaration(problem);
    }

    protected IASTProblemStatement skipProblemStatement(int offset) {
        this.failParse();
        this.declarationMark = null;
        int endOffset = this.skipToSemiOrClosingBrace(offset, false);
        IASTProblem problem = this.createProblem(0x4000001, offset, endOffset - offset);
        return this.createProblemStatement(problem);
    }

    private IASTProblem skipProblemEnumerator(int offset) {
        this.failParse();
        int endOffset = this.skipToSemiOrClosingBrace(offset, true);
        return this.createProblem(0x4000001, offset, endOffset - offset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int skipToSemiOrClosingBrace(int offset, boolean eatBrace) {
        this.failParse();
        this.declarationMark = null;
        int depth = 0;
        try {
            int endOffset = this.LA(1).getOffset();
            while (true) {
                switch (this.LT(1)) {
                    case 141: {
                        return this.eofOffset;
                    }
                    case 5: {
                        if (depth != 0) break;
                        return this.consume().getEndOffset();
                    }
                    case 12: {
                        ++depth;
                        break;
                    }
                    case 13: {
                        if (--depth > 0) break;
                        if (depth == 0 || offset == endOffset || eatBrace) {
                            endOffset = this.consume().getEndOffset();
                        }
                        if (this.LTcatchEOF(1) != 5) return endOffset;
                        return this.consume().getEndOffset();
                    }
                }
                endOffset = this.consume().getEndOffset();
            }
        }
        catch (EndOfFileException endOfFileException) {
            return this.eofOffset;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IASTProblemExpression skipProblemConditionInParenthesis(int offset) {
        int endOffset;
        block11: {
            this.failParse();
            int compExpr = 0;
            int depth = 0;
            endOffset = offset;
            try {
                while (true) {
                    switch (this.LT(1)) {
                        case 141: {
                            endOffset = this.eofOffset;
                            break block11;
                        }
                        case 5: 
                        case 12: {
                            if (compExpr != 0) break;
                            break block11;
                        }
                        case 8: {
                            ++depth;
                            if (this.LTcatchEOF(2) != 12) break;
                            if (compExpr == 0) {
                                compExpr = depth;
                            }
                            this.consume();
                            break;
                        }
                        case 9: {
                            if (--depth < 0) break block11;
                            if (depth >= compExpr) break;
                            compExpr = 0;
                        }
                    }
                    endOffset = this.consume().getEndOffset();
                }
            }
            catch (EndOfFileException endOfFileException) {
                endOffset = this.eofOffset;
            }
        }
        IASTProblem problem = this.createProblem(0x4000001, offset, endOffset - offset);
        return this.createProblemExpression(problem);
    }

    protected IASTCompoundStatement compoundStatement() throws EndOfFileException, BacktrackException {
        IASTCompoundStatement result = this.createCompoundStatement();
        if (this.LT(1) == 141) {
            return result;
        }
        int offset = this.LA(1).getOffset();
        int endOffset = this.consume(12).getOffset();
        int stmtOffset = -1;
        while (true) {
            IToken next;
            if ((next = this.LAcatchEOF(1)) == null) {
                ((ASTNode)((Object)result)).setOffsetAndLength(offset, endOffset - offset);
                this.throwBacktrack(this.createProblem(0x4000001, endOffset, 0), result);
                return null;
            }
            if (next.getType() == 141) break;
            try {
                IASTStatement stmt;
                if (next.getType() == 13) {
                    endOffset = this.consume().getEndOffset();
                    break;
                }
                int nextOffset = next.getOffset();
                this.declarationMark = next;
                next = null;
                if (stmtOffset == nextOffset) {
                    stmt = this.skipProblemStatement(stmtOffset);
                } else {
                    stmtOffset = nextOffset;
                    stmt = this.statement();
                }
                result.addStatement(stmt);
                endOffset = this.calculateEndOffset(stmt);
            }
            catch (BacktrackException backtrackException) {
                IASTProblemStatement stmt = this.skipProblemStatement(stmtOffset);
                result.addStatement(stmt);
                endOffset = this.calculateEndOffset(stmt);
                this.declarationMark = null;
                continue;
            }
            catch (EndOfFileException endOfFileException) {
                try {
                    IASTProblemStatement stmt = this.skipProblemStatement(stmtOffset);
                    result.addStatement(stmt);
                    endOffset = this.calculateEndOffset(stmt);
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.declarationMark = null;
                }
            }
            this.declarationMark = null;
            continue;
            break;
        }
        ((ASTNode)((Object)result)).setOffsetAndLength(offset, endOffset - offset);
        return result;
    }

    protected abstract IASTProblemStatement createProblemStatement();

    protected abstract IASTProblemDeclaration createProblemDeclaration();

    protected abstract IASTCompoundStatement createCompoundStatement();

    private IASTProblemDeclaration createProblemDeclaration(IASTProblem problem) {
        IASTProblemDeclaration pd = this.createProblemDeclaration();
        pd.setProblem(problem);
        ((ASTNode)((Object)pd)).setOffsetAndLength((ASTNode)((Object)problem));
        return pd;
    }

    private IASTProblemStatement createProblemStatement(IASTProblem problem) {
        IASTProblemStatement pstmt = this.createProblemStatement();
        pstmt.setProblem(problem);
        ((ASTNode)((Object)pstmt)).setOffsetAndLength((ASTNode)((Object)problem));
        return pstmt;
    }

    private IASTProblemExpression createProblemExpression(IASTProblem problem) {
        IASTProblemExpression pexpr = this.createProblemExpression();
        pexpr.setProblem(problem);
        ((ASTNode)((Object)pexpr)).setOffsetAndLength((ASTNode)((Object)problem));
        return pexpr;
    }

    protected IASTExpression compoundStatementExpression() throws EndOfFileException, BacktrackException {
        int startingOffset = this.consume().getOffset();
        IASTCompoundStatement compoundStatement = null;
        if (this.mode == ParserMode.QUICK_PARSE || this.mode == ParserMode.STRUCTURAL_PARSE) {
            this.skipOverCompoundStatement();
        } else if (this.mode == ParserMode.COMPLETION_PARSE || this.mode == ParserMode.SELECTION_PARSE) {
            if (this.scanner.isOnTopContext()) {
                this.compoundStatement();
            } else {
                this.skipOverCompoundStatement();
            }
        } else if (this.mode == ParserMode.COMPLETE_PARSE) {
            compoundStatement = this.compoundStatement();
        }
        int lastOffset = this.consume(9).getEndOffset();
        IGNUASTCompoundStatementExpression resultExpression = this.createCompoundStatementExpression();
        ((ASTNode)((Object)resultExpression)).setOffsetAndLength(startingOffset, lastOffset - startingOffset);
        if (compoundStatement != null) {
            resultExpression.setCompoundStatement(compoundStatement);
        }
        return resultExpression;
    }

    protected abstract IGNUASTCompoundStatementExpression createCompoundStatementExpression();

    protected IASTExpression possiblyEmptyExpressionList(int endToken) throws BacktrackException, EndOfFileException {
        IToken la1 = this.LA(1);
        if (la1.getType() == endToken) {
            IASTExpressionList expressionList = this.createExpressionList();
            ((ASTNode)((Object)expressionList)).setOffsetAndLength(la1.getOffset(), 0);
            return expressionList;
        }
        return this.expression();
    }

    protected IASTExpression expression() throws BacktrackException, EndOfFileException {
        IToken la = this.LA(1);
        int startingOffset = la.getOffset();
        IASTExpression assignmentExpression = this.assignmentExpression();
        if (this.LT(1) != 6) {
            return assignmentExpression;
        }
        IASTExpressionList expressionList = this.createExpressionList();
        ((ASTNode)((Object)expressionList)).setOffset(startingOffset);
        expressionList.addExpression(assignmentExpression);
        int lastOffset = 0;
        while (this.LT(1) == 6) {
            this.consume();
            IASTExpression secondExpression = this.assignmentExpression();
            expressionList.addExpression(secondExpression);
            lastOffset = this.calculateEndOffset(secondExpression);
        }
        ((ASTNode)((Object)expressionList)).setLength(lastOffset - startingOffset);
        return expressionList;
    }

    protected abstract IASTExpressionList createExpressionList();

    protected abstract IASTExpression assignmentExpression() throws BacktrackException, EndOfFileException;

    protected IASTExpression relationalExpression() throws BacktrackException, EndOfFileException {
        IASTExpression result = this.shiftExpression();
        while (true) {
            int operator;
            switch (this.LT(1)) {
                case 46: {
                    if (this.onTopInTemplateArgs) {
                        return result;
                    }
                    operator = 9;
                    break;
                }
                case 42: {
                    operator = 8;
                    break;
                }
                case 41: {
                    operator = 10;
                    break;
                }
                case 45: {
                    operator = 11;
                    break;
                }
                case 152: {
                    operator = 32;
                    break;
                }
                case 153: {
                    operator = 33;
                    break;
                }
                default: {
                    return result;
                }
            }
            this.consume();
            IASTExpression rhs = this.shiftExpression();
            result = this.buildBinaryExpression(operator, result, rhs, this.calculateEndOffset(rhs));
        }
    }

    protected abstract IASTTypeId typeId(DeclarationOptions var1) throws EndOfFileException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IASTExpression castExpression() throws EndOfFileException, BacktrackException {
        IToken mark;
        block15: {
            if (this.LT(1) != 8) return this.unaryExpression();
            mark = this.mark();
            int startingOffset = mark.getOffset();
            this.consume();
            IASTTypeId typeId = this.typeId(DeclarationOptions.TYPEID);
            if (typeId != null && this.LT(1) == 9) {
                this.consume();
                boolean unaryFailed = false;
                if (this.inBinaryExpression) {
                    switch (this.LT(1)) {
                        case 16: 
                        case 21: 
                        case 23: 
                        case 30: {
                            IToken markEnd = this.mark();
                            this.backup(mark);
                            try {
                                IASTExpression unary = this.unaryExpression();
                                this.fTypeIdForCastAmbiguity = typeId;
                                return unary;
                            }
                            catch (BacktrackException backtrackException) {
                                this.backup(markEnd);
                                unaryFailed = true;
                            }
                        }
                    }
                }
                boolean couldBeFunctionCall = this.LT(1) == 8;
                IASTExpression rhs = this.castExpression();
                IASTCastExpression result = this.buildCastExpression(0, typeId, rhs, startingOffset, this.calculateEndOffset(rhs));
                if (unaryFailed || !couldBeFunctionCall || rhs instanceof IASTCastExpression) return result;
                IToken markEnd = this.mark();
                IASTTypeId typeidForCastAmbiguity = this.fTypeIdForCastAmbiguity;
                this.backup(mark);
                try {
                    IASTExpression expr = this.primaryExpression();
                    IASTFunctionCallExpression fcall = this.createFunctionCallExpression();
                    fcall.setFunctionNameExpression(expr);
                    IASTAmbiguousExpression ambiguity = this.createAmbiguousCastVsFunctionCallExpression(result, fcall);
                    ((ASTNode)((Object)ambiguity)).setOffsetAndLength((ASTNode)((Object)result));
                    IASTAmbiguousExpression iASTAmbiguousExpression = ambiguity;
                    this.backup(markEnd);
                    this.fTypeIdForCastAmbiguity = typeidForCastAmbiguity;
                    return iASTAmbiguousExpression;
                }
                catch (BacktrackException backtrackException) {
                    try {
                        try {
                            return result;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.backup(markEnd);
                            this.fTypeIdForCastAmbiguity = typeidForCastAmbiguity;
                        }
                    }
                    catch (BacktrackException b) {
                        if (!unaryFailed) break block15;
                        throw b;
                    }
                }
            }
        }
        this.backup(mark);
        return this.unaryExpression();
    }

    protected abstract IASTExpression unaryExpression() throws BacktrackException, EndOfFileException;

    protected abstract IASTExpression primaryExpression() throws BacktrackException, EndOfFileException;

    protected abstract IASTExpression buildTypeIdExpression(int var1, IASTTypeId var2, int var3, int var4);

    protected abstract IASTTranslationUnit getTranslationUnit();

    protected abstract void setupTranslationUnit() throws Exception;

    protected void translationUnit() {
        try {
            this.setupTranslationUnit();
        }
        catch (Exception e2) {
            this.logException("translationUnit::createCompilationUnit()", e2);
            return;
        }
        this.parseTranslationUnit();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseTranslationUnit() {
        tu = this.getTranslationUnit();
        offset = -1;
        block10: while (true) {
            block14: {
                while ((next = this.LAcatchEOF(1)) != null && next.getType() != 141) {
                    nextOffset = next.getOffset();
                    this.declarationMark = next;
                    next = null;
                    if (offset == nextOffset) {
                        tu.addDeclaration(this.skipProblemDeclaration(offset));
                        continue;
                    }
                    offset = nextOffset;
                    declaration = this.declaration(DeclarationOptions.GLOBAL);
                    tu.addDeclaration(declaration);
                }
                break block14;
                {
                    catch (BacktrackException bt) {
                        var8_12 = decls = this.problemDeclaration(offset, bt, DeclarationOptions.GLOBAL);
                        var7_11 = decls.length;
                        var6_10 = 0;
                        if (true) ** GOTO lbl47
                    }
                    catch (EndOfFileException v0) {
                        try {
                            tu.addDeclaration(this.skipProblemDeclaration(offset));
                            break block14;
                            catch (OutOfMemoryError oome) {
                                this.logThrowable("translationUnit", oome);
                                throw oome;
                            }
                            catch (Exception e) {
                                this.logException("translationUnit", e);
                                tu.addDeclaration(this.skipProblemDeclaration(offset));
                                continue block10;
                            }
                        }
                        catch (Throwable var9_13) {
                            throw var9_13;
                            break;
                        }
                    }
                }
                finally {
                    this.declarationMark = null;
                    continue;
                }
            }
            ((ASTNode)tu).setLength(this.eofOffset);
            return;
            do {
                declaration = var8_12[var6_10];
                tu.addDeclaration(declaration);
                ++var6_10;
lbl47:
                // 2 sources

            } while (var6_10 < var7_11);
        }
    }

    protected IASTExpression assignmentOperatorExpression(int kind, IASTExpression lhs) throws EndOfFileException, BacktrackException {
        this.consume();
        IASTExpression rhs = this.assignmentExpression();
        return this.buildBinaryExpression(kind, lhs, rhs, this.calculateEndOffset(rhs));
    }

    protected IASTExpression constantExpression() throws BacktrackException, EndOfFileException {
        return this.conditionalExpression();
    }

    protected IASTExpression logicalOrExpression() throws BacktrackException, EndOfFileException {
        IASTExpression firstExpression = this.logicalAndExpression();
        while (this.LT(1) == 32) {
            this.consume();
            IASTExpression secondExpression = this.logicalAndExpression();
            firstExpression = this.buildBinaryExpression(16, firstExpression, secondExpression, this.calculateEndOffset(secondExpression));
        }
        return firstExpression;
    }

    protected IASTExpression logicalAndExpression() throws BacktrackException, EndOfFileException {
        IASTExpression firstExpression = this.inclusiveOrExpression();
        while (this.LT(1) == 29) {
            this.consume();
            IASTExpression secondExpression = this.inclusiveOrExpression();
            firstExpression = this.buildBinaryExpression(15, firstExpression, secondExpression, this.calculateEndOffset(secondExpression));
        }
        return firstExpression;
    }

    protected IASTExpression inclusiveOrExpression() throws BacktrackException, EndOfFileException {
        IASTExpression firstExpression = this.exclusiveOrExpression();
        while (this.LT(1) == 33) {
            this.consume();
            IASTExpression secondExpression = this.exclusiveOrExpression();
            firstExpression = this.buildBinaryExpression(14, firstExpression, secondExpression, this.calculateEndOffset(secondExpression));
        }
        return firstExpression;
    }

    protected IASTExpression exclusiveOrExpression() throws BacktrackException, EndOfFileException {
        IASTExpression firstExpression = this.andExpression();
        while (this.LT(1) == 27) {
            this.consume();
            IASTExpression secondExpression = this.andExpression();
            firstExpression = this.buildBinaryExpression(13, firstExpression, secondExpression, this.calculateEndOffset(secondExpression));
        }
        return firstExpression;
    }

    protected IASTExpression andExpression() throws EndOfFileException, BacktrackException {
        IASTExpression firstExpression = this.equalityExpression();
        while (this.LT(1) == 30) {
            int offset = this.consume().getOffset();
            IASTTypeId typeid = this.fTypeIdForCastAmbiguity;
            this.fTypeIdForCastAmbiguity = null;
            IASTExpression secondExpression = this.equalityExpression();
            firstExpression = this.buildBinaryExpression(12, firstExpression, secondExpression, this.calculateEndOffset(secondExpression));
            if (typeid == null) continue;
            firstExpression = this.createCastVsBinaryExpressionAmbiguity((IASTBinaryExpression)firstExpression, typeid, 5, offset);
        }
        return firstExpression;
    }

    protected IASTExpression equalityExpression() throws EndOfFileException, BacktrackException {
        IASTExpression firstExpression = this.relationalExpression();
        block3: while (true) {
            switch (this.LT(1)) {
                case 35: 
                case 37: {
                    IToken t = this.consume();
                    int operator = t.getType() == 37 ? 28 : 29;
                    IASTExpression secondExpression = this.relationalExpression();
                    firstExpression = this.buildBinaryExpression(operator, firstExpression, secondExpression, this.calculateEndOffset(secondExpression));
                    continue block3;
                }
            }
            break;
        }
        return firstExpression;
    }

    protected IASTExpression buildBinaryExpression(int operator, IASTExpression firstExpression, IASTExpression secondExpression, int lastOffset) {
        IASTBinaryExpression result = this.createBinaryExpression();
        result.setOperator(operator);
        int o = ((ASTNode)((Object)firstExpression)).getOffset();
        ((ASTNode)((Object)result)).setOffsetAndLength(o, lastOffset - o);
        result.setOperand1(firstExpression);
        result.setOperand2(secondExpression);
        return result;
    }

    protected abstract IASTBinaryExpression createBinaryExpression();

    protected abstract IASTFunctionCallExpression createFunctionCallExpression();

    protected IASTExpression shiftExpression() throws BacktrackException, EndOfFileException {
        IASTExpression firstExpression = this.additiveExpression();
        block3: while (true) {
            switch (this.LT(1)) {
                case 40: 
                case 44: {
                    IToken t = this.consume();
                    int operator = t.getType() == 40 ? 6 : 7;
                    IASTExpression secondExpression = this.additiveExpression();
                    firstExpression = this.buildBinaryExpression(operator, firstExpression, secondExpression, this.calculateEndOffset(secondExpression));
                    continue block3;
                }
            }
            break;
        }
        return firstExpression;
    }

    protected IASTExpression additiveExpression() throws BacktrackException, EndOfFileException {
        IASTExpression result = this.multiplicativeExpression();
        while (true) {
            int unaryOperator;
            int operator;
            switch (this.LT(1)) {
                case 16: {
                    operator = 4;
                    unaryOperator = 2;
                    break;
                }
                case 21: {
                    operator = 5;
                    unaryOperator = 3;
                    break;
                }
                default: {
                    return result;
                }
            }
            int offset = this.consume().getOffset();
            IASTTypeId typeid = this.fTypeIdForCastAmbiguity;
            this.fTypeIdForCastAmbiguity = null;
            IASTExpression secondExpression = this.multiplicativeExpression();
            result = this.buildBinaryExpression(operator, result, secondExpression, this.calculateEndOffset(secondExpression));
            if (typeid == null) continue;
            result = this.createCastVsBinaryExpressionAmbiguity((IASTBinaryExpression)result, typeid, unaryOperator, offset);
        }
    }

    protected IASTExpression multiplicativeExpression() throws BacktrackException, EndOfFileException {
        this.inBinaryExpression = true;
        this.fTypeIdForCastAmbiguity = null;
        IASTExpression result = this.pmExpression();
        while (true) {
            int operator;
            switch (this.LT(1)) {
                case 23: {
                    operator = 1;
                    break;
                }
                case 52: {
                    operator = 2;
                    break;
                }
                case 25: {
                    operator = 3;
                    break;
                }
                default: {
                    return result;
                }
            }
            int offset = this.consume().getOffset();
            IASTTypeId typeid = this.fTypeIdForCastAmbiguity;
            this.fTypeIdForCastAmbiguity = null;
            IASTExpression secondExpression = this.pmExpression();
            result = this.buildBinaryExpression(operator, result, secondExpression, this.calculateEndOffset(secondExpression));
            if (typeid == null) continue;
            result = this.createCastVsBinaryExpressionAmbiguity((IASTBinaryExpression)result, typeid, 4, offset);
        }
    }

    protected abstract IASTExpression pmExpression() throws EndOfFileException, BacktrackException;

    private IASTExpression createCastVsBinaryExpressionAmbiguity(IASTBinaryExpression expr, IASTTypeId typeid, int unaryOperator, int unaryOpOffset) {
        IASTUnaryExpression unary = this.createUnaryExpression();
        unary.setOperator(unaryOperator);
        ((ASTNode)((Object)unary)).setOffset(unaryOpOffset);
        IASTCastExpression castExpr = this.buildCastExpression(0, typeid, unary, 0, 0);
        IASTAmbiguousExpression result = this.createAmbiguousBinaryVsCastExpression(expr, castExpr);
        ((ASTNode)((Object)result)).setOffsetAndLength((ASTNode)((Object)expr));
        return result;
    }

    protected IASTExpression conditionalExpression() throws BacktrackException, EndOfFileException {
        IASTExpression firstExpression = this.logicalOrExpression();
        if (this.LT(1) == 7) {
            this.consume();
            IASTExpression secondExpression = null;
            if (this.LT(1) != 4) {
                secondExpression = this.expression();
            }
            IASTExpression thirdExpression = null;
            if (this.LT(1) != 141) {
                this.consume(4);
                thirdExpression = this.assignmentExpression();
            }
            IASTConditionalExpression result = this.createConditionalExpression();
            result.setLogicalConditionExpression(firstExpression);
            result.setPositiveResultExpression(secondExpression);
            if (thirdExpression != null) {
                result.setNegativeResultExpression(thirdExpression);
                ((ASTNode)((Object)result)).setOffsetAndLength(((ASTNode)((Object)firstExpression)).getOffset(), this.calculateEndOffset(thirdExpression) - ((ASTNode)((Object)firstExpression)).getOffset());
            }
            return result;
        }
        return firstExpression;
    }

    protected abstract IASTConditionalExpression createConditionalExpression();

    protected IASTExpression buildUnaryExpression(int operator, IASTExpression operand, int offset, int lastOffset) {
        IASTUnaryExpression result = this.createUnaryExpression();
        ((ASTNode)((Object)result)).setOffsetAndLength(offset, lastOffset - offset);
        result.setOperator(operator);
        result.setOperand(operand);
        return result;
    }

    protected abstract IASTUnaryExpression createUnaryExpression();

    protected IASTStatement handleFunctionBody() throws BacktrackException, EndOfFileException {
        this.declarationMark = null;
        if (this.mode == ParserMode.QUICK_PARSE || this.mode == ParserMode.STRUCTURAL_PARSE) {
            IToken curr = this.LA(1);
            IToken last = this.skipOverCompoundStatement();
            IASTCompoundStatement cs = this.createCompoundStatement();
            ((ASTNode)((Object)cs)).setOffsetAndLength(curr.getOffset(), last.getEndOffset() - curr.getOffset());
            return cs;
        }
        if (this.mode == ParserMode.COMPLETION_PARSE || this.mode == ParserMode.SELECTION_PARSE) {
            if (this.scanner.isOnTopContext()) {
                return this.functionBody();
            }
            IToken curr = this.LA(1);
            IToken last = this.skipOverCompoundStatement();
            IASTCompoundStatement cs = this.createCompoundStatement();
            ((ASTNode)((Object)cs)).setOffsetAndLength(curr.getOffset(), last.getEndOffset() - curr.getOffset());
            return cs;
        }
        return this.functionBody();
    }

    protected IASTStatement functionBody() throws EndOfFileException, BacktrackException {
        return this.compoundStatement();
    }

    protected abstract IASTDeclarator initDeclarator(DeclarationOptions var1) throws EndOfFileException, BacktrackException;

    protected void lookAheadForDeclarator(DeclarationOptions option) throws FoundDeclaratorException {
        IToken mark = null;
        try {
            mark = this.mark();
            IASTDeclarator dtor = this.initDeclarator(option);
            IToken la = this.LA(1);
            if (la == null || la == mark) {
                return;
            }
            try {
                if (this.verifyLookaheadDeclarator(option, dtor, la)) {
                    throw new FoundDeclaratorException(dtor, la);
                }
            }
            catch (BacktrackException backtrackException) {
            }
            catch (EndOfFileException endOfFileException) {}
        }
        finally {
            if (mark != null) {
                this.backup(mark);
            }
        }
    }

    protected abstract boolean verifyLookaheadDeclarator(DeclarationOptions var1, IASTDeclarator var2, IToken var3);

    protected IASTEnumerationSpecifier enumSpecifier() throws BacktrackException, EndOfFileException {
        int endOffset;
        IASTEnumerationSpecifier result;
        int offset;
        block15: {
            IToken mark = this.mark();
            offset = this.consume().getOffset();
            this.__attribute_decl_seq(this.supportAttributeSpecifiers, this.supportDeclspecSpecifiers);
            IASTName name = this.LT(1) == 1 ? this.createName(this.identifier()) : this.createName();
            if (this.LT(1) != 12) {
                this.backup(mark);
                this.throwBacktrack(mark);
            }
            result = this.createEnumerationSpecifier();
            result.setName(name);
            boolean needComma = false;
            int problemOffset = endOffset = this.consume().getEndOffset();
            try {
                block10: while (true) {
                    switch (this.LTcatchEOF(1)) {
                        case 0: {
                            endOffset = this.eofOffset;
                            break block15;
                        }
                        case 13: {
                            endOffset = this.consume().getEndOffset();
                            break block15;
                        }
                        case 141: {
                            break block15;
                        }
                        case 6: {
                            if (!needComma) {
                                problemOffset = this.LA(1).getOffset();
                                throw this.backtrack;
                            }
                            endOffset = this.consume().getEndOffset();
                            needComma = false;
                            continue block10;
                        }
                        case 1: 
                        case 140: {
                            problemOffset = this.LA(1).getOffset();
                            if (needComma) {
                                throw this.backtrack;
                            }
                            IASTEnumerationSpecifier.IASTEnumerator enumerator = this.createEnumerator();
                            IASTName etorName = this.createName(this.identifier());
                            enumerator.setName(etorName);
                            endOffset = this.calculateEndOffset(etorName);
                            this.setRange(enumerator, problemOffset, endOffset);
                            result.addEnumerator(enumerator);
                            if (this.LTcatchEOF(1) == 38) {
                                problemOffset = this.consume().getOffset();
                                IASTExpression value = this.constantExpression();
                                enumerator.setValue(value);
                                this.adjustLength(enumerator, value);
                                endOffset = this.calculateEndOffset(value);
                            }
                            needComma = true;
                            continue block10;
                        }
                        default: {
                            problemOffset = this.LA(1).getOffset();
                            throw this.backtrack;
                        }
                    }
                    break;
                }
            }
            catch (EndOfFileException endOfFileException) {
                this.throwBacktrack(this.createProblem(0x4000001, problemOffset, this.eofOffset - problemOffset), result);
            }
            catch (BacktrackException backtrackException) {
                IASTProblem problem = this.skipProblemEnumerator(problemOffset);
                this.throwBacktrack(problem, result);
            }
        }
        this.setRange(result, offset, endOffset);
        return result;
    }

    protected abstract IASTStatement statement() throws EndOfFileException, BacktrackException;

    protected abstract IASTEnumerationSpecifier.IASTEnumerator createEnumerator();

    protected abstract IASTEnumerationSpecifier createEnumerationSpecifier();

    protected abstract IASTName createName();

    protected abstract IASTName createName(IToken var1);

    protected IASTExpression condition(boolean followedByParenthesis) throws BacktrackException, EndOfFileException {
        IToken mark;
        block6: {
            mark = this.mark();
            try {
                IASTExpression expr = this.expression();
                if (!followedByParenthesis) {
                    return expr;
                }
                switch (this.LT(1)) {
                    case 9: 
                    case 141: {
                        return expr;
                    }
                }
            }
            catch (BacktrackException b) {
                if (followedByParenthesis) break block6;
                throw b;
            }
        }
        this.backup(mark);
        return this.skipProblemConditionInParenthesis(mark.getOffset());
    }

    public boolean encounteredError() {
        return !this.parsePassed;
    }

    protected abstract IASTSimpleDeclaration createSimpleDeclaration();

    protected abstract IASTNamedTypeSpecifier createNamedTypeSpecifier();

    protected abstract IASTDeclarationStatement createDeclarationStatement();

    protected abstract IASTExpressionStatement createExpressionStatement();

    protected abstract IASTFunctionDefinition createFunctionDefinition();

    protected abstract IASTLabelStatement createLabelStatement();

    protected abstract IASTNullStatement createNullStatement();

    protected abstract IASTGotoStatement createGoToStatement();

    protected abstract IASTReturnStatement createReturnStatement();

    protected abstract IASTContinueStatement createContinueStatement();

    protected abstract IASTBreakStatement createBreakStatement();

    protected abstract IASTDoStatement createDoStatement();

    protected abstract IASTWhileStatement createWhileStatement();

    protected abstract IASTIdExpression createIdExpression();

    protected abstract IASTDefaultStatement createDefaultStatement();

    protected abstract IASTCaseStatement createCaseStatement();

    protected abstract IASTDeclaration declaration(DeclarationOptions var1) throws BacktrackException, EndOfFileException;

    protected abstract IASTDeclSpecifier declSpecifierSeq(DeclarationOptions var1) throws BacktrackException, EndOfFileException, FoundDeclaratorException;

    protected IASTDeclaration[] problemDeclaration(int offset, BacktrackException bt, DeclarationOptions option) {
        this.failParse();
        IASTProblem origProblem = this.createProblem(bt);
        IASTNode n = bt.getNodeBeforeProblem();
        if (n instanceof IASTDeclaration) {
            this.declarationMark = null;
            return new IASTDeclaration[]{(IASTDeclaration)n, this.createProblemDeclaration(origProblem)};
        }
        if (this.declarationMark != null) {
            IASTProblemDeclaration trailingProblem = null;
            offset = this.declarationMark.getOffset();
            IASTDeclaration decl = null;
            int endOffset = 0;
            block6: while (this.declarationMark != null && this.declarationMark.getType() == 1) {
                endOffset = this.declarationMark.getEndOffset();
                this.declarationMark = this.declarationMark.getNext();
                if (this.declarationMark == null) continue;
                this.backup(this.declarationMark);
                switch (this.LTcatchEOF(1)) {
                    case 0: 
                    case 5: 
                    case 141: {
                        break block6;
                    }
                    default: {
                        try {
                            decl = this.declaration(option);
                        }
                        catch (BacktrackException backtrackException) {
                            n = bt.getNodeBeforeProblem();
                            if (!(n instanceof IASTDeclaration)) continue block6;
                            decl = (IASTDeclaration)n;
                            trailingProblem = this.createProblemDeclaration(bt.getProblem());
                        }
                        catch (EndOfFileException endOfFileException) {
                            endOffset = this.eofOffset;
                        }
                        break block6;
                    }
                }
            }
            this.declarationMark = null;
            if (decl != null) {
                IASTProblem problem = this.createProblem(0x4000001, offset, endOffset - offset);
                IASTProblemDeclaration pd = this.createProblemDeclaration(problem);
                if (trailingProblem != null) {
                    return new IASTDeclaration[]{pd, decl, trailingProblem};
                }
                return new IASTDeclaration[]{pd, decl};
            }
        }
        return new IASTDeclaration[]{this.skipProblemDeclaration(offset)};
    }

    protected IASTDeclaration asmDeclaration() throws EndOfFileException, BacktrackException {
        int offset = this.consume().getOffset();
        if (this.LT(1) == 124) {
            this.consume();
        }
        if (this.supportFunctionStyleAsm && this.LT(1) != 8) {
            return this.functionStyleAsmDeclaration();
        }
        StringBuilder buffer = new StringBuilder();
        this.asmExpression(buffer);
        int lastOffset = this.consume(5).getEndOffset();
        return this.buildASMDirective(offset, buffer.toString(), lastOffset);
    }

    protected IASTDeclaration functionStyleAsmDeclaration() throws BacktrackException, EndOfFileException {
        IASTDeclarator dtor;
        IASTDeclSpecifier declSpec;
        int offset = this.LA(1).getOffset();
        try {
            declSpec = this.declSpecifierSeq(DeclarationOptions.FUNCTION_STYLE_ASM);
            dtor = this.initDeclarator(DeclarationOptions.FUNCTION_STYLE_ASM);
        }
        catch (FoundDeclaratorException e) {
            if (e.altSpec != null) {
                declSpec = e.altSpec;
                dtor = e.altDeclarator;
            } else {
                declSpec = e.declSpec;
                dtor = e.declarator;
            }
            this.backup(e.currToken);
        }
        if (this.LT(1) != 12) {
            this.throwBacktrack(this.LA(1));
        }
        IASTDeclarator fdtor = CVisitor.findTypeRelevantDeclarator(dtor);
        if (!(dtor instanceof IASTFunctionDeclarator)) {
            this.throwBacktrack(offset, this.LA(1).getEndOffset() - offset);
        }
        IASTFunctionDefinition funcDefinition = this.createFunctionDefinition();
        funcDefinition.setDeclSpecifier(declSpec);
        funcDefinition.setDeclarator((IASTFunctionDeclarator)fdtor);
        int compoundOffset = this.LA(1).getOffset();
        int endOffset = this.skipOverCompoundStatement().getEndOffset();
        IASTCompoundStatement cs = this.createCompoundStatement();
        ((ASTNode)((Object)cs)).setOffsetAndLength(compoundOffset, endOffset - compoundOffset);
        funcDefinition.setBody(cs);
        ((ASTNode)((Object)funcDefinition)).setOffsetAndLength(offset, endOffset - offset);
        return funcDefinition;
    }

    protected IToken asmExpression(StringBuilder content) throws EndOfFileException, BacktrackException {
        IToken t = this.consume(8);
        boolean needspace = false;
        int open = 1;
        block5: while (open > 0) {
            t = this.consume();
            switch (t.getType()) {
                case 8: {
                    ++open;
                    break;
                }
                case 9: {
                    --open;
                    break;
                }
                case 141: {
                    throw new EndOfFileException();
                }
                default: {
                    if (content == null) continue block5;
                    if (needspace) {
                        content.append(' ');
                    }
                    content.append(t.getCharImage());
                    needspace = true;
                }
            }
        }
        return t;
    }

    protected IASTASMDeclaration buildASMDirective(int offset, String assembly, int lastOffset) {
        IASTASMDeclaration result = this.createASMDirective();
        ((ASTNode)((Object)result)).setOffsetAndLength(offset, lastOffset - offset);
        result.setAssembly(assembly);
        return result;
    }

    protected abstract IASTASMDeclaration createASMDirective();

    protected IASTCastExpression buildCastExpression(int op, IASTTypeId typeId, IASTExpression operand, int offset, int endOffset) {
        IASTCastExpression result = this.createCastExpression();
        result.setOperator(op);
        ((ASTNode)((Object)result)).setOffsetAndLength(offset, endOffset - offset);
        result.setTypeId(typeId);
        if (operand != null) {
            result.setOperand(operand);
        }
        return result;
    }

    protected abstract IASTCastExpression createCastExpression();

    protected IASTStatement parseDeclarationOrExpressionStatement(DeclarationOptions option) throws EndOfFileException, BacktrackException {
        IASTSimpleDeclaration simpleDecl;
        IASTDeclSpecifier declspec;
        IASTDeclaration declaration;
        IASTBinaryExpression exp;
        IASTDeclarationStatement ds;
        IToken lastTokenOfExpression;
        IASTExpressionStatement expressionStatement;
        block14: {
            IToken mark = this.mark();
            expressionStatement = null;
            lastTokenOfExpression = null;
            try {
                IASTExpression expression = this.expression();
                lastTokenOfExpression = this.LT(1) == 141 ? this.consume() : this.consume(5);
                expressionStatement = this.createExpressionStatement();
                expressionStatement.setExpression(expression);
                ((ASTNode)((Object)expressionStatement)).setOffsetAndLength(mark.getOffset(), lastTokenOfExpression.getEndOffset() - mark.getOffset());
            }
            catch (BacktrackException backtrackException) {}
            this.backup(mark);
            ds = null;
            try {
                IASTDeclaration d = this.declaration(option);
                ds = this.createDeclarationStatement();
                ds.setDeclaration(d);
                ((ASTNode)((Object)ds)).setOffsetAndLength(((ASTNode)((Object)d)).getOffset(), ((ASTNode)((Object)d)).getLength());
            }
            catch (BacktrackException b) {
                this.backup(mark);
                if (expressionStatement != null) break block14;
                throw b;
            }
        }
        if (expressionStatement == null) {
            return ds;
        }
        if (ds == null) {
            this.backup(lastTokenOfExpression);
            this.consume();
            return expressionStatement;
        }
        if (expressionStatement.getExpression() instanceof IASTBinaryExpression && (exp = (IASTBinaryExpression)expressionStatement.getExpression()).getOperator() == 17) {
            IASTExpression lhs = exp.getOperand1();
            if (lhs instanceof IASTBinaryExpression && ((IASTBinaryExpression)lhs).getOperator() == 1) {
                return ds;
            }
            if (lhs instanceof IASTFunctionCallExpression) {
                return ds;
            }
        }
        if ((declaration = ds.getDeclaration()) instanceof IASTSimpleDeclaration && (declspec = (simpleDecl = (IASTSimpleDeclaration)declaration).getDeclSpecifier()) instanceof IASTNamedTypeSpecifier) {
            IASTDeclarator[] declarators = simpleDecl.getDeclarators();
            if (declarators.length == 0) {
                this.backup(lastTokenOfExpression);
                this.consume();
                return expressionStatement;
            }
            if (declarators.length == 1) {
                IASTName name = ((IASTNamedTypeSpecifier)declspec).getName();
                IASTDeclarator dtor = declarators[0];
                if (!(!name.contains(declspec) || dtor.getNestedDeclarator() == null || dtor instanceof IASTAmbiguousDeclarator || dtor instanceof IASTArrayDeclarator || dtor instanceof IASTFieldDeclarator || dtor instanceof IASTFunctionDeclarator)) {
                    this.backup(lastTokenOfExpression);
                    this.consume();
                    return expressionStatement;
                }
                if (dtor.getName().toCharArray().length == 0 && dtor.getNestedDeclarator() == null) {
                    throw new Error();
                }
            }
        }
        IASTAmbiguousStatement statement = this.createAmbiguousStatement();
        statement.addStatement(expressionStatement);
        statement.addStatement(ds);
        ((ASTNode)((Object)statement)).setOffsetAndLength((ASTNode)((Object)ds));
        return statement;
    }

    protected static boolean isImplicitInt(IASTDeclaration declaration) {
        IASTDeclSpecifier declSpec;
        return declaration instanceof IASTSimpleDeclaration && (declSpec = ((IASTSimpleDeclaration)declaration).getDeclSpecifier()) instanceof IASTSimpleDeclSpecifier && ((IASTSimpleDeclSpecifier)declSpec).getType() == 0;
    }

    protected abstract IASTAmbiguousStatement createAmbiguousStatement();

    protected IASTStatement parseLabelStatement() throws EndOfFileException, BacktrackException {
        IToken labelName = this.consume();
        this.consume();
        IASTStatement nestedStatement = this.statement();
        int lastOffset = this.calculateEndOffset(nestedStatement);
        IASTLabelStatement label_statement = this.createLabelStatement();
        ((ASTNode)((Object)label_statement)).setOffsetAndLength(labelName.getOffset(), lastOffset - labelName.getOffset());
        IASTName name = this.createName(labelName);
        label_statement.setName(name);
        label_statement.setNestedStatement(nestedStatement);
        return label_statement;
    }

    protected IASTStatement parseNullStatement() throws EndOfFileException, BacktrackException {
        IToken t = this.consume();
        IASTNullStatement null_statement = this.createNullStatement();
        ((ASTNode)((Object)null_statement)).setOffsetAndLength(t.getOffset(), t.getEndOffset() - t.getOffset());
        return null_statement;
    }

    protected IASTStatement parseGotoStatement() throws EndOfFileException, BacktrackException {
        int startOffset = this.consume().getOffset();
        IToken identifier = this.consume(1);
        int lastOffset = this.consume(5).getEndOffset();
        IASTName goto_label_name = this.createName(identifier);
        IASTGotoStatement goto_statement = this.createGoToStatement();
        ((ASTNode)((Object)goto_statement)).setOffsetAndLength(startOffset, lastOffset - startOffset);
        goto_statement.setName(goto_label_name);
        return goto_statement;
    }

    protected IASTStatement parseBreakStatement() throws EndOfFileException, BacktrackException {
        int startOffset = this.consume().getOffset();
        int lastOffset = this.consume(5).getEndOffset();
        IASTBreakStatement break_statement = this.createBreakStatement();
        ((ASTNode)((Object)break_statement)).setOffsetAndLength(startOffset, lastOffset - startOffset);
        return break_statement;
    }

    protected IASTStatement parseSwitchBody() throws EndOfFileException, BacktrackException {
        IASTStatement stmt = null;
        if (this.LT(1) != 141) {
            stmt = this.statement();
        }
        if (!(stmt instanceof IASTCaseStatement)) {
            return stmt;
        }
        IASTCompoundStatement comp = this.createCompoundStatement();
        ((ASTNode)((Object)comp)).setOffsetAndLength((ASTNode)((Object)stmt));
        comp.addStatement(stmt);
        while (this.LT(1) != 141 && stmt instanceof IASTCaseStatement) {
            stmt = this.statement();
            comp.addStatement(stmt);
        }
        this.adjustLength(comp, stmt);
        return comp;
    }

    protected IASTStatement parseContinueStatement() throws EndOfFileException, BacktrackException {
        int startOffset = this.consume().getOffset();
        int lastOffset = this.consume(5).getEndOffset();
        IASTContinueStatement continue_statement = this.createContinueStatement();
        ((ASTNode)((Object)continue_statement)).setOffsetAndLength(startOffset, lastOffset - startOffset);
        return continue_statement;
    }

    protected IASTStatement parseReturnStatement() throws EndOfFileException, BacktrackException {
        int startOffset = this.consume().getOffset();
        IASTExpression result = null;
        switch (this.LT(1)) {
            case 141: {
                IASTName name = this.createName(this.LA(1));
                IASTIdExpression idExpr = this.createIdExpression();
                idExpr.setName(name);
                result = idExpr;
                break;
            }
            case 5: {
                break;
            }
            default: {
                result = this.expression();
            }
        }
        int lastOffset = 0;
        switch (this.LT(1)) {
            case 5: 
            case 141: {
                lastOffset = this.consume().getEndOffset();
                break;
            }
            default: {
                this.throwBacktrack(this.LA(1));
            }
        }
        IASTReturnStatement return_statement = this.createReturnStatement();
        ((ASTNode)((Object)return_statement)).setOffsetAndLength(startOffset, lastOffset - startOffset);
        if (result != null) {
            return_statement.setReturnValue(result);
        }
        return return_statement;
    }

    protected IASTStatement parseDoStatement() throws EndOfFileException, BacktrackException {
        int lastOffset;
        int startOffset = this.consume().getOffset();
        IASTStatement do_body = this.statement();
        IASTExpression do_condition = null;
        if (this.LT(1) != 141) {
            this.consume(126);
            this.consume(8);
            do_condition = this.condition(true);
        }
        switch (this.LT(1)) {
            case 9: 
            case 141: {
                this.consume();
                break;
            }
            default: {
                throw this.backtrack;
            }
        }
        switch (this.LT(1)) {
            case 5: 
            case 141: {
                lastOffset = this.consume().getEndOffset();
                break;
            }
            default: {
                throw this.backtrack;
            }
        }
        IASTDoStatement do_statement = this.createDoStatement();
        ((ASTNode)((Object)do_statement)).setOffsetAndLength(startOffset, lastOffset - startOffset);
        do_statement.setBody(do_body);
        if (do_condition != null) {
            do_statement.setCondition(do_condition);
        }
        return do_statement;
    }

    protected IASTStatement parseWhileStatement() throws EndOfFileException, BacktrackException {
        int startOffset = this.consume().getOffset();
        this.consume(8);
        IASTExpression while_condition = this.condition(true);
        switch (this.LT(1)) {
            case 9: {
                this.consume();
                break;
            }
            case 141: {
                break;
            }
            default: {
                this.throwBacktrack(this.LA(1));
            }
        }
        IASTStatement while_body = null;
        if (this.LT(1) != 141) {
            while_body = this.statement();
        }
        IASTWhileStatement while_statement = this.createWhileStatement();
        ((ASTNode)((Object)while_statement)).setOffsetAndLength(startOffset, (while_body != null ? this.calculateEndOffset(while_body) : this.LA(1).getEndOffset()) - startOffset);
        while_statement.setCondition(while_condition);
        while_statement.setBody(while_body);
        return while_statement;
    }

    protected void reconcileLengths(IASTIfStatement result) {
        if (result == null) {
            return;
        }
        IASTIfStatement current = result;
        while (current.getElseClause() instanceof IASTIfStatement) {
            current = (IASTIfStatement)current.getElseClause();
        }
        while (current != null) {
            ASTNode r = (ASTNode)((Object)current);
            if (current.getElseClause() != null) {
                ASTNode else_clause = (ASTNode)((Object)current.getElseClause());
                r.setLength(else_clause.getOffset() + else_clause.getLength() - r.getOffset());
            } else {
                ASTNode then_clause = (ASTNode)((Object)current.getThenClause());
                if (then_clause != null) {
                    r.setLength(then_clause.getOffset() + then_clause.getLength() - r.getOffset());
                }
            }
            current = current.getParent() != null && current.getParent() instanceof IASTIfStatement ? (IASTIfStatement)current.getParent() : null;
        }
    }

    protected abstract IASTProblemExpression createProblemExpression();

    protected IASTStatement parseCompoundStatement() throws EndOfFileException, BacktrackException {
        IASTCompoundStatement compound = this.compoundStatement();
        return compound;
    }

    protected IASTStatement parseDefaultStatement() throws EndOfFileException, BacktrackException {
        int startOffset = this.consume().getOffset();
        int lastOffset = this.consume(4).getEndOffset();
        IASTDefaultStatement df = this.createDefaultStatement();
        ((ASTNode)((Object)df)).setOffsetAndLength(startOffset, lastOffset - startOffset);
        return df;
    }

    protected IASTStatement parseCaseStatement() throws EndOfFileException, BacktrackException {
        int startOffset = this.consume().getOffset();
        IASTExpression caseExpression = this.constantExpression();
        int lt1 = this.LT(1);
        if (lt1 == 48) {
            this.consume();
            IASTExpression upperBoundExpression = this.constantExpression();
            caseExpression = this.buildBinaryExpression(17, caseExpression, upperBoundExpression, this.calculateEndOffset(upperBoundExpression));
            lt1 = this.LT(1);
        }
        int lastOffset = 0;
        switch (lt1) {
            case 4: 
            case 141: {
                lastOffset = this.consume().getEndOffset();
                break;
            }
            default: {
                this.throwBacktrack(this.LA(1));
            }
        }
        IASTCaseStatement cs = this.createCaseStatement();
        ((ASTNode)((Object)cs)).setOffsetAndLength(startOffset, lastOffset - startOffset);
        cs.setExpression(caseExpression);
        return cs;
    }

    protected int figureEndOffset(IASTDeclSpecifier declSpec, IASTDeclarator[] declarators) {
        if (declarators.length == 0) {
            return this.calculateEndOffset(declSpec);
        }
        return this.calculateEndOffset(declarators[declarators.length - 1]);
    }

    protected int figureEndOffset(IASTDeclSpecifier declSpecifier, IASTDeclarator declarator) {
        if (declarator == null || ((ASTNode)((Object)declarator)).getLength() == 0) {
            return this.calculateEndOffset(declSpecifier);
        }
        return this.calculateEndOffset(declarator);
    }

    protected void throwBacktrack(IToken token) throws BacktrackException {
        this.throwBacktrack(token.getOffset(), token.getLength());
    }

    protected IASTExpression parseTypeidInParenthesisOrUnaryExpression(boolean exprIsLimitedToParenthesis, int offset, int typeExprKind, int unaryExprKind) throws BacktrackException, EndOfFileException {
        IASTTypeId typeid;
        int endOffset2;
        int endOffset1;
        IToken typeidLA;
        IASTExpression expr;
        block18: {
            expr = null;
            typeidLA = null;
            IToken mark = this.mark();
            endOffset1 = -1;
            endOffset2 = -1;
            try {
                this.consume(8);
                int typeidOffset = this.LA(1).getOffset();
                typeid = this.typeId(DeclarationOptions.TYPEID);
                if (typeid != null) {
                    switch (this.LT(1)) {
                        case 9: 
                        case 141: {
                            endOffset1 = this.consume().getEndOffset();
                            typeidLA = this.LA(1);
                            break;
                        }
                        case 6: {
                            if (this.supportExtendedSizeofOperator && typeExprKind == 0) {
                                this.consume();
                                IASTExpression expr2 = this.expression();
                                endOffset1 = this.consumeOrEOC(9).getEndOffset();
                                expr = this.buildTypeIdExpression(3, typeid, typeidOffset, this.calculateEndOffset(typeid));
                                IASTExpressionList expressionList = this.createExpressionList();
                                ((ASTNode)((Object)expressionList)).setOffsetAndLength(typeidOffset, this.calculateEndOffset(expr2) - typeidOffset);
                                expressionList.addExpression(expr);
                                if (expr2 instanceof IASTExpressionList) {
                                    IASTExpression[] iASTExpressionArray = ((IASTExpressionList)expr2).getExpressions();
                                    int n = iASTExpressionArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IASTExpression e = iASTExpressionArray[n2];
                                        expressionList.addExpression(e);
                                        ++n2;
                                    }
                                } else {
                                    expressionList.addExpression(expr2);
                                }
                                return this.buildUnaryExpression(unaryExprKind, expressionList, offset, endOffset1);
                            }
                            typeid = null;
                            break;
                        }
                        default: {
                            typeid = null;
                            break;
                        }
                    }
                }
            }
            catch (BacktrackException backtrackException) {
                typeid = null;
            }
            this.backup(mark);
            try {
                if (exprIsLimitedToParenthesis) {
                    this.consume(8);
                    expr = this.expression();
                    endOffset2 = this.consumeOrEOC(9).getEndOffset();
                } else {
                    expr = this.unaryExpression();
                    endOffset2 = this.calculateEndOffset(expr);
                }
            }
            catch (BacktrackException bte) {
                if (typeid != null) break block18;
                throw bte;
            }
        }
        IASTExpression result1 = null;
        if (typeid != null && endOffset1 >= endOffset2) {
            result1 = this.buildTypeIdExpression(typeExprKind, typeid, offset, endOffset1);
            this.backup(typeidLA);
            if (expr == null || endOffset1 > endOffset2) {
                return result1;
            }
        }
        IASTExpression result2 = this.buildUnaryExpression(unaryExprKind, expr, offset, endOffset2);
        if (result1 == null) {
            return result2;
        }
        IASTAmbiguousExpression ambExpr = this.createAmbiguousExpression();
        ambExpr.addExpression(result1);
        ambExpr.addExpression(result2);
        ((ASTNode)((Object)ambExpr)).setOffsetAndLength((ASTNode)((Object)result1));
        return ambExpr;
    }

    protected abstract IASTAmbiguousExpression createAmbiguousExpression();

    protected abstract IASTAmbiguousExpression createAmbiguousBinaryVsCastExpression(IASTBinaryExpression var1, IASTCastExpression var2);

    protected abstract IASTAmbiguousExpression createAmbiguousCastVsFunctionCallExpression(IASTCastExpression var1, IASTFunctionCallExpression var2);

    protected IASTStatement forInitStatement(DeclarationOptions option) throws BacktrackException, EndOfFileException {
        if (this.LT(1) == 5) {
            return this.parseNullStatement();
        }
        return this.parseDeclarationOrExpressionStatement(option);
    }

    protected void __attribute_decl_seq(boolean allowAttrib, boolean allowDeclspec) throws BacktrackException, EndOfFileException {
        while (true) {
            IToken token = this.LA(1);
            if (allowAttrib && token.getType() == 154) {
                this.__attribute__();
                continue;
            }
            if (!allowDeclspec || token.getType() != 155) break;
            this.__declspec();
        }
    }

    protected void __attribute__() throws BacktrackException, EndOfFileException {
        IToken token = this.LA(1);
        if (token.getType() == 154) {
            this.consume();
            token = this.LA(1);
            if (token.getType() == 8) {
                this.consume();
                block17: while (true) {
                    token = this.LA(1);
                    switch (token.getType()) {
                        case 8: {
                            this.consume();
                            boolean ident = false;
                            boolean comma1 = false;
                            boolean first = true;
                            block18: while (true) {
                                token = this.LA(1);
                                switch (token.getType()) {
                                    case 1: {
                                        if (comma1 || first) {
                                            ident = true;
                                            first = false;
                                        } else {
                                            this.throwBacktrack(token.getOffset(), token.getLength());
                                        }
                                        this.consume();
                                        continue block18;
                                    }
                                    case 8: {
                                        this.consume();
                                        if (ident) {
                                            token = this.LA(1);
                                            block19: while (true) {
                                                try {
                                                    while (true) {
                                                        this.expression();
                                                    }
                                                }
                                                catch (BacktrackException be) {
                                                    switch (this.LT(1)) {
                                                        case 6: {
                                                            this.consume();
                                                            continue block19;
                                                        }
                                                        case 9: {
                                                            this.consume();
                                                            continue block18;
                                                        }
                                                    }
                                                    throw be;
                                                }
                                                break;
                                            }
                                        }
                                        this.throwBacktrack(token.getOffset(), token.getLength());
                                        continue block18;
                                    }
                                    case 9: {
                                        this.consume();
                                        continue block17;
                                    }
                                    case 6: {
                                        if (ident) {
                                            ident = false;
                                            comma1 = true;
                                        }
                                        this.consume();
                                        continue block18;
                                    }
                                    case 67: {
                                        this.consume();
                                        continue block18;
                                    }
                                }
                                this.throwBacktrack(token.getOffset(), token.getLength());
                            }
                        }
                        case 9: {
                            this.consume();
                            return;
                        }
                    }
                    this.throwBacktrack(token.getOffset(), token.getLength());
                }
            }
        }
    }

    protected void __declspec() throws BacktrackException, EndOfFileException {
        IToken token = this.LA(1);
        if (token.getType() == 155) {
            this.consume();
            if (this.LT(1) == 8) {
                this.skipBrackets(8, 9);
            }
        }
    }

    protected void handleOtherDeclSpecModifier() throws BacktrackException, EndOfFileException {
        this.consume();
        IToken token = this.LA(1);
        if (token.getType() == 8) {
            this.consume();
            int openParen = 1;
            while (true) {
                token = this.LA(1);
                this.consume();
                if (token.getType() == 8) {
                    ++openParen;
                    continue;
                }
                if (token.getType() == 9 && --openParen == 0) break;
            }
        }
    }

    protected boolean avoidCastExpressionByHeuristics() throws EndOfFileException {
        if (this.LT(1) == 1 && this.LT(2) == 9) {
            switch (this.LT(3)) {
                case 16: 
                case 21: 
                case 23: 
                case 30: {
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean canBeTypeSpecifier() throws EndOfFileException {
        switch (this.LT(1)) {
            case 1: 
            case 3: 
            case 60: 
            case 64: 
            case 65: 
            case 67: 
            case 74: 
            case 77: 
            case 82: 
            case 88: 
            case 89: 
            case 104: 
            case 108: 
            case 109: 
            case 118: 
            case 119: 
            case 120: 
            case 123: 
            case 124: 
            case 125: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 140: 
            case 150: 
            case 154: {
                return true;
            }
        }
        return false;
    }

    protected void skipBrackets(int left, int right) throws EndOfFileException, BacktrackException {
        this.consume(left);
        int nesting = 0;
        while (true) {
            int lt1;
            if ((lt1 = this.LT(1)) == 141) {
                this.throwBacktrack(this.LA(1));
            }
            this.consume();
            if (lt1 == left) {
                ++nesting;
                continue;
            }
            if (lt1 == right && --nesting < 0) break;
        }
    }

    public static class FoundDeclaratorException
    extends Exception {
        private static final long serialVersionUID = 0L;
        public IASTDeclSpecifier declSpec;
        public IASTDeclarator declarator;
        public IASTDeclSpecifier altSpec;
        public IASTDeclarator altDeclarator;
        public IToken currToken;

        public FoundDeclaratorException(IASTDeclarator d, IToken t) {
            this.declarator = d;
            this.currToken = t;
        }
    }
}

