/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTDeclarator;

public class CASTFunctionDeclarator
extends CASTDeclarator
implements IASTStandardFunctionDeclarator {
    private IASTParameterDeclaration[] parameters = null;
    private int parametersPos = -1;
    private boolean varArgs;

    public CASTFunctionDeclarator() {
    }

    public CASTFunctionDeclarator(IASTName name) {
        super(name);
    }

    public IASTParameterDeclaration[] getParameters() {
        if (this.parameters == null) {
            return IASTParameterDeclaration.EMPTY_PARAMETERDECLARATION_ARRAY;
        }
        this.parameters = (IASTParameterDeclaration[])ArrayUtil.removeNullsAfter(IASTParameterDeclaration.class, this.parameters, this.parametersPos);
        return this.parameters;
    }

    public void addParameterDeclaration(IASTParameterDeclaration parameter) {
        if (parameter != null) {
            parameter.setParent(this);
            parameter.setPropertyInParent(FUNCTION_PARAMETER);
            this.parameters = (IASTParameterDeclaration[])ArrayUtil.append(IASTParameterDeclaration.class, this.parameters, ++this.parametersPos, parameter);
        }
    }

    public boolean takesVarArgs() {
        return this.varArgs;
    }

    public void setVarArgs(boolean value) {
        this.varArgs = value;
    }

    protected boolean postAccept(ASTVisitor action) {
        IASTParameterDeclaration[] params = this.getParameters();
        int i = 0;
        while (i < params.length) {
            if (!params[i].accept(action)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (this.parameters != null) {
            int i = 0;
            while (i < this.parameters.length) {
                if (child == this.parameters[i]) {
                    other.setPropertyInParent(child.getPropertyInParent());
                    other.setParent(child.getParent());
                    this.parameters[i] = (IASTParameterDeclaration)other;
                    return;
                }
                ++i;
            }
        }
        super.replace(child, other);
    }
}

