/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.composite;

import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.internal.core.index.CIndex;
import org.eclipse.cdt.internal.core.index.DefaultFragmentBindingComparator;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBindingComparator;
import org.eclipse.cdt.internal.core.index.composite.CompositingNotImplementedError;
import org.eclipse.cdt.internal.core.index.composite.ICompositesFactory;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFragmentBindingComparator;
import org.eclipse.core.runtime.CoreException;

public abstract class AbstractCompositeFactory
implements ICompositesFactory {
    protected IIndex index;
    private Comparator<IIndexFragmentBinding> fragmentComparator;

    public AbstractCompositeFactory(IIndex index) {
        this.index = index;
        this.fragmentComparator = new FragmentBindingComparator(new IIndexFragmentBindingComparator[]{new PDOMFragmentBindingComparator(), new DefaultFragmentBindingComparator()});
    }

    public final IIndexBinding[] getCompositeBindings(IIndexFragmentBinding[] bindings) {
        IIndexBinding[] result = new IIndexBinding[bindings.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getCompositeBinding(bindings[i]);
            ++i;
        }
        return result;
    }

    public final IIndexBinding[] getCompositeBindings(IIndexFragmentBinding[][] fragmentBindings) {
        return this.getCompositeBindings(this.mergeBindingArrays(fragmentBindings));
    }

    protected IIndexFragmentBinding[] mergeBindingArrays(IIndexFragmentBinding[][] fragmentBindings) {
        TreeSet<IIndexFragmentBinding> ts = new TreeSet<IIndexFragmentBinding>(this.fragmentComparator);
        int i = 0;
        while (i < fragmentBindings.length) {
            int j = 0;
            while (j < fragmentBindings[i].length) {
                ts.add(fragmentBindings[i][j]);
                ++j;
            }
            ++i;
        }
        return ts.toArray(new IIndexFragmentBinding[ts.size()]);
    }

    protected IIndexFragmentBinding findOneBinding(IBinding binding, boolean allowDeclaration) {
        try {
            CIndex cindex = (CIndex)this.index;
            IIndexFragmentBinding[] ibs = cindex.findEquivalentBindings(binding);
            IIndexFragmentBinding def = null;
            IIndexFragmentBinding dec = ibs.length > 0 ? ibs[0] : null;
            int i = 0;
            while (i < ibs.length) {
                if (ibs[i].hasDefinition()) {
                    def = ibs[i];
                } else if (allowDeclaration && ibs[i].hasDeclaration()) {
                    dec = ibs[i];
                }
                ++i;
            }
            return def == null ? dec : def;
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
            throw new CompositingNotImplementedError();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FragmentBindingComparator
    implements Comparator<IIndexFragmentBinding> {
        private IIndexFragmentBindingComparator[] comparators;

        FragmentBindingComparator(IIndexFragmentBindingComparator[] comparators) {
            this.comparators = comparators;
        }

        @Override
        public int compare(IIndexFragmentBinding f1, IIndexFragmentBinding f2) {
            int i = 0;
            while (i < this.comparators.length) {
                int cmp = this.comparators[i].compare(f1, f2);
                if (cmp != Integer.MIN_VALUE) {
                    return cmp;
                }
                ++i;
            }
            throw new IllegalArgumentException();
        }
    }
}

