/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.runtime.CoreException;

public final class PDOMName
implements IIndexFragmentName,
IASTFileLocation {
    private final PDOM pdom;
    private final int record;
    private static final int FILE_REC_OFFSET = 0;
    private static final int FILE_NEXT_OFFSET = 4;
    private static final int CALLER_REC_OFFSET = 8;
    private static final int BINDING_REC_OFFSET = 12;
    private static final int BINDING_PREV_OFFSET = 16;
    private static final int BINDING_NEXT_OFFSET = 20;
    private static final int NODE_OFFSET_OFFSET = 24;
    private static final int NODE_LENGTH_OFFSET = 27;
    private static final int FLAGS = 29;
    private static final int RECORD_SIZE = 30;
    public static final int IS_DECLARATION = 1;
    public static final int IS_DEFINITION = 2;
    public static final int IS_REFERENCE = 3;
    public static final int DECL_DEF_REF_MASK = 3;
    public static final int IS_INHERITANCE_SPEC = 4;
    public static final int COULD_BE_POLYMORPHIC_METHOD_CALL = 8;
    public static final int READ_ACCESS = 16;
    public static final int WRITE_ACCESS = 32;

    public PDOMName(PDOM pdom, IASTName name, PDOMFile file, PDOMBinding binding, PDOMName caller) throws CoreException {
        this.pdom = pdom;
        Database db = pdom.getDB();
        this.record = db.malloc(30);
        int flags = this.getRoleOfName(name);
        flags |= binding.getAdditionalNameFlags(flags, name);
        db.putByte(this.record + 29, (byte)flags);
        switch (flags & 3) {
            case 2: {
                binding.addDefinition(this);
                break;
            }
            case 1: {
                binding.addDeclaration(this);
                break;
            }
            case 3: {
                binding.addReference(this);
            }
        }
        db.putInt(this.record + 12, binding.getRecord());
        db.putInt(this.record + 0, file.getRecord());
        if (caller != null) {
            db.putInt(this.record + 8, caller.getRecord());
        }
        IASTFileLocation fileloc = name.getFileLocation();
        db.put3ByteUnsignedInt(this.record + 24, fileloc.getNodeOffset());
        db.putShort(this.record + 27, (short)fileloc.getNodeLength());
    }

    private int getRoleOfName(IASTName name) {
        if (name.isDefinition()) {
            return 2;
        }
        if (name.isDeclaration()) {
            return 1;
        }
        return 3;
    }

    public PDOMName(PDOM pdom, int nameRecord) {
        this.pdom = pdom;
        this.record = nameRecord;
    }

    public int getRecord() {
        return this.record;
    }

    private int getRecField(int offset) throws CoreException {
        return this.pdom.getDB().getInt(this.record + offset);
    }

    private void setRecField(int offset, int fieldrec) throws CoreException {
        this.pdom.getDB().putInt(this.record + offset, fieldrec);
    }

    public PDOMBinding getBinding() throws CoreException {
        int bindingrec = this.getRecField(12);
        return this.pdom.getBinding(bindingrec);
    }

    public void setBinding(PDOMBinding binding) throws CoreException {
        int bindingrec = binding != null ? binding.getRecord() : 0;
        this.setRecField(12, bindingrec);
    }

    private PDOMName getNameField(int offset) throws CoreException {
        int namerec = this.getRecField(offset);
        return namerec != 0 ? new PDOMName(this.pdom, namerec) : null;
    }

    private void setNameField(int offset, PDOMName name) throws CoreException {
        int namerec = name != null ? name.getRecord() : 0;
        this.setRecField(offset, namerec);
    }

    public PDOMName getPrevInBinding() throws CoreException {
        return this.getNameField(16);
    }

    public void setPrevInBinding(PDOMName name) throws CoreException {
        this.setNameField(16, name);
    }

    public PDOMName getNextInBinding() throws CoreException {
        return this.getNameField(20);
    }

    public void setNextInBinding(PDOMName name) throws CoreException {
        this.setNameField(20, name);
    }

    public IIndexFile getFile() throws CoreException {
        int filerec = this.pdom.getDB().getInt(this.record + 0);
        return filerec != 0 ? new PDOMFile(this.pdom, filerec) : null;
    }

    public IIndexName getEnclosingDefinition() throws CoreException {
        int namerec = this.getEnclosingDefinitionRecord();
        return namerec != 0 ? new PDOMName(this.pdom, namerec) : null;
    }

    int getEnclosingDefinitionRecord() throws CoreException {
        return this.pdom.getDB().getInt(this.record + 8);
    }

    public PDOMName getNextInFile() throws CoreException {
        return this.getNameField(4);
    }

    public void setNextInFile(PDOMName name) throws CoreException {
        this.setNameField(4, name);
    }

    public char[] toCharArray() {
        try {
            Database db = this.pdom.getDB();
            int bindingRec = db.getInt(this.record + 12);
            PDOMBinding binding = this.pdom.getBinding(bindingRec);
            return binding != null ? binding.getNameCharArray() : null;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public String toString() {
        try {
            Database db = this.pdom.getDB();
            int bindingRec = db.getInt(this.record + 12);
            PDOMBinding binding = this.pdom.getBinding(bindingRec);
            return binding != null ? binding.getName() : null;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    private int getFlags(int mask) throws CoreException {
        return this.pdom.getDB().getByte(this.record + 29) & mask;
    }

    public void setIsBaseSpecifier(boolean val) throws CoreException {
        int flags = this.pdom.getDB().getByte(this.record + 29) & 0xFF;
        flags = val ? (flags |= 4) : (flags &= 0xFFFFFFFB);
        this.pdom.getDB().putByte(this.record + 29, (byte)flags);
    }

    public boolean isBaseSpecifier() throws CoreException {
        return this.getFlags(4) == 4;
    }

    public boolean couldBePolymorphicMethodCall() throws CoreException {
        return this.getFlags(8) == 8;
    }

    public boolean isReadAccess() throws CoreException {
        return this.getFlags(16) == 16;
    }

    public boolean isWriteAccess() throws CoreException {
        return this.getFlags(32) == 32;
    }

    public boolean isDeclaration() {
        try {
            int flags = this.getFlags(3);
            return flags == 1 || flags == 2;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public boolean isReference() {
        try {
            int flags = this.getFlags(3);
            return flags == 3;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public boolean isDefinition() {
        try {
            int flags = this.getFlags(3);
            return flags == 2;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public IASTFileLocation getFileLocation() {
        return this;
    }

    public String getFileName() {
        try {
            PDOMFile file = (PDOMFile)this.getFile();
            if (file != null) {
                URI uri = file.getLocation().getURI();
                if ("file".equals(uri.getScheme())) {
                    return uri.getSchemeSpecificPart();
                }
                File f = EFS.getStore((URI)uri).toLocalFile(0, null);
                if (f != null) {
                    return f.getAbsolutePath();
                }
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    public int getStartingLineNumber() {
        return 0;
    }

    public int getEndingLineNumber() {
        return 0;
    }

    public IASTFileLocation asFileLocation() {
        return this;
    }

    public int getNodeLength() {
        try {
            return this.pdom.getDB().getShort(this.record + 27) & 0xFFFF;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    public int getNodeOffset() {
        try {
            return this.pdom.getDB().get3ByteUnsignedInt(this.record + 24);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    public void delete() throws CoreException {
        PDOMName prevName = this.getPrevInBinding();
        PDOMName nextName = this.getNextInBinding();
        if (prevName != null) {
            prevName.setNextInBinding(nextName);
        } else {
            switch (this.getFlags(3)) {
                case 1: {
                    this.getBinding().setFirstDeclaration(nextName);
                    break;
                }
                case 2: {
                    this.getBinding().setFirstDefinition(nextName);
                    break;
                }
                case 3: {
                    this.getBinding().setFirstReference(nextName);
                }
            }
        }
        if (nextName != null) {
            nextName.setPrevInBinding(prevName);
        }
        this.pdom.getDB().free(this.record);
    }

    public IIndexFragment getIndexFragment() {
        return this.pdom;
    }

    public IIndexName[] getEnclosedNames() throws CoreException {
        ArrayList<PDOMName> result = new ArrayList<PDOMName>();
        PDOMName name = this.getNextInFile();
        while (name != null) {
            if (name.getEnclosingDefinitionRecord() == this.record) {
                result.add(name);
            }
            name = name.getNextInFile();
        }
        return result.toArray(new PDOMName[result.size()]);
    }
}

