/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.cdtvariables;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.cdt.utils.cdtvariables.IVariableSubstitutor;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableManager;

public class CdtVariableResolver {
    private static final String EMPTY_STRING = "";
    public static final String VARIABLE_PREFIX = "${";
    public static final char VARIABLE_SUFFIX = '}';
    public static final char VARIABLE_ESCAPE_CHAR = '\\';
    private static final int VARIABLE_PREFIX_LENGTH = "${".length();

    public static String convertStringListToString(String[] value, String listDelimiter) {
        if (value == null || value.length == 0) {
            return EMPTY_STRING;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < value.length) {
            buffer.append(value[i]);
            if (listDelimiter != null && !EMPTY_STRING.equals(listDelimiter) && i < value.length - 1) {
                buffer.append(listDelimiter);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String resolveToString(String string, IVariableSubstitutor substitutor) throws CdtVariableException {
        return (String)CdtVariableResolver.resolve(string, substitutor, false, false);
    }

    public static void checkVariables(String string, IVariableSubstitutor substitutor) throws CdtVariableException {
        CdtVariableResolver.resolve(string, substitutor, false, true);
    }

    private static Object resolve(String string, IVariableSubstitutor substitutor, boolean asList, boolean checkOnly) throws CdtVariableException {
        if (string == null) {
            return EMPTY_STRING;
        }
        int macroStart = -1;
        int macroEnd = -1;
        int processed = 0;
        StringBuffer buffer = checkOnly ? null : new StringBuffer();
        boolean listMode = false;
        String[] listValue = null;
        int length = string.length();
        while (true) {
            String name;
            if ((macroStart = string.indexOf(VARIABLE_PREFIX, macroEnd + 1)) == -1) {
                if (buffer == null) break;
                buffer.append(string.substring(processed, length));
                break;
            }
            macroEnd = string.indexOf(125, macroStart);
            if (macroEnd == -1) {
                if (buffer == null) break;
                buffer.append(string.substring(processed, length));
                break;
            }
            if (asList && macroStart == 0 && macroEnd == length - 1) {
                listMode = true;
            }
            if (macroStart > 0 && '\\' == string.charAt(macroStart - 1)) {
                int num = macroStart - 2;
                while (num >= 0 && '\\' == string.charAt(num)) {
                    --num;
                }
                num = macroStart - num - 1;
                if (buffer != null) {
                    buffer.append(string.substring(processed, macroStart - (num + 1 >> 1)));
                }
                if ((num & 1) == 0) {
                    processed = macroStart;
                } else {
                    if (buffer != null) {
                        buffer.append(string.substring(macroStart, macroEnd + 1));
                    }
                    processed = macroEnd + 1;
                    continue;
                }
            }
            if (macroStart > processed && buffer != null) {
                buffer.append(string.substring(processed, macroStart));
            }
            if (!EMPTY_STRING.equals(name = string.substring(macroStart + VARIABLE_PREFIX_LENGTH, macroEnd))) {
                if (listMode) {
                    listValue = substitutor.resolveToStringList(name);
                    if (listValue == null) {
                        throw new CdtVariableException(1, null, string, name);
                    }
                } else {
                    String resolved = substitutor.resolveToString(name);
                    if (resolved == null) {
                        throw new CdtVariableException(1, null, string, name);
                    }
                    if (buffer != null) {
                        buffer.append(resolved);
                    }
                }
            }
            processed = macroEnd + 1;
        }
        if (asList) {
            String[] result = null;
            if (listMode) {
                result = listValue != null ? listValue : new String[]{};
            } else if (buffer != null) {
                result = new String[]{buffer.toString()};
            }
            return result;
        }
        if (buffer != null) {
            return buffer.toString();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] resolveStringListValues(String[] values, IVariableSubstitutor substitutor, boolean ignoreErrors) throws CdtVariableException {
        String[] result = null;
        if (values == null) return values;
        if (values.length == 0) {
            return values;
        }
        if (values.length == 1) {
            try {
                return CdtVariableResolver.resolveToStringList(values[0], substitutor);
            }
            catch (CdtVariableException e) {
                if (ignoreErrors) return result;
                throw e;
            }
        }
        ArrayList list = new ArrayList();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                String value = stringArray[n2];
                try {
                    String[] resolved = CdtVariableResolver.resolveToStringList(value, substitutor);
                    if (resolved != null && resolved.length > 0) {
                        list.addAll(Arrays.asList(resolved));
                    }
                }
                catch (CdtVariableException e) {
                    if (ignoreErrors) break block8;
                    throw e;
                }
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] resolveToStringList(String string, IVariableSubstitutor substitutor) throws CdtVariableException {
        return (String[])CdtVariableResolver.resolve(string, substitutor, true, false);
    }

    public static boolean isStringListVariable(int macroType) {
        switch (macroType) {
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static void checkIntegrity(IVariableContextInfo info, IVariableSubstitutor substitutor) throws CdtVariableException {
        ICdtVariable[] macros;
        if (info != null && (macros = SupplierBasedCdtVariableManager.getVariables(info, true)) != null) {
            ICdtVariable[] iCdtVariableArray = macros;
            int n = macros.length;
            int n2 = 0;
            while (n2 < n) {
                ICdtVariable macro = iCdtVariableArray[n2];
                if (CdtVariableResolver.isStringListVariable(macro.getValueType())) {
                    substitutor.resolveToStringList(macro.getName());
                } else {
                    substitutor.resolveToString(macro.getName());
                }
                ++n2;
            }
        }
    }

    public static String createVariableReference(String name) {
        return VARIABLE_PREFIX + name + '}';
    }
}

