/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.som.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.Addr32Factory;
import org.eclipse.cdt.utils.BinaryObjectAdapter;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.IGnuToolFactory;
import org.eclipse.cdt.utils.Objdump;
import org.eclipse.cdt.utils.som.AR;
import org.eclipse.cdt.utils.som.SOM;
import org.eclipse.cdt.utils.som.parser.SomSymbol;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class SOMBinaryObject
extends BinaryObjectAdapter {
    Addr2line addr2line;
    BinaryObjectAdapter.BinaryObjectInfo info;
    IBinaryParser.ISymbol[] symbols;
    long starttime;
    private AR.ARHeader header;
    private IAddressFactory addressFactory;

    public SOMBinaryObject(IBinaryParser parser, IPath path, AR.ARHeader header) {
        super(parser, path, 1);
        this.header = header;
    }

    public SOMBinaryObject(IBinaryParser parser, IPath path, int type) {
        super(parser, path, type);
    }

    public IBinaryParser.ISymbol[] getSymbols() {
        if (this.hasChanged() || this.symbols == null) {
            try {
                this.loadAll();
            }
            catch (IOException iOException) {
                this.symbols = this.NO_SYMBOLS;
            }
        }
        return this.symbols;
    }

    protected BinaryObjectAdapter.BinaryObjectInfo getBinaryObjectInfo() {
        if (this.hasChanged() || this.info == null) {
            try {
                this.loadInfo();
            }
            catch (IOException iOException) {
                this.info = new BinaryObjectAdapter.BinaryObjectInfo();
            }
        }
        return this.info;
    }

    public String getName() {
        if (this.header != null) {
            return this.header.getObjectName();
        }
        return super.getName();
    }

    public InputStream getContents() throws IOException {
        InputStream stream = null;
        if (this.getPath() != null && this.header != null) {
            return new ByteArrayInputStream(this.header.getObjectData());
        }
        Objdump objdump = this.getObjdump();
        if (objdump != null) {
            try {
                byte[] contents = objdump.getOutput();
                stream = new ByteArrayInputStream(contents);
            }
            catch (IOException iOException) {}
        }
        if (stream == null) {
            stream = super.getContents();
        }
        return stream;
    }

    protected SOM getSOM() throws IOException {
        if (this.header != null) {
            return new SOM(this.getPath().toOSString(), this.header.getObjectDataOffset());
        }
        return new SOM(this.getPath().toOSString());
    }

    protected void loadAll() throws IOException {
        SOM som = null;
        try {
            som = this.getSOM();
            this.loadInfo(som);
            this.loadSymbols(som);
        }
        finally {
            if (som != null) {
                som.dispose();
            }
        }
    }

    protected void loadInfo() throws IOException {
        SOM som = null;
        try {
            som = this.getSOM();
            this.loadInfo(som);
        }
        finally {
            if (som != null) {
                som.dispose();
            }
        }
    }

    protected void loadInfo(SOM som) throws IOException {
        this.info = new BinaryObjectAdapter.BinaryObjectInfo();
        SOM.Attribute attribute = som.getAttributes();
        this.info.isLittleEndian = attribute.isLittleEndian();
        this.info.hasDebug = attribute.hasDebug();
        this.info.cpu = attribute.getCPU();
    }

    protected void loadSymbols(SOM som) throws IOException {
        ArrayList list = new ArrayList();
        SOM.Symbol[] peSyms = som.getSymbols();
        byte[] table = som.getStringTable();
        this.addSymbols(peSyms, table, list);
        this.symbols = list.toArray(this.NO_SYMBOLS);
        Arrays.sort(this.symbols);
        list.clear();
    }

    protected void addSymbols(SOM.Symbol[] peSyms, byte[] table, List list) {
        CPPFilt cppfilt = this.getCPPFilt();
        Addr2line addr2line = this.getAddr2line(false);
        int i = 0;
        while (i < peSyms.length) {
            String name;
            if ((peSyms[i].isFunction() || peSyms[i].isVariable()) && (name = peSyms[i].getName(table)) != null && name.trim().length() != 0 && Character.isJavaIdentifierStart(name.charAt(0))) {
                int type = peSyms[i].isFunction() ? 1 : 2;
                Addr32 addr = new Addr32(peSyms[i].symbol_value);
                int size = 4;
                if (cppfilt != null) {
                    try {
                        name = cppfilt.getFunction(name);
                    }
                    catch (IOException iOException) {
                        cppfilt = null;
                    }
                }
                if (addr2line != null) {
                    try {
                        String filename = addr2line.getFileName(addr);
                        if (filename != null && filename.equals("??")) {
                            filename = null;
                        }
                        Path file = filename != null ? new Path(filename) : Path.EMPTY;
                        int startLine = addr2line.getLineNumber(addr);
                        int endLine = addr2line.getLineNumber(addr.add(size - 1));
                        list.add(new SomSymbol(this, name, type, addr, size, (IPath)file, startLine, endLine));
                    }
                    catch (IOException iOException) {
                        addr2line = null;
                        list.add(new SomSymbol(this, name, type, addr, size));
                    }
                } else {
                    list.add(new SomSymbol(this, name, type, addr, size));
                }
            }
            ++i;
        }
        if (cppfilt != null) {
            cppfilt.dispose();
        }
        if (addr2line != null) {
            addr2line.dispose();
        }
    }

    public Addr2line getAddr2line(boolean autodisposing) {
        if (!autodisposing) {
            return this.getAddr2line();
        }
        if (this.addr2line == null) {
            this.addr2line = this.getAddr2line();
            if (this.addr2line != null) {
                this.starttime = System.currentTimeMillis();
                Runnable worker = new Runnable(){

                    public void run() {
                        long diff = System.currentTimeMillis() - SOMBinaryObject.this.starttime;
                        while (diff < 10000L) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException interruptedException) {
                                break;
                            }
                            diff = System.currentTimeMillis() - SOMBinaryObject.this.starttime;
                        }
                        SOMBinaryObject.this.stopAddr2Line();
                    }
                };
                new Thread(worker, "Addr2line Reaper").start();
            }
        } else {
            this.starttime = System.currentTimeMillis();
        }
        return this.addr2line;
    }

    synchronized void stopAddr2Line() {
        if (this.addr2line != null) {
            this.addr2line.dispose();
        }
        this.addr2line = null;
    }

    private Addr2line getAddr2line() {
        IGnuToolFactory factory = (IGnuToolFactory)this.getBinaryParser().getAdapter(IGnuToolFactory.class);
        if (factory != null) {
            return factory.getAddr2line(this.getPath());
        }
        return null;
    }

    protected CPPFilt getCPPFilt() {
        IGnuToolFactory factory = (IGnuToolFactory)this.getBinaryParser().getAdapter(IGnuToolFactory.class);
        if (factory != null) {
            return factory.getCPPFilt();
        }
        return null;
    }

    protected Objdump getObjdump() {
        IGnuToolFactory factory = (IGnuToolFactory)this.getBinaryParser().getAdapter(IGnuToolFactory.class);
        if (factory != null) {
            return factory.getObjdump(this.getPath());
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Addr2line.class) {
            return this.getAddr2line(false);
        }
        if (adapter == CPPFilt.class) {
            return this.getCPPFilt();
        }
        return super.getAdapter(adapter);
    }

    public IAddressFactory getAddressFactory() {
        if (this.addressFactory == null) {
            this.addressFactory = new Addr32Factory();
        }
        return this.addressFactory;
    }
}

