/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.spawner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteOrder;
import java.util.Properties;
import java.util.Vector;

public class EnvironmentReader {
    private static Properties envVars = null;
    private static Vector rawVars = null;

    public static Properties getEnvVars() {
        block34: {
            if (envVars != null) {
                return (Properties)envVars.clone();
            }
            String OS = System.getProperty("os.name").toLowerCase();
            Process p = null;
            envVars = new Properties();
            rawVars = new Vector(32);
            String command = "env";
            InputStream in = null;
            boolean check_ready = false;
            boolean isWin32 = false;
            String charSet = null;
            if (OS.startsWith("windows 9") || OS.startsWith("windows me")) {
                command = "command.com /c set";
                check_ready = true;
                isWin32 = true;
            } else if (OS.startsWith("windows ")) {
                command = "cmd.exe /u /c  set";
                isWin32 = true;
                charSet = "UTF-16" + (ByteOrder.BIG_ENDIAN.equals(ByteOrder.nativeOrder()) ? "BE" : "LE");
            }
            try {
                try {
                    String line;
                    p = Runtime.getRuntime().exec(command);
                    in = p.getInputStream();
                    BufferedReader br = charSet == null ? new BufferedReader(new InputStreamReader(in)) : new BufferedReader(new InputStreamReader(in, charSet));
                    String prev_key = null;
                    String prev_value = null;
                    while ((line = br.readLine()) != null) {
                        rawVars.add(line);
                        int idx = line.indexOf(61);
                        if (idx != -1) {
                            String key = line.substring(0, idx);
                            if (isWin32) {
                                key = key.toUpperCase();
                            }
                            String value = line.substring(idx + 1);
                            envVars.setProperty(key, value);
                            prev_key = key;
                            prev_value = value;
                        } else if (prev_key != null) {
                            prev_value = prev_value != null ? String.valueOf(prev_value) + '\n' + line : line;
                            envVars.setProperty(prev_key, prev_value);
                        } else {
                            envVars.setProperty(line, "");
                        }
                        if (!check_ready || br.ready()) {
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException iOException2) {}
                    try {
                        if (p != null) {
                            p.waitFor();
                        }
                        break block34;
                    }
                    catch (InterruptedException interruptedException) {}
                    break block34;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (p != null) {
                        p.waitFor();
                    }
                }
                catch (InterruptedException interruptedException) {}
                throw throwable;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (p != null) {
                    p.waitFor();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        rawVars.trimToSize();
        return (Properties)envVars.clone();
    }

    public static String getEnvVar(String key) {
        Properties p = EnvironmentReader.getEnvVars();
        return p.getProperty(key);
    }

    public static String[] getRawEnvVars() {
        EnvironmentReader.getEnvVars();
        return rawVars.toArray(new String[0]);
    }
}

