/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.extension.impl;

import java.util.Arrays;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.EntryStore;
import org.eclipse.cdt.core.settings.model.util.KindBasedStore;

public class CDefaultLanguageData
extends CLanguageData {
    protected static final int OP_COPY = 1;
    protected static final int OP_SET = 2;
    protected String fName;
    protected String fId;
    protected String fLanguageId;
    protected int fSupportedKinds;
    protected String[] fSourceContentTypeIds;
    protected String[] fSourceExts;
    protected EntryStore fStore;
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected boolean fIsModified;

    protected CDefaultLanguageData() {
        this.fStore = this.createStore();
    }

    public CDefaultLanguageData(String id, String languageId, String[] ids, boolean isContentTypes) {
        this.fId = id;
        this.fLanguageId = languageId;
        if (isContentTypes) {
            this.fSourceContentTypeIds = (String[])ids.clone();
        } else {
            this.fSourceExts = (String[])ids.clone();
        }
        this.fStore = this.createStore();
    }

    public CDefaultLanguageData(String id, CLanguageData base) {
        this.fId = id;
        this.copySettingsFrom(base);
    }

    protected void copySettingsFrom(CLanguageData data) {
        this.fName = data.getName();
        this.fLanguageId = data.getLanguageId();
        this.fSupportedKinds = data.getSupportedEntryKinds();
        this.fSourceContentTypeIds = data.getSourceContentTypeIds();
        this.fSourceExts = data.getSourceExtensions();
        this.fStore = this.createStore(data);
    }

    protected EntryStore createStore(CLanguageData data) {
        EntryStore store = this.createStore();
        int[] kinds = KindBasedStore.getLanguageEntryKinds();
        int i = 0;
        while (i < kinds.length) {
            ICLanguageSettingEntry[] entries = this.getEntriesToCopy(kinds[i], data);
            entries = this.processStoredEntries(entries, 1);
            store.storeEntries(kinds[i], entries);
            ++i;
        }
        return store;
    }

    protected ICLanguageSettingEntry[] getEntriesToCopy(int kind, CLanguageData lData) {
        return lData.getEntries(kind);
    }

    protected ICLanguageSettingEntry[] processStoredEntries(ICLanguageSettingEntry[] entries, int op) {
        return entries;
    }

    protected EntryStore createStore() {
        return new EntryStore(true);
    }

    public String getName() {
        return this.fName;
    }

    public String getId() {
        return this.fId;
    }

    public boolean isValid() {
        return this.getId() != null;
    }

    public String getLanguageId() {
        return this.fLanguageId;
    }

    public void setLanguageId(String id) {
        if (CDataUtil.objectsEqual(id, this.fLanguageId)) {
            return;
        }
        this.fLanguageId = id;
        this.setModified(true);
    }

    public String[] getSourceContentTypeIds() {
        if (this.fSourceContentTypeIds != null) {
            return this.fSourceContentTypeIds;
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] getSourceExtensions() {
        if (this.fSourceExts != null) {
            return this.fSourceExts;
        }
        return EMPTY_STRING_ARRAY;
    }

    public int getSupportedEntryKinds() {
        return this.fSupportedKinds;
    }

    public void setEntries(int kind, ICLanguageSettingEntry[] entries) {
        entries = this.processStoredEntries(entries, 2);
        this.fStore.storeEntries(kind, entries);
        this.setModified(true);
    }

    public ICLanguageSettingEntry[] getEntries(int kind) {
        return this.fStore.getEntries(kind);
    }

    public void setSourceContentTypeIds(String[] ids) {
        if (Arrays.equals(ids, this.fSourceContentTypeIds)) {
            return;
        }
        this.fSourceContentTypeIds = ids != null ? (String[])ids.clone() : null;
        this.setModified(true);
    }

    public void setSourceExtensions(String[] exts) {
        if (Arrays.equals(exts, this.fSourceExts)) {
            return;
        }
        this.fSourceExts = exts != null ? (String[])exts.clone() : null;
        this.setModified(true);
    }

    public boolean isModified() {
        return this.fIsModified;
    }

    public void setModified(boolean modified) {
        this.fIsModified = modified;
    }
}

