/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IASTServiceProvider;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.IParserConfiguration;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.parser.GNUScannerExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.IScannerExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.c.ANSICParserExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.c.GCCParserExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.c.GCCScannerExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.cpp.ANSICPPParserExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.cpp.GPPParserExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.cpp.GPPScannerExtensionConfiguration;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.dom.SavedCodeReaderFactory;
import org.eclipse.cdt.internal.core.dom.parser.AbstractGNUSourceCodeParser;
import org.eclipse.cdt.internal.core.dom.parser.c.GNUCSourceParser;
import org.eclipse.cdt.internal.core.dom.parser.cpp.GNUCPPSourceParser;
import org.eclipse.cdt.internal.core.parser.scanner.CPreprocessor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.content.IContentType;

public class InternalASTServiceProvider
implements IASTServiceProvider {
    protected static final GCCScannerExtensionConfiguration C_GNU_SCANNER_EXTENSION = new GCCScannerExtensionConfiguration();
    protected static final GPPScannerExtensionConfiguration CPP_GNU_SCANNER_EXTENSION = new GPPScannerExtensionConfiguration();
    private static final String[] dialects = new String[]{"C99", "C++98", "GNUC", "GNUC++"};

    public String getName() {
        return "CDT AST Service";
    }

    public IASTTranslationUnit getTranslationUnit(IFile fileToParse) throws IASTServiceProvider.UnsupportedDialectException {
        return this.getTranslationUnit(fileToParse.getLocation().toOSString(), (IResource)fileToParse, SavedCodeReaderFactory.getInstance(), null, false);
    }

    public IASTTranslationUnit getTranslationUnit(IFile fileToParse, ICodeReaderFactory fileCreator) throws IASTServiceProvider.UnsupportedDialectException {
        return this.getTranslationUnit(fileToParse.getLocation().toOSString(), (IResource)fileToParse, fileCreator, null, false);
    }

    public IASTTranslationUnit getTranslationUnit(IFile fileToParse, ICodeReaderFactory fileCreator, IParserConfiguration configuration) throws IASTServiceProvider.UnsupportedDialectException {
        return this.getTranslationUnit(fileToParse.getLocation().toOSString(), (IResource)fileToParse, fileCreator, configuration, false);
    }

    public IASTTranslationUnit getTranslationUnit(String filename, IResource infoProvider, ICodeReaderFactory fileCreator, IParserConfiguration configuration, boolean parseComment) throws IASTServiceProvider.UnsupportedDialectException {
        CodeReader reader;
        IProject project = infoProvider.getProject();
        IScannerInfo scanInfo = null;
        if (configuration == null) {
            IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
            if (provider != null) {
                IScannerInfo buildScanInfo = provider.getScannerInformation(infoProvider);
                scanInfo = buildScanInfo != null ? buildScanInfo : new ScannerInfo();
            }
        } else {
            scanInfo = configuration.getScannerInfo();
        }
        if ((reader = fileCreator.createCodeReaderForTranslationUnit(filename)) == null) {
            return null;
        }
        IScanner scanner = null;
        AbstractGNUSourceCodeParser parser = null;
        boolean[] isSource = new boolean[1];
        if (configuration == null || configuration.getParserDialect() == null) {
            ParserLanguage l = this.getLanguage(filename, project, isSource);
            GNUScannerExtensionConfiguration scannerExtensionConfiguration = l == ParserLanguage.CPP ? CPP_GNU_SCANNER_EXTENSION : C_GNU_SCANNER_EXTENSION;
            scanner = this.createScanner(reader, scanInfo, ParserMode.COMPLETE_PARSE, l, ParserFactory.createDefaultLogService(), scannerExtensionConfiguration, fileCreator);
            scanner.setScanComments(parseComment);
            parser = l == ParserLanguage.C ? new GNUCSourceParser(scanner, ParserMode.COMPLETE_PARSE, ParserUtil.getParserLogService(), new GCCParserExtensionConfiguration()) : new GNUCPPSourceParser(scanner, ParserMode.COMPLETE_PARSE, ParserUtil.getParserLogService(), new GPPParserExtensionConfiguration());
        } else {
            String dialect = configuration.getParserDialect();
            if (dialect.equals(dialects[0]) || dialect.equals(dialects[2])) {
                scanner = this.createScanner(reader, scanInfo, ParserMode.COMPLETE_PARSE, ParserLanguage.C, ParserUtil.getScannerLogService(), C_GNU_SCANNER_EXTENSION, fileCreator);
            } else if (dialect.equals(dialects[1]) || dialect.equals(dialects[3])) {
                scanner = this.createScanner(reader, scanInfo, ParserMode.COMPLETE_PARSE, ParserLanguage.CPP, ParserUtil.getScannerLogService(), CPP_GNU_SCANNER_EXTENSION, fileCreator);
            } else {
                throw new IASTServiceProvider.UnsupportedDialectException();
            }
            scanner.setScanComments(parseComment);
            if (dialect.equals(dialects[0])) {
                ANSICParserExtensionConfiguration config = new ANSICParserExtensionConfiguration();
                parser = new GNUCSourceParser(scanner, ParserMode.COMPLETE_PARSE, ParserUtil.getParserLogService(), config);
            } else if (dialect.equals(dialects[1])) {
                ANSICPPParserExtensionConfiguration config = new ANSICPPParserExtensionConfiguration();
                parser = new GNUCPPSourceParser(scanner, ParserMode.COMPLETE_PARSE, ParserUtil.getParserLogService(), config);
            } else if (dialect.equals(dialects[2])) {
                GCCParserExtensionConfiguration config = new GCCParserExtensionConfiguration();
                parser = new GNUCSourceParser(scanner, ParserMode.COMPLETE_PARSE, ParserUtil.getParserLogService(), config);
            } else if (dialect.equals(dialects[3])) {
                GPPParserExtensionConfiguration config = new GPPParserExtensionConfiguration();
                parser = new GNUCPPSourceParser(scanner, ParserMode.COMPLETE_PARSE, ParserUtil.getParserLogService(), config);
            }
        }
        if (parser != null) {
            IASTTranslationUnit ast = parser.parse();
            ast.setIsHeaderUnit(!isSource[0]);
            return ast;
        }
        return null;
    }

    public IASTCompletionNode getCompletionNode(IStorage fileToParse, IProject project, int offset, ICodeReaderFactory fileCreator) throws IASTServiceProvider.UnsupportedDialectException {
        return this.getCompletionNode(fileToParse.getFullPath().toOSString(), (IResource)project, offset, fileCreator);
    }

    public IASTCompletionNode getCompletionNode(IFile fileToParse, int offset, ICodeReaderFactory fileCreator) throws IASTServiceProvider.UnsupportedDialectException {
        return this.getCompletionNode(fileToParse.getLocation().toOSString(), (IResource)fileToParse, offset, fileCreator);
    }

    public IASTCompletionNode getCompletionNode(String filename, IResource infoProvider, int offset, ICodeReaderFactory fileCreator) throws IASTServiceProvider.UnsupportedDialectException {
        IScannerInfo scanInfo = null;
        IProject project = infoProvider.getProject();
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
        if (provider != null) {
            IScannerInfo buildScanInfo = provider.getScannerInformation(infoProvider);
            scanInfo = buildScanInfo != null ? buildScanInfo : new ScannerInfo();
        }
        CodeReader reader = fileCreator.createCodeReaderForTranslationUnit(filename);
        boolean[] isSource = new boolean[1];
        ParserLanguage l = this.getLanguage(filename, project, isSource);
        GNUScannerExtensionConfiguration scannerExtensionConfiguration = null;
        scannerExtensionConfiguration = l == ParserLanguage.CPP ? CPP_GNU_SCANNER_EXTENSION : C_GNU_SCANNER_EXTENSION;
        IScanner scanner = this.createScanner(reader, scanInfo, ParserMode.COMPLETION_PARSE, l, ParserFactory.createDefaultLogService(), scannerExtensionConfiguration, fileCreator);
        scanner.setContentAssistMode(offset);
        AbstractGNUSourceCodeParser parser = null;
        parser = l == ParserLanguage.C ? new GNUCSourceParser(scanner, ParserMode.COMPLETION_PARSE, ParserUtil.getParserLogService(), new GCCParserExtensionConfiguration()) : new GNUCPPSourceParser(scanner, ParserMode.COMPLETION_PARSE, ParserUtil.getParserLogService(), new GPPParserExtensionConfiguration());
        parser.parse();
        IASTCompletionNode node = parser.getCompletionNode();
        return node;
    }

    private IScanner createScanner(CodeReader reader, IScannerInfo scanInfo, ParserMode mode, ParserLanguage lang, IParserLogService log, IScannerExtensionConfiguration scanConfig, ICodeReaderFactory fileCreator) {
        return new CPreprocessor(reader, scanInfo, lang, log, scanConfig, fileCreator);
    }

    public String[] getSupportedDialects() {
        return dialects;
    }

    private ParserLanguage getLanguage(String filename, IProject project, boolean[] isSource) {
        String id = null;
        isSource[0] = false;
        IContentType contentType = CCorePlugin.getContentType(project, filename);
        if (contentType != null) {
            id = contentType.getId();
        }
        if (id != null) {
            if ("org.eclipse.cdt.core.cxxHeader".equals(id)) {
                isSource[0] = true;
                return ParserLanguage.CPP;
            }
            if ("org.eclipse.cdt.core.cxxSource".equals(id)) {
                return ParserLanguage.CPP;
            }
            if ("org.eclipse.cdt.core.cHeader".equals(id)) {
                return ParserLanguage.C;
            }
            if ("org.eclipse.cdt.core.cSource".equals(id)) {
                isSource[0] = true;
                return ParserLanguage.C;
            }
            "org.eclipse.cdt.core.asmSource".equals(id);
        }
        return ParserLanguage.CPP;
    }

    public IASTTranslationUnit getTranslationUnit(IStorage fileToParse, IProject project, ICodeReaderFactory fileCreator) throws IASTServiceProvider.UnsupportedDialectException {
        return this.getTranslationUnit(fileToParse.getFullPath().toOSString(), (IResource)project, fileCreator, null, false);
    }

    public IASTTranslationUnit getTranslationUnit(IStorage fileToParse, IProject project) throws IASTServiceProvider.UnsupportedDialectException {
        return this.getTranslationUnit(fileToParse.getFullPath().toOSString(), (IResource)project, SavedCodeReaderFactory.getInstance(), null, false);
    }

    public IASTTranslationUnit getTranslationUnit(IFile fileToParse, boolean parseComments) throws IASTServiceProvider.UnsupportedDialectException {
        return this.getTranslationUnit(fileToParse.getLocation().toOSString(), (IResource)fileToParse, SavedCodeReaderFactory.getInstance(), null, parseComments);
    }

    public IASTTranslationUnit getTranslationUnit(IFile fileToParse, ICodeReaderFactory fileCreator, boolean parseComments) throws IASTServiceProvider.UnsupportedDialectException {
        return this.getTranslationUnit(fileToParse.getLocation().toOSString(), (IResource)fileToParse, fileCreator, null, parseComments);
    }
}

