/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTNode;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;

public class CASTIdExpression
extends CASTNode
implements IASTIdExpression,
IASTCompletionContext {
    private IASTName name;

    public CASTIdExpression() {
    }

    public CASTIdExpression(IASTName name) {
        this.setName(name);
    }

    public IASTName getName() {
        return this.name;
    }

    public void setName(IASTName name) {
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(ID_NAME);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public int getRoleForName(IASTName n) {
        if (n == this.name) {
            return 1;
        }
        return 3;
    }

    public IType getExpressionType() {
        return CVisitor.getExpressionType(this);
    }

    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        Object[] bindings = CVisitor.findBindingsForContentAssist(n, isPrefix);
        int i = 0;
        while (i < bindings.length) {
            if (bindings[i] instanceof IEnumeration || bindings[i] instanceof ICompositeType) {
                bindings[i] = null;
            }
            ++i;
        }
        return (IBinding[])ArrayUtil.removeNulls(IBinding.class, bindings);
    }
}

