/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.commenthandler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.ASTCommenterVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.CommentHandler;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;
import org.eclipse.cdt.internal.core.dom.rewrite.util.OffsetHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTCommenter {
    public static NodeCommentMap getCommentedNodeMap(IASTTranslationUnit transUnit) {
        if (transUnit == null) {
            return new NodeCommentMap();
        }
        ArrayList<IASTComment> comments = ASTCommenter.removeNotNeededComments(transUnit);
        if (comments == null || comments.size() == 0) {
            return new NodeCommentMap();
        }
        return ASTCommenter.addCommentsToCommentMap(transUnit, comments);
    }

    private static ArrayList<IASTComment> removeNotNeededComments(IASTTranslationUnit transUnit) {
        ArrayList<IASTComment> comments = ASTCommenter.getCommentsInWorkspace(transUnit);
        if (comments == null || comments.size() == 0) {
            return null;
        }
        ArrayList<IASTComment> com = ASTCommenter.removeAllPreprocessorComments(transUnit, comments);
        return com;
    }

    private static ArrayList<IASTComment> getCommentsInWorkspace(IASTTranslationUnit tu) {
        IASTComment[] comments = tu.getComments();
        ArrayList<IASTComment> commentsInWorksapce = new ArrayList<IASTComment>();
        if (comments == null || comments.length == 0) {
            return null;
        }
        IASTComment[] iASTCommentArray = comments;
        int n = comments.length;
        int n2 = 0;
        while (n2 < n) {
            IASTComment comment = iASTCommentArray[n2];
            if (ASTCommenter.isInWorkspace(comment)) {
                commentsInWorksapce.add(comment);
            }
            ++n2;
        }
        return commentsInWorksapce;
    }

    private static ArrayList<IASTComment> removeAllPreprocessorComments(IASTTranslationUnit tu, ArrayList<IASTComment> comments) {
        IASTPreprocessorStatement[] preprocessorStatements = tu.getAllPreprocessorStatements();
        TreeMap<Integer, String> treeOfPreProcessorLines = new TreeMap<Integer, String>();
        ArrayList<Integer> listOfPreProcessorOffset = new ArrayList<Integer>();
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = preprocessorStatements;
        int n = preprocessorStatements.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorStatement statement = iASTPreprocessorStatementArray[n2];
            if (ASTCommenter.isInWorkspace(statement)) {
                treeOfPreProcessorLines.put(OffsetHelper.getStartingLineNumber(statement), statement.getFileLocation().getFileName());
                listOfPreProcessorOffset.add(statement.getFileLocation().getNodeOffset());
            }
            ++n2;
        }
        ArrayList<IASTComment> commentsInCode = new ArrayList<IASTComment>();
        for (IASTComment comment : comments) {
            int comStartLineNumber = OffsetHelper.getStartingLineNumber(comment);
            if (treeOfPreProcessorLines.containsKey(comStartLineNumber) && ((String)treeOfPreProcessorLines.get(comStartLineNumber)).equals(comment.getFileLocation().getFileName()) || ASTCommenter.commentIsAtTheBeginningBeforePreprocessorStatements(comment, listOfPreProcessorOffset)) continue;
            commentsInCode.add(comment);
        }
        return commentsInCode;
    }

    private static boolean commentIsAtTheBeginningBeforePreprocessorStatements(IASTComment comment, ArrayList<Integer> listOfPreProcessorOffset) {
        if (listOfPreProcessorOffset.size() < 1) {
            return false;
        }
        if (comment.getTranslationUnit() == null || comment.getTranslationUnit().getDeclarations().length < 1) {
            return true;
        }
        IASTDeclaration decl = comment.getTranslationUnit().getDeclarations()[0];
        if (decl.getFileLocation().getNodeOffset() < comment.getFileLocation().getNodeOffset()) {
            return false;
        }
        Collections.sort(listOfPreProcessorOffset);
        if (listOfPreProcessorOffset.get(0) < comment.getFileLocation().getNodeOffset()) {
            return false;
        }
        return listOfPreProcessorOffset.get(0) < decl.getFileLocation().getNodeOffset();
    }

    private static boolean isInWorkspace(IASTNode node) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        Path nodePath = new Path(node.getContainingFilename());
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.getLocation().isPrefixOf((IPath)nodePath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static NodeCommentMap addCommentsToCommentMap(IASTTranslationUnit rootNode, ArrayList<IASTComment> comments) {
        NodeCommentMap commentMap = new NodeCommentMap();
        CommentHandler commHandler = new CommentHandler(comments);
        IASTDeclaration[] declarations = rootNode.getDeclarations();
        int i = 0;
        while (i < declarations.length) {
            if (ASTCommenter.isInWorkspace(declarations[i])) {
                ASTCommenterVisitor commenter = new ASTCommenterVisitor(commHandler, commentMap);
                declarations[i].accept(commenter);
                if (i + 1 == declarations.length) {
                    commenter.addRemainingComments(declarations[i]);
                }
            }
            ++i;
        }
        return commentMap;
    }
}

