/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.runtime.CoreException;

public class PDOMCFunctionType
extends PDOMNode
implements IIndexType,
IFunctionType {
    private static final int TYPELIST = 8;
    private static final int RETURN_TYPE = 12;
    protected static final int RECORD_SIZE = 16;

    public PDOMCFunctionType(PDOM pdom, int record) {
        super(pdom, record);
    }

    public PDOMCFunctionType(PDOM pdom, PDOMNode parent, IFunctionType type) throws CoreException {
        super(pdom, parent);
        try {
            PDOMLinkage linkage = parent.getLinkageImpl();
            PDOMNodeLinkedList list = new PDOMNodeLinkedList(pdom, this.record + 8, parent.getLinkageImpl(), true);
            this.setReturnType(type.getReturnType());
            IType[] pt = type.getParameterTypes();
            int i = 0;
            while (i < pt.length) {
                PDOMNode typeNode = pt[i] == null || pt[i] instanceof IProblemBinding ? null : linkage.addType(this, pt[i]);
                list.addMember(typeNode);
                ++i;
            }
        }
        catch (DOMException dOMException) {}
    }

    public void delete(final PDOMLinkage linkage) throws CoreException {
        linkage.deleteType(this.getReturnType(), this.record);
        PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 8, this.getLinkageImpl(), true);
        list.accept(new IPDOMVisitor(){

            public void leave(IPDOMNode node) throws CoreException {
            }

            public boolean visit(IPDOMNode node) throws CoreException {
                if (node instanceof IType) {
                    linkage.deleteType((IType)((Object)node), PDOMCFunctionType.this.record);
                }
                return false;
            }
        });
        list.deleteListItems();
        super.delete(linkage);
    }

    public int getNodeType() {
        return 15;
    }

    protected int getRecordSize() {
        return 16;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSameType(IType type) {
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        try {
            IType rt2;
            if (!(type instanceof IFunctionType)) {
                return false;
            }
            IFunctionType ft = (IFunctionType)type;
            IType rt1 = this.getReturnType();
            if (!(rt1 == (rt2 = ft.getReturnType()) || rt1 != null && rt1.isSameType(rt2))) {
                return false;
            }
            IType[] params1 = this.getParameterTypes();
            IType[] params2 = ft.getParameterTypes();
            if (params1.length == 1 && params2.length == 0) {
                if (params1[0] instanceof IBasicType && ((IBasicType)params1[0]).getType() == 1) return true;
                return false;
            } else if (params2.length == 1 && params1.length == 0) {
                if (params2[0] instanceof IBasicType && ((IBasicType)params2[0]).getType() == 1) return true;
                return false;
            } else {
                if (params1.length != params2.length) {
                    return false;
                }
                int i = 0;
                while (i < params1.length) {
                    if (params1[i] == null || !params1[i].isSameType(params2[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        catch (DOMException dOMException) {
            return false;
        }
    }

    public IType[] getParameterTypes() {
        final ArrayList result = new ArrayList();
        try {
            PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 8, this.getLinkageImpl(), true);
            list.accept(new IPDOMVisitor(){

                public void leave(IPDOMNode node) throws CoreException {
                    result.add((IType)((Object)node));
                }

                public boolean visit(IPDOMNode node) throws CoreException {
                    return false;
                }
            });
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
        }
        return result.toArray(new IType[result.size()]);
    }

    public IType getReturnType() {
        try {
            PDOMNode node = this.getLinkageImpl().getNode(this.pdom.getDB().getInt(this.record + 12));
            if (node instanceof IType) {
                return (IType)((Object)node);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    public void setReturnType(IType type) throws CoreException {
        PDOMNode typeNode = this.getLinkageImpl().addType(this, type);
        if (typeNode != null) {
            this.pdom.getDB().putInt(this.record + 12, typeNode.getRecord());
        }
    }

    public Object clone() {
        throw new PDOMNotImplementedError();
    }
}

