/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

class PDOMCTypedef
extends PDOMBinding
implements ITypedef,
ITypeContainer,
IIndexType {
    private static final int TYPE = 28;
    protected static final int RECORD_SIZE = 32;

    public PDOMCTypedef(PDOM pdom, PDOMNode parent, ITypedef typedef) throws CoreException {
        super(pdom, parent, typedef.getNameCharArray());
        try {
            IType type = typedef.getType();
            this.setType(parent.getLinkageImpl(), type);
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public PDOMCTypedef(PDOM pdom, int record) {
        super(pdom, record);
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof ITypedef) {
            ITypedef td = (ITypedef)newBinding;
            IType mytype = this.getType();
            try {
                IType newType = td.getType();
                this.setType(linkage, newType);
                if (mytype != null) {
                    linkage.deleteType(mytype, this.record);
                }
            }
            catch (DOMException e) {
                throw new CoreException(Util.createStatus(e));
            }
        }
    }

    private void setType(PDOMLinkage linkage, IType newType) throws CoreException, DOMException {
        PDOMNode typeNode = linkage.addType(this, newType);
        if (this.introducesRecursion((IType)((Object)typeNode), this.getNameCharArray())) {
            linkage.deleteType((IType)((Object)typeNode), this.record);
            typeNode = null;
        }
        this.pdom.getDB().putInt(this.record + 28, typeNode != null ? typeNode.getRecord() : 0);
    }

    private boolean introducesRecursion(IType type, char[] tdname) throws DOMException {
        int maxDepth = 50;
        while (--maxDepth > 0) {
            if (type instanceof ITypedef && CharArrayUtils.equals(((ITypedef)type).getNameCharArray(), tdname)) {
                return true;
            }
            if (type instanceof ITypeContainer) {
                type = ((ITypeContainer)type).getType();
                continue;
            }
            if (type instanceof IFunctionType) {
                IFunctionType ft = (IFunctionType)type;
                if (this.introducesRecursion(ft.getReturnType(), tdname)) {
                    return true;
                }
                IType[] params = ft.getParameterTypes();
                int i = 0;
                while (i < params.length) {
                    IType param = params[i];
                    if (this.introducesRecursion(param, tdname)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    protected int getRecordSize() {
        return 32;
    }

    public int getNodeType() {
        return 12;
    }

    public IType getType() {
        try {
            int typeRec = this.pdom.getDB().getInt(this.record + 28);
            return (IType)((Object)this.getLinkageImpl().getNode(typeRec));
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public boolean isSameType(IType type) {
        IType myrtype;
        block4: {
            try {
                myrtype = this.getType();
                if (myrtype != null) break block4;
                return false;
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        if (type instanceof ITypedef) {
            type = ((ITypedef)type).getType();
        }
        return myrtype.isSameType(type);
    }

    public void setType(IType type) {
        this.fail();
    }

    public Object clone() {
        this.fail();
        return null;
    }
}

