/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotation;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunction;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunctionTemplate;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunctionType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameterSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPSpecialization;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPFunctionSpecialization
extends PDOMCPPSpecialization
implements ICPPFunction {
    private static final int NUM_PARAMS = 44;
    private static final int FIRST_PARAM = 48;
    private static final int FUNCTION_TYPE = 52;
    protected static final int ANNOTATION = 56;
    protected static final int RECORD_SIZE = 57;

    public PDOMCPPFunctionSpecialization(PDOM pdom, PDOMNode parent, ICPPFunction function, PDOMBinding specialized) throws CoreException {
        super(pdom, parent, (ICPPSpecialization)((Object)function), specialized);
        if (specialized instanceof PDOMCPPFunctionTemplate) {
            ((PDOMCPPFunctionTemplate)specialized).addMember(this);
        }
        Database db = pdom.getDB();
        try {
            PDOMNode typeNode;
            IFunctionType ft = function.getType();
            if (ft != null && (typeNode = this.getLinkageImpl().addType(this, ft)) != null) {
                db.putInt(this.record + 52, typeNode.getRecord());
            }
            ft = this.getType();
            IParameter[] params = function.getParameters();
            IType[] paramTypes = ft.getParameterTypes();
            ICPPFunction sFunc = (ICPPFunction)((ICPPSpecialization)((Object)function)).getSpecializedBinding();
            IParameter[] sParams = sFunc.getParameters();
            IType[] sParamTypes = sFunc.getType().getParameterTypes();
            int length = Math.min(sParams.length, params.length);
            db.putInt(this.record + 44, length);
            int i = 0;
            while (i < length) {
                int typeRecord = i < paramTypes.length && paramTypes[i] != null ? ((PDOMNode)((Object)paramTypes[i])).getRecord() : 0;
                IType type = i < sParamTypes.length ? sParamTypes[i] : null;
                PDOMCPPParameter sParam = new PDOMCPPParameter(pdom, (PDOMNode)this, sParams[i], type);
                this.setFirstParameter(new PDOMCPPParameterSpecialization(pdom, (PDOMNode)this, (ICPPParameter)params[i], sParam, typeRecord));
                ++i;
            }
            db.putByte(this.record + 56, PDOMCPPAnnotation.encodeAnnotation(function));
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public PDOMCPPFunctionSpecialization(PDOM pdom, int bindingRecord) {
        super(pdom, bindingRecord);
    }

    protected int getRecordSize() {
        return 57;
    }

    public int getNodeType() {
        return 34;
    }

    public PDOMCPPParameterSpecialization getFirstParameter() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 48);
        return rec != 0 ? new PDOMCPPParameterSpecialization(this.pdom, rec) : null;
    }

    public void setFirstParameter(PDOMCPPParameterSpecialization param) throws CoreException {
        if (param != null) {
            param.setNextParameter(this.getFirstParameter());
        }
        int rec = param != null ? param.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 48, rec);
    }

    public boolean isInline() throws DOMException {
        return this.getBit(this.getByte(this.record + 56), 2);
    }

    public boolean isMutable() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IScope getFunctionScope() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IParameter[] getParameters() throws DOMException {
        try {
            int n = this.pdom.getDB().getInt(this.record + 44);
            IParameter[] params = new IParameter[n];
            PDOMCPPParameterSpecialization param = this.getFirstParameter();
            while (param != null) {
                params[--n] = param;
                param = param.getNextParameter();
            }
            return params;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IParameter[0];
        }
    }

    public IFunctionType getType() throws DOMException {
        try {
            int offset = this.pdom.getDB().getInt(this.record + 52);
            return offset == 0 ? null : new PDOMCPPFunctionType(this.pdom, offset);
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
            return null;
        }
    }

    public boolean isAuto() throws DOMException {
        return false;
    }

    public boolean isExtern() throws DOMException {
        return this.getBit(this.getByte(this.record + 56), 1);
    }

    public boolean isExternC() throws DOMException {
        return this.getBit(this.getByte(this.record + 56), 6);
    }

    public boolean isRegister() throws DOMException {
        return false;
    }

    public boolean isStatic() throws DOMException {
        return this.getBit(this.getByte(this.record + 56), 4);
    }

    public boolean takesVarArgs() throws DOMException {
        return this.getBit(this.getByte(this.record + 56), 5);
    }

    public boolean isConst() {
        return false;
    }

    public boolean isVolatile() {
        return false;
    }

    public int pdomCompareTo(PDOMBinding other) {
        int cmp = super.pdomCompareTo(other);
        return cmp == 0 ? PDOMCPPFunction.compareSignatures(this, other) : cmp;
    }
}

