/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.pdom.IndexerInputAdapter;
import org.eclipse.cdt.internal.core.pdom.indexer.FileExistsCache;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ProjectIndexerInputAdapter
extends IndexerInputAdapter {
    private final ICProject fCProject;
    private final HashMap<String, IIndexFileLocation> fIflCache;
    private final FileExistsCache fExistsCache;

    public ProjectIndexerInputAdapter(ICProject cproject) {
        this(cproject, true);
    }

    public ProjectIndexerInputAdapter(ICProject cproject, boolean useCache) {
        this.fCProject = cproject;
        if (useCache) {
            this.fIflCache = new HashMap();
            this.fExistsCache = new FileExistsCache();
        } else {
            this.fIflCache = null;
            this.fExistsCache = null;
        }
    }

    public IIndexFileLocation resolveASTPath(String astPath) {
        if (this.fIflCache == null) {
            return this.doResolveASTPath(astPath);
        }
        IIndexFileLocation result = this.fIflCache.get(astPath);
        if (result == null) {
            result = this.doResolveASTPath(astPath);
            this.fIflCache.put(astPath, result);
        }
        return result;
    }

    private IIndexFileLocation doResolveASTPath(String astPath) {
        return IndexLocationFactory.getIFLExpensive(this.fCProject, astPath);
    }

    public IIndexFileLocation resolveIncludeFile(String includePath) {
        if (this.fIflCache == null) {
            return this.doResolveASTPath(includePath);
        }
        if (!this.fExistsCache.isFile(includePath)) {
            return null;
        }
        IIndexFileLocation result = this.fIflCache.get(includePath);
        if (result == null) {
            result = this.doResolveASTPath(includePath);
            if (result.getFullPath() == null) {
                try {
                    File location = new File(includePath);
                    String canonicalPath = location.getCanonicalPath();
                    if (!includePath.equals(canonicalPath)) {
                        result = IndexLocationFactory.getExternalIFL(canonicalPath);
                        this.fIflCache.put(canonicalPath, result);
                    }
                }
                catch (IOException iOException) {}
            }
            this.fIflCache.put(includePath, result);
        }
        return result;
    }

    public boolean doesIncludeFileExist(String includePath) {
        if (this.fExistsCache != null) {
            return this.fExistsCache.isFile(includePath);
        }
        return new File(includePath).isFile();
    }

    public String getASTPath(IIndexFileLocation ifl) {
        IPath path = IndexLocationFactory.getAbsolutePath(ifl);
        if (path != null) {
            return path.toString();
        }
        return ifl.getURI().getPath();
    }

    public IScannerInfo getBuildConfiguration(int linkageID, Object tu) {
        IScannerInfo info = ((ITranslationUnit)tu).getScannerInfo(true);
        if (info == null) {
            info = new ScannerInfo();
        }
        return info;
    }

    public long getLastModified(IIndexFileLocation ifl) {
        String fullPath = ifl.getFullPath();
        if (fullPath != null) {
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(fullPath));
            if (res != null) {
                return res.getLocalTimeStamp();
            }
            return 0L;
        }
        IPath location = IndexLocationFactory.getAbsolutePath(ifl);
        if (location != null) {
            return location.toFile().lastModified();
        }
        return 0L;
    }

    public AbstractLanguage[] getLanguages(Object tuo) {
        ITranslationUnit tu = (ITranslationUnit)tuo;
        try {
            ILanguage lang = tu.getLanguage();
            if (lang instanceof AbstractLanguage) {
                return new AbstractLanguage[]{(AbstractLanguage)lang};
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return new AbstractLanguage[0];
    }

    public boolean isFileBuildConfigured(Object tuo) {
        ITranslationUnit tu = (ITranslationUnit)tuo;
        return !CoreModel.isScannerInformationEmpty(tu.getResource());
    }

    public boolean isSourceUnit(Object tuo) {
        ITranslationUnit tu = (ITranslationUnit)tuo;
        return tu.isSourceUnit();
    }

    public IIndexFileLocation resolveFile(Object tuo) {
        ITranslationUnit tu = (ITranslationUnit)tuo;
        return IndexLocationFactory.getIFL(tu);
    }

    public boolean canBePartOfSDK(IIndexFileLocation ifl) {
        return ifl.getFullPath() == null;
    }

    public Object getInputFile(IIndexFileLocation location) {
        try {
            return CoreModelUtil.findTranslationUnitForLocation(location, this.fCProject);
        }
        catch (CModelException e) {
            CCorePlugin.log((Throwable)((Object)e));
            return null;
        }
    }

    public CodeReader getCodeReader(Object tuo) {
        ITranslationUnit tu = (ITranslationUnit)tuo;
        CodeReader reader = tu.getCodeReader();
        if (reader != null) {
            IIndexFileLocation ifl = IndexLocationFactory.getIFL(tu);
            this.fIflCache.put(reader.getPath(), ifl);
        }
        return reader;
    }
}

