/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.executables;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ISymbolReader;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.core.executables.ExecutablesManager;
import org.eclipse.cdt.internal.core.model.BinaryParserConfig;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public class Executable
extends PlatformObject {
    private IPath path;
    private IProject project;
    private String name;
    private IResource resource;
    private Map<ITranslationUnit, String> remappedPaths;
    private ArrayList<ITranslationUnit> sourceFiles;
    private boolean refreshSourceFiles;

    public IPath getPath() {
        return this.path;
    }

    public IProject getProject() {
        return this.project;
    }

    public Executable(IPath path, IProject project, IResource resource) {
        this.path = path;
        this.project = project;
        this.name = new File(path.toOSString()).getName();
        this.resource = resource;
        this.remappedPaths = new HashMap<ITranslationUnit, String>();
        this.sourceFiles = new ArrayList();
        this.refreshSourceFiles = true;
    }

    public IResource getResource() {
        return this.resource;
    }

    public String toString() {
        return this.path.toString();
    }

    public String getName() {
        return this.name;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IResource.class)) {
            if (this.getResource() != null) {
                return this.getResource();
            }
            return this.getProject();
        }
        return super.getAdapter(adapter);
    }

    public static boolean isExecutableFile(IPath path) {
        if (path.toFile().isDirectory()) {
            return false;
        }
        String ext = path.getFileExtension();
        if (ext != null) {
            boolean isNumber = true;
            int i = 0;
            while (i < ext.length()) {
                if (!Character.isDigit(ext.charAt(i))) {
                    isNumber = false;
                    break;
                }
                ++i;
            }
            if (!isNumber) {
                boolean isBinary = false;
                IContentTypeManager ctm = Platform.getContentTypeManager();
                IContentType ctbin = ctm.getContentType("org.eclipse.cdt.core.binaryFile");
                IContentType[] cts = ctm.findContentTypesFor(path.toFile().getName());
                int i2 = 0;
                while (!isBinary && i2 < cts.length) {
                    isBinary = cts[i2].isKindOf(ctbin);
                    ++i2;
                }
                if (!isBinary) {
                    return false;
                }
            }
        }
        return true;
    }

    public IBinaryParser.IBinaryFile createBinaryFile() {
        CModelManager factory = CModelManager.getDefault();
        if (this.resource != null && this.resource instanceof IFile) {
            return factory.createBinaryFile((IFile)this.resource);
        }
        BinaryParserConfig[] parsers = factory.getBinaryParser(this.getProject());
        if (parsers.length == 0) {
            return null;
        }
        if (!Executable.isExecutableFile(this.path)) {
            return null;
        }
        File f = new File(this.path.toOSString());
        if (f.length() == 0L) {
            return null;
        }
        int hints = 0;
        int i = 0;
        while (i < parsers.length) {
            IBinaryParser parser = null;
            try {
                parser = parsers[i].getBinaryParser();
                if (parser.getHintBufferSize() > hints) {
                    hints = parser.getHintBufferSize();
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        byte[] bytes = new byte[hints];
        if (hints > 0) {
            InputStream is = null;
            try {
                try {
                    is = new FileInputStream(this.path.toFile());
                    int count = 0;
                    while (count < hints) {
                        int bytesRead = is.read(bytes, count, hints - count);
                        if (bytesRead < 0) break;
                        count += bytesRead;
                    }
                    if (count > 0 && count < bytes.length) {
                        byte[] array = new byte[count];
                        System.arraycopy(bytes, 0, array, 0, count);
                        bytes = array;
                    }
                }
                catch (IOException iOException) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    return null;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        int i2 = 0;
        while (i2 < parsers.length) {
            try {
                IBinaryParser.IBinaryFile binFile;
                IBinaryParser parser = parsers[i2].getBinaryParser();
                if (parser.isBinary(bytes, this.path) && (binFile = parser.getBinary(bytes, this.path)) != null) {
                    return binFile;
                }
            }
            catch (IOException iOException) {
            }
            catch (CoreException coreException) {}
            ++i2;
        }
        return null;
    }

    public TranslationUnit[] getSourceFiles(IProgressMonitor monitor) {
        if (!this.refreshSourceFiles) {
            return this.sourceFiles.toArray(new TranslationUnit[this.sourceFiles.size()]);
        }
        this.remappedPaths.clear();
        this.sourceFiles.clear();
        CModelManager factory = CModelManager.getDefault();
        IBinaryParser.IBinaryFile bin = this.createBinaryFile();
        if (bin != null) {
            String[] symReaderSources;
            ICProject cproject = factory.create(this.project);
            ISymbolReader symbolreader = (ISymbolReader)bin.getAdapter(ISymbolReader.class);
            if (symbolreader != null && (symReaderSources = symbolreader.getSourceFiles()) != null && symReaderSources.length > 0) {
                int i = 0;
                while (i < symReaderSources.length) {
                    String filename;
                    String orgPath = filename = symReaderSources[i];
                    filename = ExecutablesManager.getExecutablesManager().remapSourceFile(filename);
                    try {
                        File file = new File(filename);
                        if (file.exists()) {
                            filename = file.getCanonicalPath();
                        } else if (filename.startsWith(".")) {
                            file = new File(bin.getPath().removeLastSegments(1).toOSString(), filename);
                            filename = file.getCanonicalPath();
                        }
                    }
                    catch (IOException iOException) {}
                    IFile sourceFile = this.getProject().getFile(filename);
                    Path path = new Path(filename);
                    IFile wkspFile = null;
                    if (sourceFile.exists()) {
                        wkspFile = sourceFile;
                    } else {
                        IFile[] filesInWP = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path);
                        int j = 0;
                        while (j < filesInWP.length) {
                            if (filesInWP[j].isAccessible()) {
                                wkspFile = filesInWP[j];
                                break;
                            }
                            ++j;
                        }
                    }
                    String id = CoreModel.getRegistedContentTypeId((IProject)sourceFile.getProject(), (String)sourceFile.getName());
                    if (id != null) {
                        Object tu = wkspFile != null ? new TranslationUnit((ICElement)cproject, wkspFile, id) : new ExternalTranslationUnit((ICElement)cproject, URIUtil.toURI((IPath)path), id);
                        this.sourceFiles.add((ITranslationUnit)tu);
                        if (!orgPath.equals(filename)) {
                            this.remappedPaths.put((ITranslationUnit)tu, orgPath);
                        }
                    }
                    ++i;
                }
            }
        }
        this.refreshSourceFiles = false;
        return this.sourceFiles.toArray(new TranslationUnit[this.sourceFiles.size()]);
    }

    public void setRefreshSourceFiles(boolean refreshSourceFiles) {
        this.refreshSourceFiles = refreshSourceFiles;
    }

    public String getOriginalLocation(ITranslationUnit tu) {
        String orgLocation = this.remappedPaths.get(tu);
        if (orgLocation == null) {
            orgLocation = tu.getPath().toOSString();
        }
        return orgLocation;
    }
}

