/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.debug.core.ICGlobalVariableManager;
import org.eclipse.cdt.debug.core.model.IExecFileInfo;
import org.eclipse.cdt.debug.core.model.IGlobalVariableDescriptor;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class AddGlobalsActionDelegate
extends ActionDelegate
implements IViewActionDelegate,
ISelectionListener,
IPartListener {
    private IGlobalVariableDescriptor[] fGlobals;
    private IViewPart fView = null;
    private IAction fAction;
    private IStructuredSelection fSelection;
    private IStatus fStatus = null;

    public void init(IViewPart view) {
        this.fView = view;
        view.getSite().getPage().addPartListener((IPartListener)this);
        view.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part != null && part.getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
            if (selection instanceof IStructuredSelection) {
                this.setSelection((IStructuredSelection)selection);
            } else {
                this.setSelection(null);
            }
            this.update(this.getAction());
        }
    }

    public void run(IAction action) {
        final IStructuredSelection selection = this.getSelection();
        if (selection != null && selection.size() != 1) {
            return;
        }
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    AddGlobalsActionDelegate.this.doAction(selection.getFirstElement());
                    AddGlobalsActionDelegate.this.setStatus(null);
                }
                catch (DebugException e) {
                    AddGlobalsActionDelegate.this.setStatus(e.getStatus());
                }
            }
        });
        IStatus status = this.getStatus();
        if (status != null && !status.isOK()) {
            IWorkbenchWindow window;
            if (status.isMultiStatus()) {
                status = new MultiStatus(status.getPlugin(), status.getCode(), status.getChildren(), ActionMessages.getString("AddGlobalsActionDelegate.Error(s)_occured_adding_globals_1"), status.getException());
            }
            if ((window = CDebugUIPlugin.getActiveWorkbenchWindow()) != null) {
                CDebugUIPlugin.errorDialog(this.getErrorDialogMessage(), status);
            } else {
                CDebugUIPlugin.log(status);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setAction(action);
        if (this.getView() != null) {
            this.update(action);
        }
    }

    protected void update(IAction action) {
        if (action != null) {
            action.setEnabled(this.getEnableStateForSelection(this.getSelection()));
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part.equals(this.getView())) {
            this.dispose();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    protected IViewPart getView() {
        return this.fView;
    }

    protected void setView(IViewPart viewPart) {
        this.fView = viewPart;
    }

    protected void setAction(IAction action) {
        this.fAction = action;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    private void setSelection(IStructuredSelection selection) {
        this.fSelection = selection;
    }

    private IStructuredSelection getSelection() {
        return this.fSelection;
    }

    public void dispose() {
        if (this.getView() != null) {
            this.getView().getViewSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
            this.getView().getViewSite().getPage().removePartListener((IPartListener)this);
        }
    }

    protected boolean getEnableStateForSelection(IStructuredSelection selection) {
        if (selection == null || selection.size() != 1) {
            return false;
        }
        Object element = selection.getFirstElement();
        return element != null && element instanceof IDebugElement && ((IDebugElement)element).getDebugTarget().getAdapter(IExecFileInfo.class) != null;
    }

    private SortedListSelectionDialog createDialog() {
        return new SortedListSelectionDialog(this.getView().getSite().getShell(), this.fGlobals, new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object parent) {
                return AddGlobalsActionDelegate.this.getGlobals();
            }
        }, (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IGlobalVariableDescriptor) {
                    int index;
                    String path = "";
                    if (((IGlobalVariableDescriptor)element).getPath() != null && (index = (path = ((IGlobalVariableDescriptor)element).getPath().toString()).lastIndexOf(47)) != -1) {
                        path = path.substring(index + 1);
                    }
                    return String.valueOf(path.length() > 0 ? String.valueOf('\'') + path + "'::" : "") + ((IGlobalVariableDescriptor)element).getName();
                }
                return null;
            }
        }, ActionMessages.getString("AddGlobalsActionDelegate.0"));
    }

    protected IGlobalVariableDescriptor[] getGlobals() {
        return this.fGlobals;
    }

    protected void doAction(Object element) throws DebugException {
        if (this.getView() == null) {
            return;
        }
        if (element != null && element instanceof IDebugElement) {
            IExecFileInfo info = (IExecFileInfo)((IDebugElement)element).getDebugTarget().getAdapter(IExecFileInfo.class);
            ICGlobalVariableManager gvm = (ICGlobalVariableManager)((IDebugElement)element).getDebugTarget().getAdapter(ICGlobalVariableManager.class);
            if (info != null && gvm != null) {
                this.fGlobals = info.getGlobals();
                SortedListSelectionDialog dlg = this.createDialog();
                dlg.setTitle(ActionMessages.getString("AddGlobalsActionDelegate.title"));
                dlg.setInitialSelections(gvm.getDescriptors());
                if (dlg.open() == 0) {
                    List<Object> list = Arrays.asList(dlg.getResult());
                    IGlobalVariableDescriptor[] selections = list.toArray(new IGlobalVariableDescriptor[list.size()]);
                    gvm.addGlobals(selections);
                }
            }
        }
    }

    protected String getErrorDialogMessage() {
        return ActionMessages.getString("AddGlobalsActionDelegate.1");
    }

    protected void setStatus(IStatus status) {
        this.fStatus = status;
    }

    protected IStatus getStatus() {
        return this.fStatus;
    }

    public void init(IAction action) {
        super.init(action);
        IAdaptable element = DebugUITools.getDebugContext();
        this.setSelection((IStructuredSelection)(element != null ? new StructuredSelection((Object)element) : new StructuredSelection()));
        this.update(action);
    }

    class SortedListSelectionDialog
    extends ListSelectionDialog {
        public SortedListSelectionDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String message) {
            super(parentShell, input, contentProvider, labelProvider, message);
        }

        protected Control createDialogArea(Composite parent) {
            Control da = super.createDialogArea(parent);
            this.getViewer().setSorter(new ViewerSorter());
            return da;
        }
    }
}

