/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.disassembly;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.internal.ui.HTMLPrinter;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyMessages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class DisassemblyAnnotationHover
implements IAnnotationHover {
    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        List markers = this.getMarkersForLine(sourceViewer, lineNumber);
        if (markers != null) {
            if (markers.size() == 1) {
                IMarker marker = (IMarker)markers.get(0);
                String message = marker.getAttribute("message", null);
                if (message != null && message.trim().length() > 0) {
                    return this.formatSingleMessage(message);
                }
            } else {
                ArrayList<String> messages = new ArrayList<String>();
                for (IMarker marker : markers) {
                    String message = marker.getAttribute("message", null);
                    if (message == null || message.trim().length() <= 0) continue;
                    messages.add(message.trim());
                }
                if (messages.size() == 1) {
                    return this.formatSingleMessage((String)messages.get(0));
                }
                if (messages.size() > 1) {
                    return this.formatMultipleMessages(messages);
                }
            }
        }
        return null;
    }

    protected int compareRulerLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            int markerLine;
            block5: {
                try {
                    markerLine = document.getLineOfOffset(position.getOffset());
                    if (line != markerLine) break block5;
                    return 1;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (markerLine <= line && line <= document.getLineOfOffset(position.getOffset() + position.getLength())) {
                return 2;
            }
        }
        return 0;
    }

    private String formatSingleMessage(String message) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addParagraph(buffer, HTMLPrinter.convertToHTMLContent(message));
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    private String formatMultipleMessages(List messages) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addParagraph(buffer, HTMLPrinter.convertToHTMLContent(DisassemblyMessages.getString("DisassemblyAnnotationHover.Multiple_markers_at_this_line_1")));
        HTMLPrinter.startBulletList(buffer);
        Iterator e = messages.iterator();
        while (e.hasNext()) {
            HTMLPrinter.addBullet(buffer, HTMLPrinter.convertToHTMLContent((String)e.next()));
        }
        HTMLPrinter.endBulletList(buffer);
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    protected List getMarkersForLine(ISourceViewer viewer, int line) {
        IDocument document = viewer.getDocument();
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return null;
        }
        ArrayList<IMarker> exact = new ArrayList<IMarker>();
        ArrayList<IMarker> including = new ArrayList<IMarker>();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Object o = e.next();
            if (!(o instanceof MarkerAnnotation)) continue;
            MarkerAnnotation a = (MarkerAnnotation)o;
            switch (this.compareRulerLine(model.getPosition((Annotation)a), document, line)) {
                case 1: {
                    exact.add(a.getMarker());
                    break;
                }
                case 2: {
                    including.add(a.getMarker());
                }
            }
        }
        return this.select(exact, including);
    }

    protected List select(List exactMatch, List including) {
        return exactMatch;
    }
}

