/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.internal.ui.CBreakpointContext;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.PropertyDialogAction;

public class CBreakpointPropertiesAction
implements IObjectActionDelegate {
    private IWorkbenchPart fPart;
    private ICBreakpoint fContext;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fPart = targetPart;
    }

    public void run(IAction action) {
        PropertyDialogAction propertyAction = new PropertyDialogAction((IShellProvider)this.getActivePart().getSite(), new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return new StructuredSelection((Object)new CBreakpointContext(CBreakpointPropertiesAction.this.getBreakpoint(), CBreakpointPropertiesAction.this.getDebugContext()));
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        });
        propertyAction.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (ss.isEmpty() || ss.size() > 1) {
                action.setEnabled(false);
                return;
            }
            Object element = ss.getFirstElement();
            if (element instanceof ICBreakpoint) {
                action.setEnabled(true);
                this.setBreakpoint((ICBreakpoint)element);
            }
        }
    }

    protected IWorkbenchPart getActivePart() {
        return this.fPart;
    }

    protected ICBreakpoint getBreakpoint() {
        return this.fContext;
    }

    private ISelection getDebugContext() {
        return DebugUITools.getDebugContextManager().getContextService(this.fPart.getSite().getWorkbenchWindow()).getActiveContext();
    }

    protected void setBreakpoint(ICBreakpoint breakpoint) {
        this.fContext = breakpoint;
    }
}

