/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRuntimeOptions;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;

public class LocalRunLaunchDelegate
extends AbstractCLaunchDelegate {
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block19: {
            IBinaryParser.IBinaryObject exeFile = null;
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(LaunchMessages.getString("LocalRunLaunchDelegate.Launching_Local_C_Application"), 10);
            if (monitor.isCanceled()) {
                return;
            }
            try {
                monitor.worked(1);
                IPath exePath = this.verifyProgramPath(config);
                ICProject project = this.verifyCProject(config);
                if (exePath != null) {
                    exeFile = this.verifyBinary(project, exePath);
                }
                String[] arguments = this.getProgramArgumentsArray(config);
                this.setDefaultSourceLocator(launch, config);
                if (mode.equals("debug")) {
                    ICDebugConfiguration debugConfig = this.getDebugConfig(config);
                    ICDISession dsession = null;
                    String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
                    if (!debugMode.equals("run")) break block19;
                    dsession = debugConfig.createDebugger().createDebuggerSession(launch, exeFile, (IProgressMonitor)new SubProgressMonitor(monitor, 8));
                    try {
                        try {
                            ICDITarget[] dtargets = dsession.getTargets();
                            int i = 0;
                            while (i < dtargets.length) {
                                ICDIRuntimeOptions opt = dtargets[i].getRuntimeOptions();
                                opt.setArguments(arguments);
                                File wd = this.getWorkingDirectory(config);
                                if (wd != null) {
                                    opt.setWorkingDirectory(wd.getAbsolutePath());
                                }
                                opt.setEnvironment(this.getEnvironmentAsProperty(config));
                                ++i;
                            }
                        }
                        catch (CDIException e) {
                            this.abort(LaunchMessages.getString("LocalRunLaunchDelegate.Failed_setting_runtime_option_though_debugger"), e, 150);
                        }
                        monitor.worked(1);
                        boolean stopInMain = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
                        String stopSymbol = null;
                        if (stopInMain) {
                            stopSymbol = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main");
                        }
                        ICDITarget[] targets = dsession.getTargets();
                        int i = 0;
                        while (i < targets.length) {
                            Process process = targets[i].getProcess();
                            IProcess iprocess = null;
                            if (process != null) {
                                iprocess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(exePath.toOSString()), (Map)this.getDefaultProcessMap());
                            }
                            CDIDebugModel.newDebugTarget((ILaunch)launch, (IProject)project.getProject(), (ICDITarget)targets[i], (String)this.renderTargetLabel(debugConfig), (IProcess)iprocess, (IBinaryParser.IBinaryObject)exeFile, (boolean)true, (boolean)false, (String)stopSymbol, (boolean)true);
                            ++i;
                        }
                        break block19;
                    }
                    catch (CoreException e) {
                        try {
                            dsession.terminate();
                        }
                        catch (CDIException cDIException) {}
                        throw e;
                    }
                }
                File wd = this.getWorkingDirectory(config);
                if (wd == null) {
                    wd = new File(System.getProperty("user.home", "."));
                }
                ArrayList<String> command = new ArrayList<String>(1 + arguments.length);
                command.add(exePath.toOSString());
                command.addAll((Collection)Arrays.asList(arguments));
                String[] commandArray = command.toArray(new String[command.size()]);
                boolean usePty = config.getAttribute("org.eclipse.cdt.launch.use_terminal", true);
                monitor.worked(5);
                Process process = this.exec(commandArray, this.getEnvironment(config), wd, usePty);
                monitor.worked(3);
                DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(commandArray[0]));
            }
            finally {
                monitor.done();
            }
        }
    }

    protected Process exec(String[] cmdLine, String[] environ, File workingDirectory, boolean usePty) throws CoreException {
        Process p;
        block4: {
            p = null;
            try {
                p = workingDirectory == null ? ProcessFactory.getFactory().exec(cmdLine, environ) : (usePty && PTY.isSupported() ? ProcessFactory.getFactory().exec(cmdLine, environ, workingDirectory, new PTY()) : ProcessFactory.getFactory().exec(cmdLine, environ, workingDirectory));
            }
            catch (IOException e) {
                if (p != null) {
                    p.destroy();
                }
                this.abort(LaunchMessages.getString("LocalRunLaunchDelegate.Error_starting_process"), e, 150);
            }
            catch (NoSuchMethodError e) {
                Object result;
                Status status = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 100, LaunchMessages.getString("LocalRunLaunchDelegate.Does_not_support_working_dir"), (Throwable)e);
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                if (handler == null || !((result = handler.handleStatus((IStatus)status, (Object)this)) instanceof Boolean) || !((Boolean)result).booleanValue()) break block4;
                p = this.exec(cmdLine, environ, null, usePty);
            }
        }
        return p;
    }

    protected String getPluginID() {
        return LaunchUIPlugin.getUniqueIdentifier();
    }
}

