/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig2;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.List;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector2;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CCommandDSC;
import org.eclipse.cdt.make.internal.core.scannerconfig2.DefaultRunSIProvider;

public class SCDMakefileGenerator
extends DefaultRunSIProvider {
    private static final String ENDL = System.getProperty("line.separator");
    private static final String DENDL = String.valueOf(ENDL) + ENDL;

    protected boolean initialize() {
        boolean rc = super.initialize();
        if (rc) {
            this.fWorkingDirectory = MakeCorePlugin.getWorkingDirectory();
            int i = 0;
            while (i < this.fCompileArguments.length) {
                this.fCompileArguments[i] = this.fCompileArguments[i].replaceAll("\\$\\{project_name\\}", this.resource.getProject().getName());
                ++i;
            }
            rc = this.generateMakefile(this.resource.getProject().getName());
        }
        return rc;
    }

    private boolean generateMakefile(String projectName) {
        IScannerInfoCollector2 collector2;
        List commands;
        boolean rc = false;
        if (this.collector instanceof IScannerInfoCollector2 && (commands = (collector2 = (IScannerInfoCollector2)this.collector).getCollectedScannerInfo(this.resource.getProject(), ScannerInfoTypes.UNDISCOVERED_COMPILER_COMMAND)) != null && commands.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("# This is a generated file. Please do not edit.");
            buffer.append(DENDL);
            buffer.append(".PHONY: all");
            buffer.append(DENDL);
            buffer.append("COMMANDS := ");
            for (CCommandDSC cmd : commands) {
                buffer.append("\t\\" + ENDL + "\t    scd_cmd_");
                buffer.append(cmd.getCommandId());
            }
            buffer.append(DENDL);
            buffer.append("all: $(COMMANDS)");
            buffer.append(DENDL);
            for (CCommandDSC cmd : commands) {
                buffer.append("scd_cmd_");
                buffer.append(cmd.getCommandId());
                buffer.append(':');
                buffer.append(ENDL);
                buffer.append("\t@echo begin generating scanner info for $@" + ENDL + "\t");
                buffer.append(cmd.getSCDRunnableCommand(true, true));
                buffer.append(" -E -P -v -dD ");
                buffer.append(cmd.appliesToCPPFileType() ? "specs.cpp" : "specs.c");
                buffer.append(ENDL);
                buffer.append("\t@echo end generating scanner info for $@");
                buffer.append(DENDL);
            }
            File makefile = new File(this.fWorkingDirectory.toFile(), String.valueOf(projectName) + "_scd.mk");
            try {
                PrintStream ps = new PrintStream(new FileOutputStream(makefile));
                ps.println(buffer.toString());
                ps.close();
                rc = true;
            }
            catch (FileNotFoundException e) {
                MakeCorePlugin.log(e);
            }
        }
        return rc;
    }
}

