/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.TargetBuild;
import org.eclipse.cdt.make.ui.TargetListViewerPart;
import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class BuildTargetDialog
extends Dialog {
    TargetListViewerPart targetPart;
    IContainer fContainer;

    public BuildTargetDialog(Shell parent, IContainer container) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fContainer = container;
        this.targetPart = new TargetListViewerPart(this.fContainer);
    }

    public void setTarget(IMakeTarget target) {
        this.targetPart.setSelectedTarget(target);
    }

    public IMakeTarget getTarget() {
        return this.targetPart.getSelectedTarget();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MakeUIPlugin.getResourceString("BuildTargetDialog.title.buildTarget"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, MakeUIPlugin.getResourceString("BuildTargetDialog.button.build"), true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getButton(0).setEnabled(this.targetPart.getSelectedTarget() != null);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        Label title = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        title.setLayoutData((Object)gd);
        title.setText(String.valueOf(MakeUIPlugin.getResourceString("BuildTargetDialog.title.makeTargetsFor")) + this.fContainer.getFullPath().toString().substring(1));
        this.targetPart.createControl(composite, 0, 2);
        gd = (GridData)this.targetPart.getControl().getLayoutData();
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        this.targetPart.getControl().setLayoutData((Object)gd);
        this.targetPart.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BuildTargetDialog.this.okPressed();
            }
        });
        this.targetPart.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BuildTargetDialog.this.getButton(0).setEnabled(BuildTargetDialog.this.targetPart.getSelectedTarget() != null);
            }
        });
        return composite;
    }

    protected void okPressed() {
        IMakeTarget selected = this.targetPart.getSelectedTarget();
        super.okPressed();
        if (selected != null) {
            TargetBuild.buildTargets(this.getParentShell(), new IMakeTarget[]{selected});
        }
    }
}

