/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.views;

import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.ui.MakeUIImages;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.IMakeHelpContextIds;
import org.eclipse.cdt.make.ui.MakeContentProvider;
import org.eclipse.cdt.make.ui.MakeLabelProvider;
import org.eclipse.cdt.make.ui.views.AddTargetAction;
import org.eclipse.cdt.make.ui.views.BuildTargetAction;
import org.eclipse.cdt.make.ui.views.DeleteTargetAction;
import org.eclipse.cdt.make.ui.views.EditTargetAction;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class MakeView
extends ViewPart {
    private BuildTargetAction buildTargetAction;
    private EditTargetAction editTargetAction;
    private DeleteTargetAction deleteTargetAction;
    AddTargetAction addTargetAction;
    TreeViewer fViewer;
    DrillDownAdapter drillDownAdapter;
    private Action trimEmptyFolderAction;

    public void setFocus() {
        this.fViewer.getTree().setFocus();
    }

    public void createPartControl(Composite parent) {
        MakeUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)parent, IMakeHelpContextIds.MAKE_VIEW);
        this.fViewer = new TreeViewer(parent, 770);
        this.fViewer.setUseHashlookup(true);
        this.fViewer.setContentProvider((IContentProvider)new MakeContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new MakeLabelProvider());
        this.drillDownAdapter = new DrillDownAdapter(this.fViewer);
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MakeView.this.handleDoubleClick(event);
            }
        });
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MakeView.this.handleSelectionChanged(event);
            }
        });
        this.fViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    MakeView.this.handleDeleteKeyPressed();
                }
            }
        });
        this.fViewer.setContentProvider((IContentProvider)new MakeContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new MakeLabelProvider());
        this.fViewer.setSorter(new ViewerSorter(){

            public int category(Object element) {
                if (element instanceof IResource) {
                    return 0;
                }
                return 1;
            }
        });
        this.fViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    IDialogSettings getSettings() {
        IDialogSettings settings = MakeUIPlugin.getDefault().getDialogSettings().getSection("org.eclipse.cdt.internal.ui.MakeView");
        if (settings == null) {
            settings = MakeUIPlugin.getDefault().getDialogSettings().addNewSection("org.eclipse.cdt.internal.ui.MakeView");
        }
        return settings;
    }

    private void makeActions() {
        this.buildTargetAction = new BuildTargetAction(this.fViewer.getControl().getShell());
        this.addTargetAction = new AddTargetAction(this.fViewer.getControl().getShell());
        this.deleteTargetAction = new DeleteTargetAction(this.fViewer.getControl().getShell());
        this.editTargetAction = new EditTargetAction(this.fViewer.getControl().getShell());
        this.trimEmptyFolderAction = new FilterEmtpyFoldersAction();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager toolBar) {
        this.drillDownAdapter.addNavigationActions(toolBar);
        toolBar.add((IAction)this.buildTargetAction);
        toolBar.add((IAction)this.trimEmptyFolderAction);
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MakeView.this.fillContextMenu(manager);
                MakeView.this.updateActions((IStructuredSelection)MakeView.this.fViewer.getSelection());
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.buildTargetAction);
        manager.add((IAction)this.addTargetAction);
        manager.add((IAction)this.deleteTargetAction);
        manager.add((IAction)this.editTargetAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    protected void handleDeleteKeyPressed() {
        this.deleteTargetAction.run();
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        this.buildTargetAction.run();
    }

    void handleSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        this.updateActions(sel);
    }

    void updateActions(IStructuredSelection sel) {
        this.addTargetAction.selectionChanged(sel);
        this.buildTargetAction.selectionChanged(sel);
        this.deleteTargetAction.selectionChanged(sel);
        this.editTargetAction.selectionChanged(sel);
    }

    protected class FilterEmtpyFoldersAction
    extends Action {
        private static final String FILTER_EMPTY_FOLDERS = "FilterEmptyFolders";

        public FilterEmtpyFoldersAction() {
            super(MakeUIPlugin.getResourceString("FilterEmptyFolderAction.label"), 2);
            this.setToolTipText(MakeUIPlugin.getResourceString("FilterEmptyFolderAction.tooltip"));
            this.setChecked(MakeView.this.getSettings().getBoolean(FILTER_EMPTY_FOLDERS));
            MakeUIImages.setImageDescriptors((IAction)this, "tool16", MakeUIImages.IMG_TOOLS_MAKE_TARGET_FILTER);
            MakeView.this.fViewer.addFilter(new ViewerFilter(){

                private boolean hasMakeTargets(IFolder container) throws CoreException {
                    IMakeTarget[] targets = MakeCorePlugin.getDefault().getTargetManager().getTargets((IContainer)container);
                    if (targets != null && targets.length > 0) {
                        return true;
                    }
                    final boolean[] haveTargets = new boolean[]{false};
                    IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) throws CoreException {
                            if (haveTargets[0]) {
                                return false;
                            }
                            if (proxy.getType() != 2) {
                                return true;
                            }
                            IFolder folder = (IFolder)proxy.requestResource();
                            IMakeTarget[] targets = MakeCorePlugin.getDefault().getTargetManager().getTargets((IContainer)folder);
                            if (targets != null && targets.length > 0) {
                                haveTargets[0] = true;
                                return false;
                            }
                            return true;
                        }
                    };
                    container.accept(visitor, 0);
                    return haveTargets[0];
                }

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (FilterEmtpyFoldersAction.this.isChecked() && element instanceof IFolder) {
                        try {
                            return this.hasMakeTargets((IFolder)element);
                        }
                        catch (Exception exception) {
                            return false;
                        }
                    }
                    return true;
                }
            });
        }

        public void run() {
            MakeView.this.fViewer.refresh();
            MakeView.this.getSettings().put(FILTER_EMPTY_FOLDERS, this.isChecked());
        }
    }
}

