/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.testplugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import junit.framework.Assert;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class BuildSystemTestHelper {
    public static IProject createProject(String name, IPath location, String projTypeId) throws CoreException {
        IProject project = BuildSystemTestHelper.createProject(name, location);
        return BuildSystemTestHelper.createDescription(project, projTypeId);
    }

    public static IProject createDescription(IProject project, String projTypeId) throws CoreException {
        CoreModel coreModel = CoreModel.getDefault();
        ICProjectDescription des = coreModel.getProjectDescription(project);
        Assert.assertNull((String)"detDescription1 returned not null!", (Object)des);
        des = coreModel.createProjectDescription(project, true);
        Assert.assertNotNull((String)"createDescription returned null!", (Object)des);
        Assert.assertNull((String)"detDescription2 returned not null!", (Object)coreModel.getProjectDescription(project));
        Assert.assertFalse((String)"new des should be not valid", (boolean)des.isValid());
        Assert.assertEquals((int)0, (int)des.getConfigurations().length);
        ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)project);
        IProjectType type = ManagedBuildManager.getProjectType((String)projTypeId);
        Assert.assertNotNull((String)"project type not found", (Object)type);
        ManagedProject mProj = new ManagedProject((IResource)project, type);
        info.setManagedProject((IManagedProject)mProj);
        IConfiguration[] cfgs = type.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            String id = ManagedBuildManager.calculateChildId((String)cfgs[i].getId(), null);
            Configuration config = new Configuration(mProj, (Configuration)cfgs[i], id, false, true, false);
            CConfigurationData data = config.getConfigurationData();
            Assert.assertNotNull((String)"data is null for created configuration", (Object)data);
            des.createConfiguration(ManagedBuildManager.CFG_DATA_PROVIDER_ID, data);
            ++i;
        }
        coreModel.setProjectDescription(project, des);
        return project;
    }

    public static IProject createProject(String name) throws CoreException {
        return BuildSystemTestHelper.createProject(name, null);
    }

    public static IProject createProject(String name, IPath location) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        final IProject newProjectHandle = root.getProject(name);
        IProject project = null;
        if (!newProjectHandle.exists()) {
            IWorkspaceDescription workspaceDesc = workspace.getDescription();
            workspaceDesc.setAutoBuilding(false);
            workspace.setDescription(workspaceDesc);
            IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
            if (location != null) {
                description.setLocation(location);
            }
            project = CCorePlugin.getDefault().createCDTProject(description, newProjectHandle, (IProgressMonitor)new NullProgressMonitor());
        } else {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    newProjectHandle.refreshLocal(2, monitor);
                }
            };
            NullProgressMonitor monitor = new NullProgressMonitor();
            workspace.run(runnable, (ISchedulingRule)root, 1, (IProgressMonitor)monitor);
            project = newProjectHandle;
        }
        if (!project.isOpen()) {
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        return project;
    }

    public static void checkDiff(Object[] arr1, Object[] arr2) {
        LinkedHashSet set1 = new LinkedHashSet(Arrays.asList(arr1));
        LinkedHashSet set2 = new LinkedHashSet(Arrays.asList(arr2));
        LinkedHashSet set1Copy = new LinkedHashSet(set1);
        set1.removeAll(set2);
        set2.removeAll(set1Copy);
        String set1String = BuildSystemTestHelper.collectionToString(set1);
        String set2String = BuildSystemTestHelper.collectionToString(set2);
        String diffMsg = "array1 entries: " + set1String + ",\n array2 entries: " + set2String + "\n";
        Assert.assertEquals((String)("arrays have different size\n" + diffMsg), (int)arr1.length, (int)arr2.length);
        Assert.assertEquals((String)("arrays have different contents\n" + diffMsg), (int)0, (int)set1.size());
        Assert.assertEquals((String)("arrays have different contents\n" + diffMsg), (int)0, (int)set2.size());
        if (!Arrays.equals(arr1, arr2)) {
            Assert.fail((String)("different element order, dumping..\n array1 entries: " + BuildSystemTestHelper.arrayToString(arr1) + "\n array2 entries: " + BuildSystemTestHelper.arrayToString(arr2) + "\n"));
        }
    }

    public static String collectionToString(Collection c) {
        return BuildSystemTestHelper.arrayToString(c.toArray());
    }

    public static String arrayToString(Object[] arr) {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        int i = 0;
        while (i < arr.length) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(arr[i].toString());
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }
}

