/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceInfo;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ConflictSet;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.DbgTcmUtil;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.Messages;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PathComparator;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PerTypeMapStorage;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PerTypeSetStorage;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.TcModificationUtil;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ToolChainModificationManager;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ToolListModification;
import org.eclipse.cdt.managedbuilder.tcmodification.CompatibilityStatus;
import org.eclipse.cdt.managedbuilder.tcmodification.IFolderInfoModification;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class FolderInfoModification
extends ToolListModification
implements IFolderInfoModification {
    private ToolChain fRealToolChain;
    private ToolChainCompatibilityInfoElement fCurrentCompatibilityInfo;
    private ToolChain fSelectedToolChain;
    private IToolChain[] fAllSysToolChains;
    private Map fCompatibleToolChains;
    private Map fInCompatibleToolChains;
    private PerTypeMapStorage fParentObjectStorage;
    private ToolChainModificationManager.ConflictMatchSet fParentConflicts;
    private boolean fCompatibilityInfoInited;
    private ToolChainApplicabilityPaths fTcApplicabilityPaths;

    public FolderInfoModification(FolderInfo foInfo) {
        super((ResourceInfo)foInfo, foInfo.getTools());
        this.fSelectedToolChain = (ToolChain)foInfo.getToolChain();
        this.fRealToolChain = (ToolChain)ManagedBuildManager.getRealToolChain(this.fSelectedToolChain);
    }

    public FolderInfoModification(FolderInfo foInfo, FolderInfoModification base) {
        super((ResourceInfo)foInfo, base);
        this.fSelectedToolChain = base.fSelectedToolChain;
        if (!this.fSelectedToolChain.isExtensionElement()) {
            this.fSelectedToolChain = (ToolChain)this.fSelectedToolChain.getExtensionObject();
        }
        this.fRealToolChain = base.fRealToolChain;
    }

    private ToolChainModificationManager.ConflictMatchSet getParentConflictMatchSet() {
        if (this.fParentConflicts == null) {
            PerTypeMapStorage storage = this.getParentObjectStorage();
            this.fParentConflicts = ToolChainModificationManager.getInstance().getConflictInfo(1, storage);
        }
        return this.fParentConflicts;
    }

    private PerTypeMapStorage getParentObjectStorage() {
        if (this.fParentObjectStorage == null) {
            this.fParentObjectStorage = TcModificationUtil.createParentObjectsRealToolToPathSet((FolderInfo)this.getResourceInfo());
        }
        return this.fParentObjectStorage;
    }

    private IToolChain[] getAllSysToolChains() {
        if (this.fAllSysToolChains == null) {
            this.fAllSysToolChains = ManagedBuildManager.getRealToolChains();
        }
        return this.fAllSysToolChains;
    }

    public IToolChain[] getCompatibleToolChains() {
        this.initCompatibilityInfo();
        FolderInfo foInfo = (FolderInfo)this.getResourceInfo();
        ArrayList<ToolChain> l = new ArrayList<ToolChain>(this.fCompatibleToolChains.size());
        for (ToolChain tc : this.fCompatibleToolChains.keySet()) {
            if (tc == this.fRealToolChain || !foInfo.isToolChainCompatible(this.fRealToolChain, tc)) continue;
            l.add(tc);
        }
        return l.toArray(new ToolChain[l.size()]);
    }

    public CompatibilityStatus getToolChainCompatibilityStatus() {
        return this.getCurrentCompatibilityInfo().getCompatibilityStatus();
    }

    private ToolChainCompatibilityInfoElement getCurrentCompatibilityInfo() {
        if (this.fCurrentCompatibilityInfo == null) {
            this.initCompatibilityInfo();
            ToolChainCompatibilityInfoElement info = (ToolChainCompatibilityInfoElement)this.fCompatibleToolChains.get(this.fRealToolChain);
            if (info == null) {
                info = (ToolChainCompatibilityInfoElement)this.fInCompatibleToolChains.get(this.fRealToolChain);
            }
            this.fCurrentCompatibilityInfo = info;
        }
        return this.fCurrentCompatibilityInfo;
    }

    public boolean isToolChainCompatible() {
        return this.getCurrentCompatibilityInfo().isCompatible();
    }

    private void initCompatibilityInfo() {
        if (this.fCompatibilityInfoInited) {
            return;
        }
        this.fCompatibleToolChains = new HashMap();
        this.fInCompatibleToolChains = new HashMap();
        ToolChainModificationManager.ConflictMatchSet parentConflicts = this.getParentConflictMatchSet();
        ToolChain[] sysTCs = (ToolChain[])this.getAllSysToolChains();
        Map conflictMap = parentConflicts.fObjToConflictListMap;
        int i = 0;
        while (i < sysTCs.length) {
            ToolChain tc = sysTCs[i];
            List l = (List)conflictMap.get(tc);
            ToolChainCompatibilityInfoElement info = new ToolChainCompatibilityInfoElement(tc, l);
            if (info.isCompatible()) {
                this.fCompatibleToolChains.put(tc, info);
            } else {
                this.fInCompatibleToolChains.put(tc, info);
            }
            ++i;
        }
        this.fCompatibilityInfoInited = true;
    }

    public IToolChain getToolChain() {
        return this.fSelectedToolChain;
    }

    public final void setToolChain(IToolChain tc) {
        this.setToolChain(tc, false);
    }

    public void setToolChain(IToolChain tc, boolean force) {
        if (tc == this.fSelectedToolChain && !force) {
            return;
        }
        this.applyToolChain((ToolChain)tc);
        this.fSelectedToolChain = (ToolChain)tc;
        IToolChain newReal = ManagedBuildManager.getRealToolChain(tc);
        if (newReal == this.fRealToolChain && !force) {
            return;
        }
        this.fRealToolChain = (ToolChain)newReal;
        this.clearToolInfo(tc.getTools());
        this.fCurrentCompatibilityInfo = null;
    }

    protected void clearToolChainCompatibilityInfo() {
        this.fCompatibilityInfoInited = false;
        this.fCompatibleToolChains = null;
        this.fInCompatibleToolChains = null;
        this.fCurrentCompatibilityInfo = null;
    }

    protected boolean canRemove(ITool realTool) {
        IToolChain extTc = ManagedBuildManager.getExtensionToolChain(this.fSelectedToolChain);
        ITool[] tools = extTc.getTools();
        int i = 0;
        while (i < tools.length) {
            if (realTool == ManagedBuildManager.getRealTool(tools[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean canAdd(Tool tool) {
        return !TcModificationUtil.containCommonEntries(this.getInputExtsSet(), tool.getPrimaryInputExtensions());
    }

    protected boolean canReplace(Tool fromTool, Tool toTool) {
        String[] exts = toTool.getPrimaryInputExtensions();
        HashSet curInputExts = null;
        Set inputExts = this.getInputExtsSet();
        int k = 0;
        while (k < exts.length) {
            if (inputExts.contains(exts[k])) {
                if (curInputExts == null) {
                    curInputExts = new HashSet(Arrays.asList(fromTool.getPrimaryInputExtensions()));
                }
                if (curInputExts.contains(exts[k])) {
                    return true;
                }
            }
            ++k;
        }
        return false;
    }

    protected Set getExtensionConflictToolSet(Tool tool, Tool[] tools) {
        String[] exts = tool.getPrimaryInputExtensions();
        HashSet extsSet = new HashSet(Arrays.asList(exts));
        HashSet<Tool> conflictsSet = null;
        int i = 0;
        while (i < tools.length) {
            Tool t = tools[i];
            if (t != tool && TcModificationUtil.containCommonEntries(extsSet, t.getPrimaryInputExtensions())) {
                if (conflictsSet == null) {
                    conflictsSet = new HashSet<Tool>();
                }
                conflictsSet.add(t);
            }
            ++i;
        }
        if (conflictsSet == null) {
            conflictsSet = Collections.EMPTY_SET;
        }
        return conflictsSet;
    }

    protected Set getToolApplicabilityPathSet(Tool realTool, boolean isProject) {
        if (isProject) {
            return (Set)this.getToolChainApplicabilityPaths().fToolPathMap.get(realTool);
        }
        return this.getToolChainApplicabilityPaths().fFolderInfoPaths;
    }

    protected Tool[] filterTools(Tool[] tools) {
        IResourceInfo rcInfo = this.getResourceInfo();
        return (Tool[])((FolderInfo)rcInfo).filterTools(tools, rcInfo.getParent().getManagedProject());
    }

    private ToolChainApplicabilityPaths getToolChainApplicabilityPaths() {
        this.initToolChainApplicabilityPaths();
        return this.fTcApplicabilityPaths;
    }

    private void initToolChainApplicabilityPaths() {
        if (this.fTcApplicabilityPaths != null) {
            return;
        }
        ToolChainApplicabilityPaths tcApplicabilityPaths = new ToolChainApplicabilityPaths();
        IPath path = this.getResourceInfo().getPath();
        TreeMap pathMap = this.getCompletePathMapStorage();
        PerTypeSetStorage oSet = (PerTypeSetStorage)pathMap.get(path);
        Set toolSet = oSet.getSet(2, false);
        Set tcSet = oSet.getSet(1, false);
        ToolChain curTc = (ToolChain)tcSet.iterator().next();
        Set foInfoPaths = tcApplicabilityPaths.fFolderInfoPaths;
        Set fileInfoPaths = tcApplicabilityPaths.fFileInfoPaths;
        foInfoPaths.add(path);
        Map toolPathsMap = tcApplicabilityPaths.fToolPathMap;
        if (toolSet != null) {
            Iterator iter = toolSet.iterator();
            while (iter.hasNext()) {
                HashSet<IPath> set = new HashSet<IPath>();
                toolPathsMap.put(iter.next(), set);
                set.add(path);
            }
        }
        FolderInfoModification.calculateChildPaths(pathMap, path, curTc, foInfoPaths, toolPathsMap, fileInfoPaths);
        this.fTcApplicabilityPaths = tcApplicabilityPaths;
    }

    protected void clearToolInfo(ITool[] tools) {
        super.clearToolInfo(tools);
        this.fTcApplicabilityPaths = null;
    }

    private static void putToolInfo(Set ct, Map toolPathsMap, Set fileInfoPaths, Object p) {
        if (ct != null && ct.size() != 0) {
            for (Object t : ct) {
                Set set = (Set)toolPathsMap.get(t);
                if (set == null) continue;
                if (fileInfoPaths != null) {
                    fileInfoPaths.add(p);
                }
                set.add(p);
            }
        }
    }

    private static void calculateChildPaths(TreeMap pathMap, IPath path, ToolChain tc, Set tcPaths, Map toolPathsMap, Set fileInfoPaths) {
        SortedMap directCMap = PathComparator.getDirectChildPathMap(pathMap, path);
        for (Map.Entry entry : directCMap.entrySet()) {
            PerTypeSetStorage cst = (PerTypeSetStorage)entry.getValue();
            Set ctc = cst.getSet(1, false);
            Set ct = cst.getSet(2, false);
            if (ctc == null || ctc.size() == 0) {
                FolderInfoModification.putToolInfo(ct, toolPathsMap, fileInfoPaths, entry.getKey());
                continue;
            }
            if (!ctc.contains(tc)) continue;
            IPath cp = (IPath)entry.getKey();
            tcPaths.add(cp);
            FolderInfoModification.putToolInfo(ct, toolPathsMap, null, entry.getKey());
            FolderInfoModification.calculateChildPaths(pathMap, cp, tc, tcPaths, toolPathsMap, fileInfoPaths);
        }
    }

    private void applyToolChain(ToolChain newNonRealTc) {
        ToolChain newRealTc = (ToolChain)ManagedBuildManager.getRealToolChain(newNonRealTc);
        ToolChainApplicabilityPaths tcApplicability = this.getToolChainApplicabilityPaths();
        PerTypeMapStorage storage = this.getCompleteObjectStore();
        Map tcMap = storage.getMap(1, false);
        Map toolMap = storage.getMap(2, false);
        TcModificationUtil.removePaths(tcMap, this.fRealToolChain, tcApplicability.fFolderInfoPaths);
        TcModificationUtil.addPaths(tcMap, newRealTc, tcApplicability.fFolderInfoPaths);
        ITool[] newTools = (Tool[])newNonRealTc.getTools();
        int i = 0;
        while (i < newTools.length) {
            newTools[i] = (Tool)ManagedBuildManager.getRealTool(newTools[i]);
            ++i;
        }
        for (Map.Entry entry : tcApplicability.fToolPathMap.entrySet()) {
            Tool tool = (Tool)entry.getKey();
            Set pathSet = (Set)entry.getValue();
            TcModificationUtil.removePaths(toolMap, tool, pathSet);
        }
        i = 0;
        while (i < newTools.length) {
            TcModificationUtil.addPaths(toolMap, newTools[i], tcApplicability.fFolderInfoPaths);
            ++i;
        }
        if (tcApplicability.fFileInfoPaths.size() != 0) {
            FolderInfo foInfo = (FolderInfo)this.getResourceInfo();
            IManagedProject mProj = foInfo.getParent().getManagedProject();
            IProject project = mProj.getOwner().getProject();
            Tool[] filtered = (Tool[])foInfo.filterTools(newTools, mProj);
            if (filtered.length != 0) {
                for (IPath p : tcApplicability.fFileInfoPaths) {
                    boolean found = false;
                    String ext = p.getFileExtension();
                    if (ext == null) {
                        ext = "";
                    }
                    int i2 = 0;
                    while (i2 < filtered.length) {
                        if (filtered[i2].buildsFileType(ext, project)) {
                            TcModificationUtil.addPath(toolMap, filtered[i2], p);
                            found = true;
                            break;
                        }
                        ++i2;
                    }
                    if (found || !DbgTcmUtil.DEBUG) continue;
                    DbgTcmUtil.println("no tools found for path " + p);
                }
            } else if (DbgTcmUtil.DEBUG) {
                DbgTcmUtil.println("no filtered tools");
            }
        }
    }

    private IToolChain getDefaultToolChain() {
        IResourceInfo rcInfo = this.getResourceInfo();
        IToolChain defaultTc = null;
        if (rcInfo.getPath().segmentCount() == 0) {
            IConfiguration cfg = rcInfo.getParent();
            IConfiguration extCfg = cfg.getParent();
            defaultTc = extCfg.getToolChain();
            if (defaultTc == null && cfg.getToolChain() != null) {
                defaultTc = cfg.getToolChain().getSuperClass();
            }
        } else {
            IFolderInfo parentFo = ((ResourceInfo)rcInfo).getParentFolderInfo();
            IToolChain tc = parentFo.getToolChain();
            defaultTc = ManagedBuildManager.getExtensionToolChain(tc);
        }
        if (defaultTc != null && defaultTc.getId().equals("org.eclipse.cdt.build.core.prefbase.toolchain")) {
            defaultTc = null;
        }
        return defaultTc;
    }

    public final void restoreDefaults() {
        IToolChain tc = this.getDefaultToolChain();
        if (tc != null) {
            this.setToolChain(tc, true);
        }
    }

    private static class ToolChainApplicabilityPaths {
        private Set fFileInfoPaths = new HashSet();
        private Set fFolderInfoPaths = new HashSet();
        private Map fToolPathMap = new HashMap();

        private ToolChainApplicabilityPaths() {
        }
    }

    public static class ToolChainCompatibilityInfoElement {
        private ToolChain fTc;
        private List fErrComflictMatchList;
        private List fWarningConflictMatchList;
        private CompatibilityStatus fStatus;

        ToolChainCompatibilityInfoElement(ToolChain tc, List errConflictList) {
            this.fTc = tc;
            if (errConflictList != null && errConflictList.size() != 0) {
                this.fErrComflictMatchList = errConflictList;
            }
        }

        public CompatibilityStatus getCompatibilityStatus() {
            if (this.fStatus == null) {
                String message;
                int severity;
                if (this.fErrComflictMatchList != null) {
                    severity = 4;
                    message = Messages.getString("FolderInfoModification.0");
                } else {
                    severity = 0;
                    message = "";
                }
                this.fStatus = new CompatibilityStatus(severity, message, new ConflictSet(this.fTc, this.fErrComflictMatchList, null));
            }
            return this.fStatus;
        }

        public boolean isCompatible() {
            return this.fErrComflictMatchList == null;
        }
    }
}

