/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import org.eclipse.cdt.core.settings.model.MultiItemsHolder;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.OptionStringValue;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceInfo;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PluginVersionIdentifier;

public abstract class MultiResourceInfo
extends MultiItemsHolder
implements IResourceInfo {
    private static final int MODE_BOOL = 0;
    private static final int MODE_STR = 1;
    private static final int MODE_SAR = 2;
    private static final int MODE_OSV = 3;
    private static final int MODE_CMDLINE = 4;
    private static final int MODE_COMMAND = 5;
    protected IResourceInfo[] fRis = null;
    protected int curr = 0;
    IConfiguration parent = null;

    public MultiResourceInfo(IResourceInfo[] ris, IConfiguration _parent) {
        this.fRis = ris;
        this.parent = _parent;
        int i = 0;
        while (i < this.fRis.length) {
            Configuration cfg;
            if (this.fRis[i].getParent() instanceof Configuration && (cfg = (Configuration)this.fRis[i].getParent()).getConfigurationDescription().isActive()) {
                this.curr = i;
                break;
            }
            ++i;
        }
    }

    public boolean canExclude(boolean exclude) {
        int i = 0;
        while (i < this.fRis.length) {
            if (!this.fRis[i].canExclude(exclude)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public CLanguageData[] getCLanguageDatas() {
        return this.fRis[this.curr].getCLanguageDatas();
    }

    public int getKind() {
        return this.fRis[this.curr].getKind();
    }

    public IConfiguration getParent() {
        return this.parent;
    }

    public IPath getPath() {
        return this.fRis[this.curr].getPath();
    }

    public CResourceData getResourceData() {
        System.out.println("Strange call: MultiResourceInfo.getResourceData()");
        return this.fRis[this.curr].getResourceData();
    }

    public ITool[] getTools() {
        return this.fRis[this.curr].getTools();
    }

    public boolean isDirty() {
        int i = 0;
        while (i < this.fRis.length) {
            if (this.fRis[i].isDirty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isExcluded() {
        int i = 0;
        while (i < this.fRis.length) {
            if (this.fRis[i].isExcluded()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isExtensionElement() {
        int i = 0;
        while (i < this.fRis.length) {
            if (this.fRis[i].isExtensionElement()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isSupported() {
        int i = 0;
        while (i < this.fRis.length) {
            if (this.fRis[i].isSupported()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isValid() {
        int i = 0;
        while (i < this.fRis.length) {
            if (!this.fRis[i].isValid()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean needsRebuild() {
        int i = 0;
        while (i < this.fRis.length) {
            if (this.fRis[i].needsRebuild()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setDirty(boolean dirty) {
        int i = 0;
        while (i < this.fRis.length) {
            this.fRis[i].setDirty(dirty);
            ++i;
        }
    }

    public void setExclude(boolean excluded) {
        int i = 0;
        while (i < this.fRis.length) {
            this.fRis[i].setExclude(excluded);
            ++i;
        }
    }

    private String getSuperClassId(IOption op) {
        String s = null;
        while (op != null) {
            s = op.getId();
            op = op.getSuperClass();
        }
        return s;
    }

    public void setToolsCommand(ITool tool, String s) {
        this.setTool(tool, s, 5);
    }

    public void setCommandLinePattern(ITool tool, String s) {
        this.setTool(tool, s, 4);
    }

    private void setTool(ITool tool, String s, int mode) {
        String ext = tool.getDefaultInputExtension();
        int i = 0;
        while (i < this.fRis.length) {
            ITool[] ts = this.fRis[i].getTools();
            int j = 0;
            while (j < ts.length) {
                if (ext == null || ext.equals(ts[j].getDefaultInputExtension())) {
                    switch (mode) {
                        case 5: {
                            ts[j].setToolCommand(s);
                            break;
                        }
                        case 4: {
                            ts[j].setCommandLinePattern(s);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private IOption setOption(IHoldsOptions parent, IOption option, Object value, int mode) throws BuildException {
        IOption op = null;
        String ext = parent instanceof ITool ? ((ITool)parent).getDefaultInputExtension() : null;
        String sid = this.getSuperClassId(option);
        int i = 0;
        while (i < this.fRis.length) {
            ITool[] ts = this.fRis[i].getTools();
            int j = 0;
            while (j < ts.length) {
                IOption op2;
                if ((ext == null || ext.equals(ts[j].getDefaultInputExtension())) && (op2 = ts[j].getOptionBySuperClassId(sid)) != null) {
                    switch (mode) {
                        case 0: {
                            op = this.fRis[i].setOption((IHoldsOptions)ts[j], op2, (Boolean)value);
                            break;
                        }
                        case 1: {
                            op = this.fRis[i].setOption((IHoldsOptions)ts[j], op2, (String)value);
                            break;
                        }
                        case 2: {
                            op = this.fRis[i].setOption((IHoldsOptions)ts[j], op2, (String[])value);
                            break;
                        }
                        case 3: {
                            op = this.fRis[i].setOption((IHoldsOptions)ts[j], op2, (OptionStringValue[])value);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return op;
    }

    public IOption setOption(IHoldsOptions parent, IOption option, boolean value) throws BuildException {
        return this.setOption(parent, option, new Boolean(value), 0);
    }

    public IOption setOption(IHoldsOptions parent, IOption option, String value) throws BuildException {
        return this.setOption(parent, option, value, 1);
    }

    public IOption setOption(IHoldsOptions parent, IOption option, String[] value) throws BuildException {
        return this.setOption(parent, option, value, 2);
    }

    public IOption setOption(IHoldsOptions parent, IOption option, OptionStringValue[] value) throws BuildException {
        return this.setOption(parent, option, value, 3);
    }

    public void setPath(IPath path) {
        int i = 0;
        while (i < this.fRis.length) {
            this.fRis[i].setPath(path);
            ++i;
        }
    }

    public void setRebuildState(boolean rebuild) {
        int i = 0;
        while (i < this.fRis.length) {
            this.fRis[i].setRebuildState(rebuild);
            ++i;
        }
    }

    public boolean supportsBuild(boolean managed) {
        return this.fRis[this.curr].supportsBuild(managed);
    }

    public String getBaseId() {
        return this.fRis[this.curr].getBaseId();
    }

    public String getId() {
        return this.fRis[this.curr].getId();
    }

    public String getManagedBuildRevision() {
        return this.fRis[this.curr].getManagedBuildRevision();
    }

    public String getName() {
        return this.fRis[this.curr].getName();
    }

    public PluginVersionIdentifier getVersion() {
        return this.fRis[this.curr].getVersion();
    }

    public void setVersion(PluginVersionIdentifier version) {
        int i = 0;
        while (i < this.fRis.length) {
            this.fRis[i].setVersion(version);
            ++i;
        }
    }

    public Object[] getItems() {
        return this.fRis;
    }

    public boolean isRoot() {
        return ((ResourceInfo)this.fRis[this.curr]).isRoot();
    }
}

