/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.scannerconfig;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.cdt.build.internal.core.scannerconfig2.CfgScannerConfigProfileManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.make.core.scannerconfig.IExternalScannerInfoProvider;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.scannerconfig.IManagedScannerInfoCollector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;

public class ManagedBuildCPathEntryContainer
implements IPathEntryContainer {
    public static final String MM_PP_DISCOVERY_PROFILE_ID = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".GCCManagedMakePerProjectProfile";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String ERROR_HEADER = "PathEntryContainer error [";
    private static final String TRACE_FOOTER = "]: ";
    private static final String TRACE_HEADER = "PathEntryContainer trace [";
    private ITarget defaultTarget;
    private Vector entries;
    private IProject project;
    private ManagedBuildInfo info;
    public static boolean VERBOSE = false;

    public static void outputTrace(String resourceName, String message) {
        if (VERBOSE) {
            System.out.println(TRACE_HEADER + resourceName + TRACE_FOOTER + message + NEWLINE);
        }
    }

    public static void outputError(String resourceName, String message) {
        if (VERBOSE) {
            System.err.println(ERROR_HEADER + resourceName + TRACE_FOOTER + message + NEWLINE);
        }
    }

    public ManagedBuildCPathEntryContainer(IProject project) {
        this.project = project;
        this.entries = new Vector();
    }

    protected void addDefinedSymbols(Map definedSymbols) {
        Iterator keyIter = definedSymbols.keySet().iterator();
        while (keyIter.hasNext()) {
            boolean add = true;
            String macro = (String)keyIter.next();
            String value = (String)definedSymbols.get(macro);
            Iterator entryIter = this.entries.listIterator();
            while (entryIter.hasNext()) {
                IPathEntry entry = (IPathEntry)entryIter.next();
                if (entry.getEntryKind() != 64 || !((IMacroEntry)entry).getMacroName().equals(macro) || !((IMacroEntry)entry).getMacroValue().equals(value)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            this.entries.add(CoreModel.newMacroEntry((IPath)Path.EMPTY, (String)macro, (String)value));
        }
    }

    protected void addIncludePaths(List paths) {
        Iterator pathIter = paths.listIterator();
        while (pathIter.hasNext()) {
            String path = (String)pathIter.next();
            IIncludeEntry entry = CoreModel.newIncludeEntry((IPath)Path.EMPTY, (IPath)Path.EMPTY, (IPath)new Path(path), (boolean)true);
            if (this.entries.contains(entry)) continue;
            this.entries.add(entry);
        }
    }

    protected void calculateEntriesDynamically(final IProject project, SCProfileInstance profileInstance, final IScannerInfoCollector collector) {
        final IScannerConfigBuilderInfo2 buildInfo = ScannerConfigProfileManager.createScannerConfigBuildInfo2((Preferences)ManagedBuilderCorePlugin.getDefault().getPluginPreferences(), (String)profileInstance.getProfile().getId(), (boolean)false);
        List providerIds = buildInfo.getProviderIdList();
        for (final String providerId : providerIds) {
            final IExternalScannerInfoProvider esiProvider = profileInstance.createExternalScannerInfoProvider(providerId);
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() {
                    NullProgressMonitor monitor = new NullProgressMonitor();
                    IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
                    IConfiguration config = info.getDefaultConfiguration();
                    IBuildEnvironmentVariable[] vars = ManagedBuildManager.getEnvironmentVariableProvider().getVariables(config, true, true);
                    Properties env = new Properties();
                    if (vars != null) {
                        int i = 0;
                        while (i < vars.length) {
                            env.put(vars[i].getName(), vars[i].getValue());
                            ++i;
                        }
                    }
                    esiProvider.invokeProvider((IProgressMonitor)monitor, (IResource)project, providerId, buildInfo, collector);
                }

                public void handleException(Throwable exception) {
                    if (exception instanceof OperationCanceledException) {
                        throw (OperationCanceledException)exception;
                    }
                }
            };
            Platform.run((ISafeRunnable)runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPathEntry[] getPathEntries() {
        this.info = (ManagedBuildInfo)ManagedBuildManager.getBuildInfo((IResource)this.project);
        if (this.info == null) {
            ManagedBuildCPathEntryContainer.outputError(this.project.getName(), "Build information is null");
            return this.entries.toArray(new IPathEntry[this.entries.size()]);
        }
        IConfiguration defaultConfig = this.info.getDefaultConfiguration();
        if (defaultConfig == null) {
            ManagedBuildCPathEntryContainer.outputError(this.project.getName(), "Build information has not been loaded yet");
            return this.entries.toArray(new IPathEntry[this.entries.size()]);
        }
        String scdProfileId = ManagedBuildManager.getScannerInfoProfileId(defaultConfig);
        IScannerInfoCollector collector = null;
        SCProfileInstance profileInstance = null;
        if (scdProfileId != null) {
            InfoContext context = CfgScannerConfigProfileManager.createDefaultContext(this.project);
            profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(this.project, context, scdProfileId);
            collector = profileInstance.createScannerInfoCollector();
        }
        ManagedBuildCPathEntryContainer managedBuildCPathEntryContainer = this;
        synchronized (managedBuildCPathEntryContainer) {
            if (collector instanceof IManagedScannerInfoCollector) {
                IManagedScannerInfoCollector mCollector = (IManagedScannerInfoCollector)collector;
                mCollector.setProject(this.project);
                ManagedBuildCPathEntryContainer.outputTrace(this.project.getName(), "Path entries collected dynamically");
                this.calculateEntriesDynamically((IProject)this.info.getOwner(), profileInstance, collector);
                this.addEntries(this.info.getManagedBuildValues());
                this.addIncludePaths(mCollector.getIncludePaths());
                this.addDefinedSymbols(mCollector.getDefinedSymbols());
            } else if (defaultConfig != null) {
                this.addEntries(this.info.getManagedBuildValues());
                this.addEntries(this.info.getManagedBuildBuiltIns());
                ManagedBuildCPathEntryContainer.outputTrace(this.project.getName(), "Path entries set using built-in definitions from " + defaultConfig.getName());
            } else {
                ManagedBuildCPathEntryContainer.outputError(this.project.getName(), "Configuration is null");
                return this.entries.toArray(new IPathEntry[this.entries.size()]);
            }
            return this.entries.toArray(new IPathEntry[this.entries.size()]);
        }
    }

    public String getDescription() {
        return "CDT Managed Build Project";
    }

    public IPath getPath() {
        return new Path("org.eclipse.cdt.managedbuilder.MANAGED_CONTAINER");
    }

    private void addEntries(IPathEntry[] values) {
        if (values == null) {
            return;
        }
        int i = 0;
        while (i < values.length) {
            if (values[i] != null && !this.entries.contains(values[i])) {
                this.entries.add(values[i]);
            }
            ++i;
        }
    }
}

