/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildProperty;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.properties.Messages;
import org.eclipse.cdt.managedbuilder.ui.wizards.CDTConfigWizardPage;
import org.eclipse.cdt.managedbuilder.ui.wizards.CfgHolder;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageManager;
import org.eclipse.cdt.managedbuilder.ui.wizards.ManagedBuildWizard;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.ui.templateengine.IWizardDataPage;
import org.eclipse.cdt.ui.templateengine.Template;
import org.eclipse.cdt.ui.templateengine.TemplateEngineUI;
import org.eclipse.cdt.ui.templateengine.TemplateEngineUIUtil;
import org.eclipse.cdt.ui.templateengine.pages.UIWizardPage;
import org.eclipse.cdt.ui.wizards.CDTCommonProjectWizard;
import org.eclipse.cdt.ui.wizards.CWizardHandler;
import org.eclipse.cdt.ui.wizards.EntryDescriptor;
import org.eclipse.cdt.ui.wizards.IWizardItemsListListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBSWizardHandler
extends CWizardHandler {
    public static final String ARTIFACT = "org.eclipse.cdt.build.core.buildArtefactType";
    public static final String EMPTY_STR = "";
    private static final String PROPERTY = "org.eclipse.cdt.build.core.buildType";
    private static final String PROP_VAL = "org.eclipse.cdt.build.core.buildType.debug";
    private static final String tooltip = String.valueOf(Messages.getString("CWizardHandler.1")) + Messages.getString("CWizardHandler.2") + Messages.getString("CWizardHandler.3") + Messages.getString("CWizardHandler.4") + Messages.getString("CWizardHandler.5");
    protected SortedMap<String, IToolChain> full_tcs = new TreeMap<String, IToolChain>();
    private String propertyId = null;
    private IProjectType pt = null;
    protected IWizardItemsListListener listener;
    protected CDTConfigWizardPage fConfigPage;
    private IToolChain[] savedToolChains = null;
    private IWizard wizard;
    private IWizardPage startingPage;
    private EntryInfo entryInfo;
    protected CfgHolder[] cfgs = null;
    protected IWizardPage[] customPages;
    private List<String> preferredTCs = new ArrayList<String>();

    public MBSWizardHandler(IProjectType _pt, Composite p, IWizard w) {
        super(p, Messages.getString("CWizardHandler.0"), _pt.getName());
        this.pt = _pt;
        this.setWizard(w);
    }

    public MBSWizardHandler(String name, Composite p, IWizard w) {
        super(p, Messages.getString("CWizardHandler.0"), name);
        this.setWizard(w);
    }

    public MBSWizardHandler(IBuildPropertyValue val, Composite p, IWizard w) {
        super(p, Messages.getString("CWizardHandler.0"), val.getName());
        this.propertyId = val.getId();
        this.setWizard(w);
    }

    private void setWizard(IWizard w) {
        if (w != null) {
            if (w.getStartingPage() instanceof IWizardItemsListListener) {
                this.listener = (IWizardItemsListListener)w.getStartingPage();
            }
            this.wizard = w;
            this.startingPage = w.getStartingPage();
        }
    }

    protected IWizardPage getStartingPage() {
        return this.startingPage;
    }

    public Map<String, String> getMainPageData() {
        WizardNewProjectCreationPage page = (WizardNewProjectCreationPage)this.getStartingPage();
        HashMap<String, String> data = new HashMap<String, String>();
        String projName = page.getProjectName();
        projName = projName != null ? projName.trim() : EMPTY_STR;
        data.put("projectName", projName);
        data.put("baseName", this.getBaseName(projName));
        data.put("baseNameUpper", this.getBaseName(projName).toUpperCase());
        data.put("baseNameLower", this.getBaseName(projName).toLowerCase());
        String location = page.getLocationPath().toOSString();
        if (location == null) {
            location = EMPTY_STR;
        }
        data.put("location", location);
        return data;
    }

    private String getBaseName(String name) {
        String baseName = name;
        int dot = baseName.lastIndexOf(46);
        if (dot != -1) {
            baseName = baseName.substring(dot + 1);
        }
        if ((dot = baseName.indexOf(32)) != -1) {
            baseName = baseName.substring(0, dot);
        }
        return baseName;
    }

    public void handleSelection() {
        List preferred = CDTPrefUtil.getPreferredTCs();
        if (this.table == null) {
            this.table = new Table(this.parent, 2562);
            this.table.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    if (e.result == null) {
                        e.result = MBSWizardHandler.this.head;
                    }
                }
            });
            this.table.setToolTipText(tooltip);
            if (this.entryInfo != null) {
                int counter = 0;
                int position = 0;
                for (String s : this.entryInfo.tc_filter()) {
                    TableItem ti = new TableItem(this.table, 0);
                    Object obj = this.full_tcs.get(s);
                    String id = "NULL";
                    if (obj instanceof IToolChain) {
                        IToolChain tc = (IToolChain)obj;
                        String name = tc.getUniqueRealName();
                        id = tc.getId();
                        ti.setText(name);
                        ti.setData((Object)tc);
                    } else {
                        ti.setText(s);
                    }
                    if (position == 0 && preferred.contains(id)) {
                        position = counter;
                    }
                    ++counter;
                }
                if (counter > 0) {
                    this.table.select(position);
                }
            }
            this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MBSWizardHandler.this.handleToolChainSelection();
                }
            });
        }
        this.updatePreferred(preferred);
        this.loadCustomPages();
        this.table.setVisible(true);
        this.parent.layout();
        if (this.fConfigPage != null) {
            this.fConfigPage.pagesLoaded = false;
        }
    }

    private void handleToolChainSelection() {
        this.loadCustomPages();
        if (this.listener != null) {
            this.listener.toolChainListChanged(this.table.getSelectionCount());
        }
    }

    private void loadCustomPages() {
        if (!(this.getWizard() instanceof CDTCommonProjectWizard)) {
            return;
        }
        CDTCommonProjectWizard wz = (CDTCommonProjectWizard)this.getWizard();
        if (this.customPages == null) {
            MBSCustomPageManager.init();
            MBSCustomPageManager.addStockPage(this.getStartingPage(), "org.eclipse.cdt.managedbuilder.ui.wizard.NewModelProjectWizardPage");
            MBSCustomPageManager.addStockPage((IWizardPage)this.getConfigPage(), "org.eclipse.cdt.managedbuilder.ui.wizard.CConfigWizardPage");
            try {
                MBSCustomPageManager.loadExtensions();
            }
            catch (BuildException e) {
                e.printStackTrace();
            }
            this.customPages = MBSCustomPageManager.getCustomPages();
            if (this.customPages == null) {
                this.customPages = new IWizardPage[0];
            }
            int k = 0;
            while (k < this.customPages.length) {
                this.customPages[k].setWizard((IWizard)wz);
                ++k;
            }
        }
        this.setCustomPagesFilter(wz);
    }

    private void setCustomPagesFilter(CDTCommonProjectWizard wz) {
        IToolChain[] tcs;
        boolean ptIsNull;
        String[] natures = wz.getNatures();
        if (natures == null || natures.length == 0) {
            MBSCustomPageManager.addPageProperty("org.eclipse.cdt.managedbuilder.ui.wizard.platformPage", "nature", null);
        } else if (natures.length == 1) {
            MBSCustomPageManager.addPageProperty("org.eclipse.cdt.managedbuilder.ui.wizard.platformPage", "nature", natures[0]);
        } else {
            TreeSet<String> x = new TreeSet<String>();
            int i = 0;
            while (i < natures.length) {
                x.add(natures[i]);
                ++i;
            }
            MBSCustomPageManager.addPageProperty("org.eclipse.cdt.managedbuilder.ui.wizard.platformPage", "nature", x);
        }
        boolean bl = ptIsNull = this.getProjectType() == null;
        if (!ptIsNull) {
            MBSCustomPageManager.addPageProperty("org.eclipse.cdt.managedbuilder.ui.wizard.platformPage", "projectType", this.getProjectType().getId());
        }
        int n = (tcs = this.getSelectedToolChains()) == null ? 0 : tcs.length;
        ArrayList<IToolChain> x = new ArrayList<IToolChain>();
        TreeSet<String> y = new TreeSet<String>();
        int i = 0;
        while (i < n) {
            if (tcs[i] != null) {
                IProjectType pt;
                x.add(tcs[i]);
                IConfiguration cfg = tcs[i].getParent();
                if (cfg != null && (pt = cfg.getProjectType()) != null) {
                    y.add(pt.getId());
                }
            }
            ++i;
        }
        MBSCustomPageManager.addPageProperty("org.eclipse.cdt.managedbuilder.ui.wizard.platformPage", "toolchain", x);
        if (ptIsNull) {
            if (y.size() > 0) {
                MBSCustomPageManager.addPageProperty("org.eclipse.cdt.managedbuilder.ui.wizard.platformPage", "projectType", y);
            } else {
                MBSCustomPageManager.addPageProperty("org.eclipse.cdt.managedbuilder.ui.wizard.platformPage", "projectType", null);
            }
        }
    }

    public void handleUnSelection() {
        if (this.table != null) {
            this.table.setVisible(false);
        }
        if (this.fConfigPage != null) {
            this.fConfigPage.pagesLoaded = false;
        }
    }

    public void addTc(IToolChain tc) {
        if (tc.isAbstract() || tc.isSystemObject()) {
            return;
        }
        IConfiguration[] cfgs = null;
        if (this.propertyId != null) {
            cfgs = ManagedBuildManager.getExtensionConfigurations((IToolChain)tc, (String)ARTIFACT, (String)this.propertyId);
        } else if (this.pt != null) {
            cfgs = ManagedBuildManager.getExtensionConfigurations((IToolChain)tc, (IProjectType)this.pt);
        }
        if (cfgs == null || cfgs.length == 0) {
            return;
        }
        this.full_tcs.put(tc.getUniqueRealName(), tc);
    }

    public void createProject(IProject project, boolean defaults, boolean onFinish) throws CoreException {
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.createProjectDescription(project, false, !onFinish);
        ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)project);
        this.cfgs = this.fConfigPage.getCfgItems(false);
        if (this.cfgs == null || this.cfgs.length == 0) {
            this.cfgs = CDTConfigWizardPage.getDefaultCfgs(this);
        }
        if (this.cfgs == null || this.cfgs.length == 0 || this.cfgs[0].getConfiguration() == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderUIPlugin.getUniqueIdentifier(), Messages.getString("CWizardHandler.6")));
        }
        Configuration cf = (Configuration)this.cfgs[0].getConfiguration();
        ManagedProject mProj = new ManagedProject((IResource)project, cf.getProjectType());
        info.setManagedProject((IManagedProject)mProj);
        this.cfgs = CfgHolder.unique(this.cfgs);
        this.cfgs = CfgHolder.reorder(this.cfgs);
        ICConfigurationDescription cfgDebug = null;
        ICConfigurationDescription cfgFirst = null;
        int i = 0;
        while (i < this.cfgs.length) {
            cf = (Configuration)this.cfgs[i].getConfiguration();
            String id = ManagedBuildManager.calculateChildId((String)cf.getId(), null);
            Configuration config = new Configuration(mProj, cf, id, false, true);
            CConfigurationData data = config.getConfigurationData();
            ICConfigurationDescription cfgDes = des.createConfiguration(ManagedBuildManager.CFG_DATA_PROVIDER_ID, data);
            config.setConfigurationDescription(cfgDes);
            config.exportArtifactInfo();
            IBuilder bld = config.getEditableBuilder();
            if (bld != null) {
                bld.setManagedBuildOn(true);
            }
            config.setName(this.cfgs[i].getName());
            config.setArtifactName(MBSWizardHandler.removeSpaces((String)project.getName()));
            IBuildProperty b = config.getBuildProperties().getProperty(PROPERTY);
            if (cfgDebug == null && b != null && b.getValue() != null && PROP_VAL.equals(b.getValue().getId())) {
                cfgDebug = cfgDes;
            }
            if (cfgFirst == null) {
                cfgFirst = cfgDes;
            }
            ++i;
        }
        mngr.setProjectDescription(project, des);
        this.doTemplatesPostProcess(project);
        this.doCustom(project);
    }

    protected void doTemplatesPostProcess(IProject prj) {
        if (this.entryInfo == null) {
            return;
        }
        Template template = this.entryInfo.getInitializedTemplate(this.getStartingPage(), (IWizardPage)this.getConfigPage(), this.getMainPageData());
        if (template == null) {
            return;
        }
        ArrayList<IConfiguration> configs = new ArrayList<IConfiguration>();
        int i = 0;
        while (i < this.cfgs.length) {
            configs.add((IConfiguration)this.cfgs[i].getConfiguration());
            ++i;
        }
        template.getTemplateInfo().setConfigurations(configs);
        IStatus[] statuses = template.executeTemplateProcesses(null, false);
        if (statuses.length == 1 && statuses[0].getException() instanceof ProcessFailureException) {
            TemplateEngineUIUtil.showError((String)statuses[0].getMessage(), (Throwable)statuses[0].getException());
        }
    }

    protected CDTConfigWizardPage getConfigPage() {
        if (this.fConfigPage == null) {
            this.fConfigPage = new CDTConfigWizardPage(this);
        }
        return this.fConfigPage;
    }

    public IWizardPage getSpecificPage() {
        return this.entryInfo.getNextPage(this.getStartingPage(), (IWizardPage)this.getConfigPage());
    }

    public void updatePreferred(List<String> prefs) {
        this.preferredTCs.clear();
        int x = this.table.getItemCount();
        int i = 0;
        while (i < x) {
            String id;
            TableItem ti = this.table.getItem(i);
            IToolChain tc = (IToolChain)ti.getData();
            String string = id = tc == null ? "NULL" : tc.getId();
            if (prefs.contains(id)) {
                ti.setImage(IMG1);
                this.preferredTCs.add(tc.getName());
            } else {
                ti.setImage(IMG0);
            }
            ++i;
        }
    }

    public List<String> getPreferredTCNames() {
        return this.preferredTCs;
    }

    public String getHeader() {
        return this.head;
    }

    public boolean isDummy() {
        return false;
    }

    public boolean supportsPreferred() {
        return true;
    }

    public boolean isChanged() {
        if (this.savedToolChains == null) {
            return true;
        }
        IToolChain[] tcs = this.getSelectedToolChains();
        if (this.savedToolChains.length != tcs.length) {
            return true;
        }
        int i = 0;
        while (i < this.savedToolChains.length) {
            boolean found = false;
            int j = 0;
            while (j < tcs.length) {
                if (this.savedToolChains[i] == tcs[j]) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void saveState() {
        this.savedToolChains = this.getSelectedToolChains();
    }

    public IToolChain[] getSelectedToolChains() {
        TableItem[] tis = this.table.getSelection();
        if (tis == null || tis.length == 0) {
            return new IToolChain[0];
        }
        IToolChain[] ts = new IToolChain[tis.length];
        int i = 0;
        while (i < tis.length) {
            ts[i] = (IToolChain)tis[i].getData();
            ++i;
        }
        return ts;
    }

    public int getToolChainsCount() {
        if (this.entryInfo == null) {
            return this.full_tcs.size();
        }
        return this.entryInfo.tc_filter().size();
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public IProjectType getProjectType() {
        return this.pt;
    }

    public IWizard getWizard() {
        return this.wizard;
    }

    public CfgHolder[] getCfgItems(boolean defaults) {
        this.getConfigPage();
        return this.fConfigPage.getCfgItems(defaults);
    }

    public String getErrorMessage() {
        TableItem[] tis = this.table.getSelection();
        if (tis == null || tis.length == 0) {
            return Messages.getString("MBSWizardHandler.0");
        }
        return null;
    }

    protected void doCustom(IProject newProject) {
        IRunnableWithProgress[] operations = MBSCustomPageManager.getOperations();
        if (operations != null) {
            int k = 0;
            while (k < operations.length) {
                try {
                    this.wizard.getContainer().run(false, true, operations[k]);
                }
                catch (InvocationTargetException e) {
                    ManagedBuilderUIPlugin.log(e);
                }
                catch (InterruptedException e) {
                    ManagedBuilderUIPlugin.log(e);
                }
                ++k;
            }
        }
    }

    public void postProcess(IProject newProject, boolean created) {
        this.deleteExtraConfigs(newProject);
        if (created) {
            this.doTemplatesPostProcess(newProject);
            this.doCustom(newProject);
        }
    }

    private void deleteExtraConfigs(IProject newProject) {
        if (this.isChanged()) {
            return;
        }
        if (this.listener != null && this.listener.isCurrent()) {
            return;
        }
        if (this.fConfigPage == null || !this.fConfigPage.pagesLoaded) {
            return;
        }
        ICProjectDescription prjd = CoreModel.getDefault().getProjectDescription(newProject, true);
        if (prjd == null) {
            return;
        }
        ICConfigurationDescription[] all = prjd.getConfigurations();
        if (all == null) {
            return;
        }
        CfgHolder[] req = this.getCfgItems(false);
        boolean modified = false;
        int i = 0;
        while (i < all.length) {
            boolean found = false;
            int j = 0;
            while (j < req.length) {
                if (all[i].getName().equals(req[j].getName())) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                modified = true;
                prjd.removeConfiguration(all[i]);
            }
            ++i;
        }
        if (modified) {
            try {
                CoreModel.getDefault().setProjectDescription(newProject, prjd);
            }
            catch (CoreException coreException) {}
        }
    }

    public boolean isApplicable(EntryDescriptor data) {
        EntryInfo info = new EntryInfo(data, this.full_tcs);
        return info.isValid() && info.getToolChainsCount() > 0;
    }

    public void initialize(EntryDescriptor data) throws CoreException {
        EntryInfo info = new EntryInfo(data, this.full_tcs);
        if (!info.isValid()) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderUIPlugin.getUniqueIdentifier(), "inappropriate descriptor"));
        }
        this.entryInfo = info;
    }

    public Object clone() {
        MBSWizardHandler clone = (MBSWizardHandler)((Object)super.clone());
        if (clone != null) {
            clone.propertyId = this.propertyId;
            clone.pt = this.pt;
            clone.listener = this.listener;
            clone.wizard = this.wizard;
            clone.entryInfo = this.entryInfo;
            clone.fConfigPage = this.fConfigPage;
            clone.full_tcs = this.full_tcs;
        }
        return clone;
    }

    public boolean canFinish() {
        if (this.entryInfo == null) {
            return false;
        }
        if (!this.getConfigPage().isCustomPageComplete()) {
            return false;
        }
        if (!this.entryInfo.canFinish(this.startingPage, (IWizardPage)this.getConfigPage())) {
            return false;
        }
        if (this.customPages != null) {
            int i = 0;
            while (i < this.customPages.length) {
                if (!this.customPages[i].isPageComplete()) {
                    return false;
                }
                ++i;
            }
        }
        return super.canFinish();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class EntryInfo {
        private SortedMap<String, IToolChain> tcs;
        private EntryDescriptor entryDescriptor;
        private Template template;
        private boolean initialized;
        private boolean isValid;
        private String projectTypeId;
        private String templateId;
        private IWizardPage[] templatePages;
        private IWizardPage predatingPage;
        private IWizardPage followingPage;

        public EntryInfo(EntryDescriptor dr, SortedMap<String, IToolChain> _tcs) {
            this.entryDescriptor = dr;
            this.tcs = _tcs;
        }

        public boolean isValid() {
            this.initialize();
            return this.isValid;
        }

        public Template getTemplate() {
            this.initialize();
            return this.template;
        }

        public EntryDescriptor getDescriptor() {
            return this.entryDescriptor;
        }

        private void initialize() {
            block6: {
                block7: {
                    String[] path;
                    if (this.initialized) {
                        return;
                    }
                    if (this.entryDescriptor == null || (path = this.entryDescriptor.getPathArray()) == null || path.length == 0) break block6;
                    this.projectTypeId = path[0];
                    if (this.entryDescriptor.isDefaultForCategory() || path.length <= 1 || path[0].equals(ManagedBuildWizard.OTHERS_LABEL)) break block7;
                    this.templateId = path[path.length - 1];
                    Template[] templates = TemplateEngineUI.getDefault().getTemplates(this.projectTypeId);
                    if (templates.length == 0) break block6;
                    int i = 0;
                    while (i < templates.length) {
                        if (templates[i].getTemplateId().equals(this.templateId)) {
                            this.template = templates[i];
                            break;
                        }
                        ++i;
                    }
                    if (this.template == null) break block6;
                }
                this.isValid = true;
            }
            this.initialized = true;
        }

        public Template getInitializedTemplate(IWizardPage predatingPage, IWizardPage followingPage, Map<String, String> map) {
            this.getNextPage(predatingPage, followingPage);
            Template template = this.getTemplate();
            if (template != null) {
                Map valueStore = template.getValueStore();
                int i = 0;
                while (i < this.templatePages.length) {
                    IWizardPage page = this.templatePages[i];
                    if (page instanceof UIWizardPage) {
                        valueStore.putAll(((UIWizardPage)page).getPageData());
                    }
                    if (page instanceof IWizardDataPage) {
                        valueStore.putAll(((IWizardDataPage)page).getPageData());
                    }
                    ++i;
                }
                if (map != null) {
                    valueStore.putAll(map);
                }
            }
            return template;
        }

        public IWizardPage getNextPage(IWizardPage predatingPage, IWizardPage followingPage) {
            this.initialize();
            if (this.templatePages == null || this.predatingPage != predatingPage || this.followingPage != followingPage) {
                this.predatingPage = predatingPage;
                this.followingPage = followingPage;
                if (this.template != null) {
                    this.templatePages = this.template.getTemplateWizardPages(predatingPage, followingPage, predatingPage.getWizard());
                } else {
                    this.templatePages = new IWizardPage[0];
                    followingPage.setPreviousPage(predatingPage);
                }
            }
            if (this.templatePages.length != 0) {
                return this.templatePages[0];
            }
            return followingPage;
        }

        private boolean canFinish(IWizardPage predatingPage, IWizardPage followingPage) {
            this.getNextPage(predatingPage, followingPage);
            int i = 0;
            while (i < this.templatePages.length) {
                if (!this.templatePages[i].isPageComplete()) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected Set<String> tc_filter() {
            Set<String> full = this.tcs.keySet();
            if (this.entryDescriptor == null) {
                return full;
            }
            LinkedHashSet<String> out = new LinkedHashSet<String>(full.size());
            for (String s : full) {
                if (!this.isToolChainAcceptable(s)) continue;
                out.add(s);
            }
            return out;
        }

        public boolean isToolChainAcceptable(String tcId) {
            if (this.template == null || this.template.getTemplateInfo() == null) {
                return true;
            }
            String[] ss = this.template.getTemplateInfo().getToolChainIds();
            if (ss == null || ss.length == 0) {
                return true;
            }
            Object ob = this.tcs.get(tcId);
            if (ob == null) {
                return true;
            }
            if (!(ob instanceof IToolChain)) {
                return false;
            }
            String id1 = ((IToolChain)ob).getId();
            IToolChain sup = ((IToolChain)ob).getSuperClass();
            String id2 = sup == null ? null : sup.getId();
            int i = 0;
            while (i < ss.length) {
                if (ss[i] != null && ss[i].equals(id1) || ss[i] != null && ss[i].equals(id2)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public int getToolChainsCount() {
            return this.tc_filter().size();
        }
    }
}

