/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.mylyn.internal.ui;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.editor.AbstractCModelOutlinePage;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinePage;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.mylyn.internal.ui.CDTStructureBridge;
import org.eclipse.cdt.mylyn.internal.ui.CDTUIBridgePlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDTUiBridge
extends AbstractContextUiBridge {
    private Field cOutlineField = null;

    public CDTUiBridge() {
        try {
            this.cOutlineField = AbstractCModelOutlinePage.class.getDeclaredField("fTreeViewer");
            this.cOutlineField.setAccessible(true);
        }
        catch (Exception e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.cdt.mylyn.ui", CDTUIBridgePlugin.getResourceString("MylynCDT.outlineViewerFailure"), (Throwable)e));
        }
    }

    public void open(IInteractionElement node) {
        try {
            ICElement cElement = CDTStructureBridge.getElementForHandle(node.getHandleIdentifier());
            if (cElement == null || !cElement.exists()) {
                return;
            }
            EditorUtility.openInEditor((Object)cElement);
        }
        catch (Throwable t) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.cdt.mylyn.ui", CDTUIBridgePlugin.getFormattedString("MylynCDT.openEditorFailure", new String[]{node.getHandleIdentifier()}), t));
        }
    }

    public void close(IInteractionElement node) {
        block7: {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page == null) break block7;
                ArrayList<IEditorReference> toClose = new ArrayList<IEditorReference>(4);
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n = iEditorReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference reference = iEditorReferenceArray[n2];
                    try {
                        ICElement input = (ICElement)reference.getEditorInput().getAdapter(ICElement.class);
                        if (input != null && node.getHandleIdentifier().equals(CDTStructureBridge.getHandleForElement(input))) {
                            toClose.add(reference);
                        }
                    }
                    catch (PartInitException partInitException) {}
                    ++n2;
                }
                if (toClose.size() > 0) {
                    page.closeEditors(toClose.toArray(new IEditorReference[toClose.size()]), true);
                }
            }
            catch (Throwable t) {
                StatusHandler.fail((IStatus)new Status(4, "org.eclipse.cdt.mylyn.ui", CDTUIBridgePlugin.getResourceString("MylynCDT.autoCloseEditorFailure"), t));
            }
        }
    }

    public boolean acceptsEditor(IEditorPart editorPart) {
        return editorPart instanceof CEditor;
    }

    public IInteractionElement getElement(IEditorInput input) {
        Object adapter = input.getAdapter(ICElement.class);
        if (adapter instanceof ICElement) {
            ICElement cElement = (ICElement)adapter;
            String handle = ContextCorePlugin.getDefault().getStructureBridge((Object)cElement).getHandleIdentifier((Object)cElement);
            return ContextCorePlugin.getContextManager().getElement(handle);
        }
        return null;
    }

    public List<TreeViewer> getContentOutlineViewers(IEditorPart editorPart) {
        CContentOutlinePage page;
        if (editorPart == null || this.cOutlineField == null) {
            return null;
        }
        ArrayList<TreeViewer> viewers = new ArrayList<TreeViewer>();
        Object out = editorPart.getAdapter(IContentOutlinePage.class);
        if (out instanceof CContentOutlinePage && (page = (CContentOutlinePage)out).getControl() != null) {
            try {
                viewers.add((TreeViewer)this.cOutlineField.get(page));
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.cdt.mylyn.ui", CDTUIBridgePlugin.getResourceString("MylynCDT.log.getOutlineViewerFailure"), (Throwable)e));
            }
        }
        return viewers;
    }

    public Object getObjectForTextSelection(TextSelection selection, IEditorPart editor) {
        if (editor instanceof CEditor) {
            TextSelection textSelection = selection;
            try {
                if (selection != null) {
                    return SelectionConverter.getElementAtOffset((ICElement)((CEditor)editor).getInputCElement(), (ITextSelection)textSelection);
                }
                ICElement element = ((CEditor)editor).getInputCElement();
                if (element instanceof ICElement) {
                    return element;
                }
            }
            catch (CModelException cModelException) {}
        }
        return null;
    }

    public String getContentType() {
        return "c/c++";
    }
}

