/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.p2.internal.repo.artifact;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cdt.p2.Activator;
import org.eclipse.cdt.p2.internal.repo.artifact.InstallArtifactRepository;
import org.eclipse.cdt.p2.internal.repo.artifact.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.persistence.XMLParser;
import org.eclipse.equinox.internal.p2.persistence.XMLWriter;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepDescriptor;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class InstallArtifactRepositoryIO {
    public void write(InstallArtifactRepository repository, OutputStream output) {
        BufferedOutputStream bufferedOutput = null;
        try {
            try {
                bufferedOutput = new BufferedOutputStream(output);
                Writer repositoryWriter = new Writer(bufferedOutput);
                repositoryWriter.write(repository);
            }
            finally {
                if (bufferedOutput != null) {
                    ((OutputStream)bufferedOutput).close();
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public IArtifactRepository read(URL location, InputStream input) throws ProvisionException {
        InstallArtifactRepository installArtifactRepository;
        block11: {
            BufferedInputStream bufferedInput = null;
            try {
                bufferedInput = new BufferedInputStream(input);
                Parser repositoryParser = new Parser(Activator.getContext(), "org.eclipse.cdt.p2", location);
                repositoryParser.parse(input);
                IStatus result = repositoryParser.getStatus();
                switch (result.getSeverity()) {
                    case 8: {
                        throw new OperationCanceledException();
                    }
                    case 4: {
                        throw new ProvisionException(result);
                    }
                    case 1: 
                    case 2: {
                        Activator.getDefault().log(result);
                    }
                }
                installArtifactRepository = repositoryParser.getRepository();
                if (bufferedInput == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedInput != null) {
                        bufferedInput.close();
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    String msg = NLS.bind((String)Messages.io_failedRead, (Object)location);
                    throw new ProvisionException((IStatus)new Status(4, "org.eclipse.cdt.p2", 1002, msg, (Throwable)ioe));
                }
            }
            bufferedInput.close();
        }
        return installArtifactRepository;
    }

    private class Parser
    extends XMLParser
    implements XMLConstants {
        private InstallArtifactRepository theRepository;
        final URL location;

        public Parser(BundleContext _context, String _bundleId, URL _location) {
            super(_context, _bundleId);
            this.location = _location;
        }

        public void parse(File file) throws IOException {
            this.parse(new FileInputStream(file));
        }

        public synchronized void parse(InputStream stream) throws IOException {
            this.status = null;
            try {
                try {
                    this.getParser();
                    RepositoryHandler repositoryHandler = new RepositoryHandler();
                    this.xmlReader.setContentHandler((ContentHandler)((Object)new RepositoryDocHandler("repository", repositoryHandler)));
                    this.xmlReader.parse(new InputSource(stream));
                    if (this.isValidXML()) {
                        this.theRepository = repositoryHandler.getRepository();
                    }
                }
                catch (SAXException e) {
                    throw new IOException(e.getMessage());
                }
                catch (ParserConfigurationException e) {
                    throw new IOException(e.getMessage());
                }
            }
            finally {
                stream.close();
            }
        }

        public InstallArtifactRepository getRepository() {
            return this.theRepository;
        }

        protected Object getRootObject() {
            return this.theRepository;
        }

        protected String getErrorMessage() {
            return Messages.io_parseError;
        }

        public String toString() {
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class ArtifactHandler
        extends XMLParser.AbstractHandler {
            private final String[] required;
            private Set<ArtifactDescriptor> artifacts;
            ArtifactDescriptor currentArtifact;
            private XMLParser.PropertiesHandler propertiesHandler;
            private XMLParser.PropertiesHandler repositoryPropertiesHandler;
            private ProcessingStepsHandler processingStepsHandler;

            public ArtifactHandler(XMLParser.AbstractHandler _parentHandler, Attributes attributes, Set<ArtifactDescriptor> _artifacts) {
                super((XMLParser)Parser.this, (ContentHandler)_parentHandler, "artifact");
                this.required = new String[]{"classifier", "id", "version"};
                this.currentArtifact = null;
                this.propertiesHandler = null;
                this.repositoryPropertiesHandler = null;
                this.processingStepsHandler = null;
                this.artifacts = _artifacts;
                String[] values = this.parseRequiredAttributes(attributes, this.required);
                Version version = Parser.this.checkVersion("artifact", "version", values[2]);
                this.currentArtifact = new ArtifactDescriptor((IArtifactKey)new ArtifactKey(values[0], values[1], version));
            }

            public ArtifactDescriptor getArtifact() {
                return this.currentArtifact;
            }

            public void startElement(String name, Attributes attributes) {
                if ("processing".equals(name)) {
                    if (this.processingStepsHandler == null) {
                        this.processingStepsHandler = new ProcessingStepsHandler(this, attributes);
                    } else {
                        Parser.this.duplicateElement(this, name, attributes);
                    }
                } else if ("properties".equals(name)) {
                    if (this.propertiesHandler == null) {
                        this.propertiesHandler = new XMLParser.PropertiesHandler((XMLParser)Parser.this, (ContentHandler)((Object)this), attributes);
                    } else {
                        Parser.this.duplicateElement(this, name, attributes);
                    }
                } else if ("repositoryProperties".equals(name)) {
                    if (this.repositoryPropertiesHandler == null) {
                        this.repositoryPropertiesHandler = new XMLParser.PropertiesHandler((XMLParser)Parser.this, (ContentHandler)((Object)this), attributes);
                    } else {
                        Parser.this.duplicateElement(this, name, attributes);
                    }
                } else {
                    this.invalidElement(name, attributes);
                }
            }

            protected void finished() {
                if (Parser.this.isValidXML() && this.currentArtifact != null) {
                    OrderedProperties properties = this.propertiesHandler == null ? new OrderedProperties(0) : this.propertiesHandler.getProperties();
                    this.currentArtifact.addProperties((Map)properties);
                    properties = this.repositoryPropertiesHandler == null ? new OrderedProperties(0) : this.repositoryPropertiesHandler.getProperties();
                    this.currentArtifact.addRepositoryProperties((Map)properties);
                    ProcessingStepDescriptor[] processingSteps = this.processingStepsHandler == null ? new ProcessingStepDescriptor[]{} : this.processingStepsHandler.getProcessingSteps();
                    this.currentArtifact.setProcessingSteps(processingSteps);
                    this.artifacts.add(this.currentArtifact);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class ArtifactsHandler
        extends XMLParser.AbstractHandler {
            private Set<ArtifactDescriptor> artifacts;

            public ArtifactsHandler(XMLParser.AbstractHandler _parentHandler, Attributes attributes) {
                super((XMLParser)Parser.this, (ContentHandler)_parentHandler, "artifacts");
                String size = this.parseOptionalAttribute(attributes, "size");
                this.artifacts = size != null ? new LinkedHashSet(new Integer(size)) : new LinkedHashSet(4);
            }

            public Set<ArtifactDescriptor> getArtifacts() {
                return this.artifacts;
            }

            public void startElement(String name, Attributes attributes) {
                if (name.equals("artifact")) {
                    new ArtifactHandler(this, attributes, this.artifacts);
                } else {
                    this.invalidElement(name, attributes);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class ProcessingStepHandler
        extends XMLParser.AbstractHandler {
            private final String[] required;
            private final String[] optional;

            public ProcessingStepHandler(XMLParser.AbstractHandler _parentHandler, Attributes attributes, List<ProcessingStepDescriptor> processingSteps) {
                super((XMLParser)Parser.this, (ContentHandler)_parentHandler, "step");
                this.required = new String[]{"id", "required"};
                this.optional = new String[]{"data"};
                String[] attributeValues = this.parseAttributes(attributes, this.required, this.optional);
                processingSteps.add(new ProcessingStepDescriptor(attributeValues[0], attributeValues[1], Parser.this.checkBoolean("step", "required", attributeValues[2]).booleanValue()));
            }

            public void startElement(String name, Attributes attributes) {
                this.invalidElement(name, attributes);
            }
        }

        protected class ProcessingStepsHandler
        extends XMLParser.AbstractHandler {
            private List<ProcessingStepDescriptor> processingSteps;

            public ProcessingStepsHandler(XMLParser.AbstractHandler _parentHandler, Attributes attributes) {
                super((XMLParser)Parser.this, (ContentHandler)_parentHandler, "processing");
                String size = this.parseOptionalAttribute(attributes, "size");
                this.processingSteps = size != null ? new ArrayList(new Integer(size)) : new ArrayList(4);
            }

            public ProcessingStepDescriptor[] getProcessingSteps() {
                return this.processingSteps.toArray(new ProcessingStepDescriptor[this.processingSteps.size()]);
            }

            public void startElement(String name, Attributes attributes) {
                if (name.equals("step")) {
                    new ProcessingStepHandler(this, attributes, this.processingSteps);
                } else {
                    this.invalidElement(name, attributes);
                }
            }
        }

        private final class RepositoryDocHandler
        extends XMLParser.DocHandler {
            public RepositoryDocHandler(String rootName, XMLParser.RootHandler rootHandler) {
                super((XMLParser)Parser.this, rootName, rootHandler);
            }

            public void processingInstruction(String target, String data) throws SAXException {
                Version repositoryVersion;
                if ("artifactRepository".equals(target) && !XML_TOLERANCE.isIncluded(repositoryVersion = Parser.this.extractPIVersion(target, data))) {
                    throw new SAXException(NLS.bind((String)Messages.io_incompatibleVersion, (Object)repositoryVersion, (Object)XML_TOLERANCE));
                }
            }
        }

        private final class RepositoryHandler
        extends XMLParser.RootHandler {
            private final String[] required;
            private final String[] optional;
            private String[] attrValues;
            private XMLParser.PropertiesHandler propertiesHandler;
            private ArtifactsHandler artifactsHandler;
            private InstallArtifactRepository repository;

            public RepositoryHandler() {
                super((XMLParser)Parser.this);
                this.required = new String[]{"name", "type", "version"};
                this.optional = new String[]{"description", "provider"};
                this.attrValues = new String[this.required.length + this.optional.length];
                this.propertiesHandler = null;
                this.artifactsHandler = null;
                this.repository = null;
            }

            public InstallArtifactRepository getRepository() {
                return this.repository;
            }

            protected void handleRootAttributes(Attributes attributes) {
                this.attrValues = this.parseAttributes(attributes, this.required, this.optional);
                this.attrValues[2] = Parser.this.checkVersion("repository", "version", this.attrValues[2]).toString();
            }

            public void startElement(String name, Attributes attributes) {
                if ("artifacts".equals(name)) {
                    if (this.artifactsHandler == null) {
                        this.artifactsHandler = new ArtifactsHandler((XMLParser.AbstractHandler)this, attributes);
                    } else {
                        Parser.this.duplicateElement((XMLParser.AbstractHandler)this, name, attributes);
                    }
                } else if ("properties".equals(name)) {
                    if (this.propertiesHandler == null) {
                        this.propertiesHandler = new XMLParser.PropertiesHandler((XMLParser)Parser.this, (ContentHandler)((Object)this), attributes);
                    } else {
                        Parser.this.duplicateElement((XMLParser.AbstractHandler)this, name, attributes);
                    }
                } else {
                    this.invalidElement(name, attributes);
                }
            }

            protected void finished() {
                if (Parser.this.isValidXML()) {
                    OrderedProperties properties = this.propertiesHandler == null ? new OrderedProperties(0) : this.propertiesHandler.getProperties();
                    HashSet<ArtifactDescriptor> artifacts = this.artifactsHandler == null ? new HashSet(0) : this.artifactsHandler.getArtifacts();
                    this.repository = new InstallArtifactRepository(this.attrValues[0], this.attrValues[1], this.attrValues[2], Parser.this.location, this.attrValues[3], this.attrValues[4], artifacts, (Map)properties);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Writer
    extends XMLWriter
    implements XMLConstants {
        public Writer(OutputStream output) throws IOException {
            super(output, PI_DEFAULTS);
        }

        public void write(InstallArtifactRepository repository) {
            this.start("repository");
            this.attribute("name", repository.getName());
            this.attribute("type", repository.getType());
            this.attribute("version", repository.getVersion());
            this.attributeOptional("provider", repository.getProvider());
            this.attributeOptional("description", repository.getDescription());
            this.writeProperties(repository.getProperties());
            this.writeArtifacts(repository.getDescriptors());
            this.end("repository");
            this.flush();
        }

        private void writeArtifacts(Collection<IArtifactDescriptor> artifactDescriptors) {
            this.start("artifacts");
            this.attribute("size", artifactDescriptors.size());
            for (IArtifactDescriptor idescriptor : artifactDescriptors) {
                ArtifactDescriptor descriptor = (ArtifactDescriptor)idescriptor;
                IArtifactKey key = descriptor.getArtifactKey();
                this.start("artifact");
                this.attribute("classifier", key.getClassifier());
                this.attribute("id", key.getId());
                this.attribute("version", key.getVersion());
                this.writeProcessingSteps(descriptor.getProcessingSteps());
                this.writeProperties(descriptor.getProperties());
                this.writeProperties("repositoryProperties", descriptor.getRepositoryProperties());
                this.end("artifact");
            }
            this.end("artifacts");
        }

        private void writeProcessingSteps(ProcessingStepDescriptor[] processingSteps) {
            if (processingSteps.length > 0) {
                this.start("processing");
                this.attribute("size", processingSteps.length);
                int i = 0;
                while (i < processingSteps.length) {
                    this.start("step");
                    this.attribute("id", processingSteps[i].getProcessorId());
                    this.attribute("data", processingSteps[i].getData());
                    this.attribute("required", processingSteps[i].isRequired());
                    this.end("step");
                    ++i;
                }
                this.end("processing");
            }
        }
    }

    private static interface XMLConstants
    extends org.eclipse.equinox.internal.p2.persistence.XMLConstants {
        public static final Version CURRENT_VERSION = new Version(1, 0, 0);
        public static final VersionRange XML_TOLERANCE = new VersionRange(CURRENT_VERSION, true, new Version(2, 0, 0), false);
        public static final String PI_REPOSITORY_TARGET = "artifactRepository";
        public static final XMLWriter.ProcessingInstruction[] PI_DEFAULTS = new XMLWriter.ProcessingInstruction[]{XMLWriter.ProcessingInstruction.makeClassVersionInstruction((String)"artifactRepository", InstallArtifactRepository.class, (Version)CURRENT_VERSION)};
        public static final String REPOSITORY_ELEMENT = "repository";
        public static final String REPOSITORY_PROPERTIES_ELEMENT = "repositoryProperties";
        public static final String MAPPING_RULES_ELEMENT = "mappings";
        public static final String MAPPING_RULE_ELEMENT = "rule";
        public static final String ARTIFACTS_ELEMENT = "artifacts";
        public static final String ARTIFACT_ELEMENT = "artifact";
        public static final String PROCESSING_STEPS_ELEMENT = "processing";
        public static final String PROCESSING_STEP_ELEMENT = "step";
        public static final String MAPPING_RULE_FILTER_ATTRIBUTE = "filter";
        public static final String MAPPING_RULE_OUTPUT_ATTRIBUTE = "output";
        public static final String ARTIFACT_CLASSIFIER_ATTRIBUTE = "classifier";
        public static final String STEP_DATA_ATTRIBUTE = "data";
        public static final String STEP_REQUIRED_ATTRIBUTE = "required";
    }
}

