/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.p2.internal.repo.artifact;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.eclipse.cdt.p2.internal.repo.artifact.FileListWriter;
import org.eclipse.cdt.p2.internal.repo.artifact.InstalledFile;

public class TarExtractor
extends Thread {
    private final InputStream in;
    private final File installDir;
    private final FileListWriter fileListWriter;
    private final String compression;

    public TarExtractor(InputStream in, File installDir, FileListWriter fileListWriter, String compression) {
        this.in = in;
        this.installDir = installDir;
        this.fileListWriter = fileListWriter;
        this.compression = compression;
    }

    public void run() {
        try {
            GZIPInputStream compIn;
            if ("tar.gz".equals(this.compression)) {
                compIn = new GZIPInputStream(this.in);
            } else if ("tar.bz2".equals(this.compression)) {
                this.in.read(new byte[2]);
                compIn = new CBZip2InputStream(this.in);
            } else {
                return;
            }
            TarInputStream tarIn = new TarInputStream((InputStream)compIn);
            TarEntry tarEntry = tarIn.getNextEntry();
            while (tarEntry != null) {
                File outFile = new File(this.installDir, tarEntry.getName());
                if (tarEntry.isDirectory()) {
                    outFile.mkdirs();
                } else {
                    if (outFile.exists()) {
                        outFile.delete();
                    } else {
                        outFile.getParentFile().mkdirs();
                    }
                    FileOutputStream outStream = new FileOutputStream(outFile);
                    tarIn.copyEntryContents((OutputStream)outStream);
                    outStream.close();
                    long lastModified = tarEntry.getModTime().getTime();
                    outFile.setLastModified(lastModified);
                    this.fileListWriter.addFile(new InstalledFile(outFile, lastModified));
                }
                tarEntry = tarIn.getNextEntry();
            }
            tarIn.close();
            this.fileListWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

