/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.p2.internal.repo.artifact;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.p2.Activator;
import org.eclipse.cdt.p2.internal.repo.artifact.FileListReader;
import org.eclipse.cdt.p2.internal.repo.artifact.FileListWriter;
import org.eclipse.cdt.p2.internal.repo.artifact.InstallArtifactRepositoryIO;
import org.eclipse.cdt.p2.internal.repo.artifact.InstalledFile;
import org.eclipse.cdt.p2.internal.repo.artifact.TarExtractor;
import org.eclipse.cdt.p2.internal.repo.artifact.ZipExtractor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.URLUtil;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRequest;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.spi.p2.artifact.repository.AbstractArtifactRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallArtifactRepository
extends AbstractArtifactRepository {
    public static final String INSTALL_DIR = "installDir";
    public static final String SUB_DIR = "subdir";
    public static final String FILENAME = "installArtifact.xml";
    public static final String COMPRESSION = "compression";
    public static final String GZIP_COMPRESSION = "tar.gz";
    public static final String BZIP2_COMPRESSION = "tar.bz2";
    public static final String ZIP_COMPRESSION = "zip";
    private static final String VERSION = "2.0.0";
    private static final String DESCRIPTION = "Wind River Metadata Repository";
    private static final String PROVIDER = "Wind River";
    private Map<String, IArtifactDescriptor> artifacts = new HashMap<String, IArtifactDescriptor>();

    public InstallArtifactRepository(URL aLocation, String aName, Map aProperties) {
        super(aName, InstallArtifactRepository.class.getName(), VERSION, aLocation, DESCRIPTION, PROVIDER, aProperties);
        this.save();
    }

    InstallArtifactRepository(String _name, String _type, String _version, URL _location, String _description, String _provider, Set<ArtifactDescriptor> _artifacts, Map _properties) {
        super(_name, _type, _version, _location, _description, _provider, _properties);
        for (IArtifactDescriptor iArtifactDescriptor : _artifacts) {
            this.artifacts.put(iArtifactDescriptor.getArtifactKey().getId(), iArtifactDescriptor);
        }
    }

    public static URL getActualLocation(URL base) {
        String spec = base.toExternalForm();
        if (spec.endsWith(FILENAME)) {
            return base;
        }
        spec = spec.endsWith("/") ? String.valueOf(spec) + FILENAME : String.valueOf(spec) + "/installArtifact.xml";
        try {
            return new URL(spec);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static IArtifactRepository getRepository(IProfile profile) throws ProvisionException {
        AgentLocation location = Activator.getDefault().getService(AgentLocation.class);
        String profileId = profile.getProfileId();
        profileId = profileId.replaceAll("[:/\\\\]", "_");
        try {
            URL url = location.getDataArea("org.eclipse.cdt.p2");
            url = new URL(String.valueOf(url.toExternalForm()) + "installDirRepo/" + profileId + "/" + FILENAME);
            IArtifactRepositoryManager repoMgr = Activator.getDefault().getService(IArtifactRepositoryManager.class);
            try {
                return repoMgr.loadRepository(url, null);
            }
            catch (ProvisionException provisionException) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put(INSTALL_DIR, profile.getLocalProperty("org.eclipse.equinox.p2.installFolder"));
                return repoMgr.createRepository(url, profile.getProfileId(), InstallArtifactRepository.class.getName(), properties);
            }
        }
        catch (MalformedURLException e) {
            Activator.getDefault().log(4, "Creating install repo URI", e);
            return null;
        }
    }

    public boolean isModifiable() {
        return true;
    }

    public boolean contains(IArtifactDescriptor descriptor) {
        return this.contains(descriptor.getArtifactKey());
    }

    public synchronized boolean contains(IArtifactKey key) {
        IArtifactDescriptor desc = this.artifacts.get(key.getId());
        if (desc == null) {
            return false;
        }
        return desc.getArtifactKey().equals(key);
    }

    public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public synchronized IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
        IArtifactDescriptor desc = this.artifacts.get(key);
        if (desc != null) {
            return new IArtifactDescriptor[]{desc};
        }
        return new IArtifactDescriptor[0];
    }

    public synchronized IArtifactKey[] getArtifactKeys() {
        Collection<IArtifactDescriptor> descs = this.artifacts.values();
        IArtifactKey[] keys = new IArtifactKey[descs.size()];
        int i = 0;
        for (IArtifactDescriptor desc : descs) {
            keys[i++] = desc.getArtifactKey();
        }
        return keys;
    }

    public IStatus getArtifacts(IArtifactRequest[] requests, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public synchronized void addDescriptor(IArtifactDescriptor descriptor) {
        super.addDescriptor(descriptor);
        this.artifacts.put(descriptor.getArtifactKey().getId(), descriptor);
        this.save();
    }

    public synchronized void addDescriptors(IArtifactDescriptor[] descriptors) {
        super.addDescriptors(descriptors);
        IArtifactDescriptor[] iArtifactDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactDescriptor descriptor = iArtifactDescriptorArray[n2];
            this.artifacts.put(descriptor.getArtifactKey().getId(), descriptor);
            ++n2;
        }
        this.save();
    }

    synchronized Collection<IArtifactDescriptor> getDescriptors() {
        return this.artifacts.values();
    }

    private File getFileListFile(String artifact) throws IOException {
        File file;
        try {
            file = new File(URLUtil.toURI((URL)this.location));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        if (file.getName().equals(FILENAME)) {
            file = file.getParentFile();
        }
        return new File(file, String.valueOf(artifact) + ".txt");
    }

    public OutputStream getOutputStream(IArtifactDescriptor descriptor) throws ProvisionException {
        super.getOutputStream(descriptor);
        IArtifactDescriptor oldDesc = this.artifacts.get(descriptor.getArtifactKey().getId());
        if (oldDesc != null) {
            this.removeDescriptor(oldDesc);
        }
        this.addDescriptor(descriptor);
        try {
            String installDirName = (String)this.getProperties().get(INSTALL_DIR);
            if (installDirName == null) {
                throw new ProvisionException("Install directory not set");
            }
            File installDir = new File(installDirName);
            String subDir = (String)descriptor.getProperties().get(SUB_DIR);
            if (subDir != null) {
                installDir = new File(installDir, subDir);
            }
            PipedOutputStream out = new PipedOutputStream();
            PipedInputStream in = new PipedInputStream(out);
            String compression = descriptor.getProperty(COMPRESSION);
            if (ZIP_COMPRESSION.equals(compression)) {
                ZipExtractor extractor = new ZipExtractor(in, installDir, new FileListWriter(this.getFileListFile(descriptor.getArtifactKey().getId())));
                extractor.start();
            } else {
                TarExtractor extractor = new TarExtractor(in, installDir, new FileListWriter(this.getFileListFile(descriptor.getArtifactKey().getId())), compression);
                extractor.start();
            }
            return out;
        }
        catch (IOException e) {
            throw new ProvisionException(e.getLocalizedMessage());
        }
    }

    private void deleteFiles(String artifact) {
        File fileListFile = null;
        try {
            try {
                InstalledFile file;
                fileListFile = this.getFileListFile(artifact);
                FileListReader reader = new FileListReader(fileListFile);
                while ((file = reader.getNext()) != null) {
                    file.uninstall();
                }
                reader.close();
            }
            catch (IOException e) {
                Activator.getDefault().log(2, "deleting file", e);
                if (fileListFile != null) {
                    fileListFile.delete();
                }
            }
        }
        finally {
            if (fileListFile != null) {
                fileListFile.delete();
            }
        }
    }

    public synchronized void removeAll() {
        super.removeAll();
        for (String artifact : this.artifacts.keySet()) {
            this.deleteFiles(artifact);
        }
        this.artifacts.clear();
        this.save();
    }

    public void removeDescriptor(IArtifactDescriptor descriptor) {
        this.removeDescriptor(descriptor.getArtifactKey());
    }

    public synchronized void removeDescriptor(IArtifactKey key) {
        super.removeDescriptor(key);
        this.deleteFiles(key.getId());
        this.artifacts.remove(key);
        this.save();
    }

    private void save() {
        try {
            OutputStream os = null;
            try {
                try {
                    URL actualLocation = InstallArtifactRepository.getActualLocation(this.location);
                    File artifactsFile = new File(actualLocation.getPath());
                    artifactsFile.getParentFile().mkdirs();
                    os = new FileOutputStream(artifactsFile);
                    super.setProperty("p2.timestamp", Long.toString(System.currentTimeMillis()));
                    new InstallArtifactRepositoryIO().write(this, os);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (os != null) {
                        os.close();
                    }
                }
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

