/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.p2.internal.repo.artifact;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;

public class InstalledFile {
    private final File file;
    private final long lastModified;

    public InstalledFile(File _file, long _lastModified) {
        this.file = _file;
        this.lastModified = _lastModified;
    }

    InstalledFile(String line) {
        String[] entries = line.split(",");
        if (entries.length < 2) {
            this.file = null;
            this.lastModified = 0L;
            return;
        }
        this.file = new File(entries[0]);
        this.lastModified = Long.parseLong(entries[1]);
    }

    public File getFile() {
        return this.file;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void uninstall() {
        if (this.file != null && this.file.lastModified() == this.lastModified) {
            File f = this.file;
            while (f != null && f.delete()) {
                f = f.getParentFile();
            }
        }
    }

    void write(BufferedWriter out) throws IOException {
        out.write(this.file.getAbsolutePath());
        out.write(44);
        out.write(String.valueOf(this.lastModified));
        out.newLine();
    }
}

