/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.p2.internal.repo.artifact;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.cdt.p2.internal.repo.artifact.FileListWriter;
import org.eclipse.cdt.p2.internal.repo.artifact.InstalledFile;

public class ZipExtractor
extends Thread {
    private final InputStream in;
    private final File installDir;
    private final FileListWriter fileListWriter;

    public ZipExtractor(InputStream in, File installDir, FileListWriter fileListWriter) {
        this.in = in;
        this.installDir = installDir;
        this.fileListWriter = fileListWriter;
    }

    public void run() {
        try {
            ZipInputStream zipIn = new ZipInputStream(this.in);
            ZipEntry zipEntry = zipIn.getNextEntry();
            while (zipEntry != null) {
                File outFile = new File(this.installDir, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    outFile.mkdirs();
                } else {
                    if (outFile.exists()) {
                        outFile.delete();
                    } else {
                        outFile.getParentFile().mkdirs();
                    }
                    FileOutputStream outStream = new FileOutputStream(outFile);
                    ZipExtractor.copyStream(zipIn, false, outStream, true);
                    long lastModified = zipEntry.getTime();
                    outFile.setLastModified(lastModified);
                    this.fileListWriter.addFile(new InstalledFile(outFile, lastModified));
                }
                zipIn.closeEntry();
                zipEntry = zipIn.getNextEntry();
            }
            while (this.in.read() != -1) {
            }
            zipIn.close();
            this.fileListWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static int copyStream(InputStream in, boolean closeIn, OutputStream out, boolean closeOut) throws IOException {
        try {
            int len;
            int written = 0;
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                written += len;
            }
            int n = written;
            return n;
        }
        finally {
            try {
                if (closeIn) {
                    in.close();
                }
            }
            finally {
                if (closeOut) {
                    out.close();
                }
            }
        }
    }
}

