/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IProjectEntry;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.viewsupport.ListContentProvider;
import org.eclipse.cdt.ui.wizards.IPathEntryContainerPage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ProjectContainerPage
extends WizardPage
implements IPathEntryContainerPage {
    private int[] fFilterType;
    private TableViewer viewer;
    ICProject fCProject;

    protected ProjectContainerPage(int[] filterType) {
        super("projectContainerPage");
        this.setTitle(CPathEntryMessages.getString("ProjectContainerPage.title"));
        this.setDescription(CPathEntryMessages.getString("ProjectContainerPage.description"));
        this.setImageDescriptor(CPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fFilterType = filterType;
        this.validatePage();
    }

    public void initialize(ICProject project, IPathEntry[] currentEntries) {
        this.fCProject = project;
    }

    public boolean finish() {
        return true;
    }

    public IContainerEntry[] getNewContainers() {
        return new IContainerEntry[0];
    }

    IProjectEntry getProjectEntry() {
        IStructuredSelection ss;
        ISelection selection;
        if (this.viewer != null && (selection = this.viewer.getSelection()) instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            ICProject project = (ICProject)ss.getFirstElement();
            return CoreModel.newProjectEntry((IPath)project.getPath());
        }
        return null;
    }

    void setProjectEntry(IProjectEntry entry) {
        if (entry != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)entry));
        }
    }

    public void setSelection(IContainerEntry containerEntry) {
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(CPathEntryMessages.getString("ProjectContainerPage.label"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.viewer = new TableViewer(container, 2820);
        this.viewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectContainerPage.this.validatePage();
            }
        });
        gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 300;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !element.equals(ProjectContainerPage.this.fCProject);
            }
        });
        this.setControl((Control)container);
        this.initializeView();
        this.validatePage();
    }

    private void initializeView() {
        ArrayList<ICProject> list = new ArrayList<ICProject>();
        try {
            List<IPathEntry> current = Arrays.asList(this.fCProject.getRawPathEntries());
            ICProject[] cProjects = CoreModel.getDefault().getCModel().getCProjects();
            int i = 0;
            while (i < cProjects.length) {
                boolean added = false;
                if (!cProjects[i].equals(this.fCProject) && !current.contains(CoreModel.newProjectEntry((IPath)cProjects[i].getPath()))) {
                    IPathEntry[] projEntries;
                    IPathEntry[] iPathEntryArray = projEntries = cProjects[i].getRawPathEntries();
                    int n = projEntries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPathEntry projEntrie = iPathEntryArray[n2];
                        int[] nArray = this.fFilterType;
                        int n3 = this.fFilterType.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int element = nArray[n4];
                            if (projEntrie.getEntryKind() == element && projEntrie.isExported()) {
                                list.add(cProjects[i]);
                                added = true;
                                break;
                            }
                            ++n4;
                        }
                        if (added) break;
                        ++n2;
                    }
                }
                ++i;
            }
        }
        catch (CModelException cModelException) {}
        this.viewer.setInput(list);
    }

    protected void validatePage() {
        this.setPageComplete(this.getSelected() != null);
    }

    private IPathEntry getSelected() {
        return this.getProjectEntry();
    }
}

