/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.ui.CElementGrouping;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class LexicalSortingAction
extends Action {
    private static final String ACTION_NAME = "LexicalSortingAction";
    private static final String DIALOG_STORE_KEY = "LexicalSortingAction.sort";
    private LexicalCSorter fSorter;
    private TreeViewer fTreeViewer;

    public LexicalSortingAction(TreeViewer treeViewer) {
        super(CUIPlugin.getResourceString("LexicalSortingAction.label"));
        this.setDescription(CUIPlugin.getResourceString("LexicalSortingAction.description"));
        this.setToolTipText(CUIPlugin.getResourceString("LexicalSortingAction.tooltip"));
        CPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.cdt.ui.alphab_sort_co.gif");
        this.fTreeViewer = treeViewer;
        this.fSorter = new LexicalCSorter();
        boolean checked = CUIPlugin.getDefault().getDialogSettings().getBoolean(DIALOG_STORE_KEY);
        this.valueChanged(checked, false);
    }

    public void run() {
        this.valueChanged(this.isChecked(), true);
    }

    private void valueChanged(boolean on, boolean store) {
        this.setChecked(on);
        this.fTreeViewer.setSorter((ViewerSorter)(on ? this.fSorter : null));
        String key = "LexicalSortingAction.tooltip" + (on ? ".on" : ".off");
        this.setToolTipText(CUIPlugin.getResourceString(key));
        if (store) {
            CUIPlugin.getDefault().getDialogSettings().put(DIALOG_STORE_KEY, on);
        }
    }

    private class LexicalCSorter
    extends ViewerSorter {
        private LexicalCSorter() {
        }

        public boolean isSorterProperty(Object element, Object property) {
            return true;
        }

        public int category(Object obj) {
            if (obj instanceof ICElement) {
                ICElement elem = (ICElement)obj;
                switch (elem.getElementType()) {
                    case 79: {
                        return 2;
                    }
                    case 75: {
                        return 3;
                    }
                    case 62: {
                        return 4;
                    }
                    case 80: {
                        return 10;
                    }
                    case 64: 
                    case 65: 
                    case 82: 
                    case 83: {
                        return 11;
                    }
                    case 66: 
                    case 67: 
                    case 84: 
                    case 85: {
                        return 12;
                    }
                    case 68: 
                    case 69: 
                    case 86: 
                    case 87: {
                        return 13;
                    }
                    case 63: {
                        return 14;
                    }
                    case 76: 
                    case 77: {
                        return 20;
                    }
                    case 72: {
                        return 21;
                    }
                    case 73: 
                    case 74: 
                    case 88: 
                    case 89: {
                        return 22;
                    }
                    case 70: 
                    case 71: 
                    case 90: 
                    case 91: {
                        return 23;
                    }
                    case 61: {
                        return 30;
                    }
                }
            } else if (obj instanceof CElementGrouping) {
                return 0;
            }
            return 100;
        }
    }
}

